/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cache;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.gravitino.Config;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cache.EntityCache;
import org.apache.gravitino.cache.EntityCacheKey;

public abstract class BaseEntityCache
implements EntityCache {
    protected final Config cacheConfig;

    public BaseEntityCache(Config config) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"Config must not be null");
        this.cacheConfig = config;
    }

    public static NameIdentifier getIdentFromEntity(Entity entity) {
        BaseEntityCache.validateEntityHasIdentifier(entity);
        HasIdentifier hasIdentifier = (HasIdentifier)((Object)entity);
        return hasIdentifier.nameIdentifier();
    }

    protected static void validateEntityHasIdentifier(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((boolean)(entity instanceof HasIdentifier), (Object)("Unsupported EntityType: " + String.valueOf((Object)entity.type())));
    }

    public static <E extends Entity & HasIdentifier> List<E> convertEntities(List<Entity> entities) {
        entities.forEach(BaseEntityCache::validateEntityHasIdentifier);
        return entities;
    }

    public static <E extends Entity & HasIdentifier> E convertEntity(Entity entity) {
        BaseEntityCache.validateEntityHasIdentifier(entity);
        return (E)entity;
    }

    protected abstract void invalidateExpiredItem(EntityCacheKey var1);
}

