/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.event;

import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.listener.api.event.OperationType;
import org.apache.gravitino.listener.api.event.TagEvent;
import org.apache.gravitino.utils.MetadataObjectUtil;

@DeveloperApi
public final class AssociateTagsForMetadataObjectEvent
extends TagEvent {
    private final MetadataObject.Type objectType;
    private final String[] tagsToAdd;
    private final String[] tagsToRemove;
    private final String[] associatedTags;

    public AssociateTagsForMetadataObjectEvent(String user, String metalake, MetadataObject metadataObject, String[] tagsToAdd, String[] tagsToRemove, String[] associatedTags) {
        super(user, MetadataObjectUtil.toEntityIdent(metalake, metadataObject));
        this.objectType = metadataObject.type();
        this.tagsToAdd = tagsToAdd != null ? (String[])tagsToAdd.clone() : new String[]{};
        this.tagsToRemove = tagsToRemove != null ? (String[])tagsToRemove.clone() : new String[]{};
        this.associatedTags = associatedTags != null ? (String[])associatedTags.clone() : new String[]{};
    }

    public MetadataObject.Type objectType() {
        return this.objectType;
    }

    public String[] tagsToAdd() {
        return this.tagsToAdd;
    }

    public String[] tagsToRemove() {
        return this.tagsToRemove;
    }

    public String[] associatedTags() {
        return this.associatedTags;
    }

    @Override
    public OperationType operationType() {
        return OperationType.ASSOCIATE_TAGS_FOR_METADATA_OBJECT;
    }
}

