/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.event;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.listener.api.event.OperationType;
import org.apache.gravitino.listener.api.event.RoleFailureEvent;
import org.apache.gravitino.utils.NameIdentifierUtil;

@DeveloperApi
public class RevokePrivilegesFailureEvent
extends RoleFailureEvent {
    private final String roleName;
    private final MetadataObject metadataObject;
    private final Set<Privilege> privileges;

    public RevokePrivilegesFailureEvent(String user, String metalake, Exception exception, String roleName, MetadataObject metadataObject, Set<Privilege> privileges) {
        super(user, NameIdentifierUtil.ofRole(metalake, roleName), exception);
        this.roleName = roleName;
        this.metadataObject = metadataObject;
        this.privileges = privileges == null ? ImmutableSet.of() : ImmutableSet.copyOf(privileges);
    }

    public String roleName() {
        return this.roleName;
    }

    public MetadataObject metadataObject() {
        return this.metadataObject;
    }

    public Set<Privilege> privileges() {
        return this.privileges;
    }

    @Override
    public OperationType operationType() {
        return OperationType.REVOKE_PRIVILEGES;
    }
}

