/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.info;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.SecurableObject;

@DeveloperApi
public class RoleInfo {
    private final String roleName;
    private final Map<String, String> properties;
    private final List<SecurableObject> securableObjects;

    public RoleInfo(Role roleObject) {
        this.roleName = roleObject.name();
        this.properties = roleObject.properties() == null ? ImmutableMap.of() : ImmutableMap.copyOf((Map)roleObject.properties());
        this.securableObjects = roleObject.securableObjects() == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)roleObject.securableObjects());
    }

    public RoleInfo(String roleName, Map<String, String> properties, List<SecurableObject> securableObjects) {
        this.roleName = roleName;
        this.properties = properties == null ? ImmutableMap.of() : ImmutableMap.copyOf(properties);
        this.securableObjects = securableObjects == null ? ImmutableList.of() : ImmutableList.copyOf(securableObjects);
    }

    public String roleName() {
        return this.roleName;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public List<SecurableObject> securableObjects() {
        return this.securableObjects;
    }
}

