/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import java.util.List;
import org.apache.gravitino.storage.relational.mapper.provider.base.PolicyMetadataObjectRelBaseSQLProvider;
import org.apache.ibatis.annotations.Param;

public class PolicyMetadataObjectRelPostgreSQLProvider
extends PolicyMetadataObjectRelBaseSQLProvider {
    private static final String DELETED_AT_NOW_EXPRESSION = " CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT)";

    @Override
    public String softDeletePolicyMetadataObjectRelsByMetalakeAndPolicyName(String metalakeName, String policyName) {
        return "UPDATE policy_relation_meta te SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE te.policy_id IN (SELECT tm.policy_id FROM policy_meta tm WHERE tm.metalake_id IN (SELECT mm.metalake_id FROM metalake_meta mm WHERE mm.metalake_name = #{metalakeName} AND mm.deleted_at = 0) AND tm.policy_name = #{policyName} AND tm.deleted_at = 0) AND te.deleted_at = 0";
    }

    @Override
    public String softDeletePolicyMetadataObjectRelsByMetalakeId(Long metalakeId) {
        return "UPDATE policy_relation_meta te SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE te.policy_id IN (SELECT tm.policy_id FROM policy_meta tm WHERE tm.metalake_id = #{metalakeId} AND tm.deleted_at = 0) AND te.deleted_at = 0";
    }

    @Override
    public String softDeletePolicyMetadataObjectRelsByMetadataObject(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType) {
        return "UPDATE policy_relation_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE metadata_object_id = #{metadataObjectId} AND deleted_at = 0 AND metadata_object_type = #{metadataObjectType}";
    }

    @Override
    public String softDeletePolicyMetadataObjectRelsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return "UPDATE policy_relation_meta pe SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) FROM policy_relation_meta pe_alias LEFT JOIN catalog_meta ct ON pe_alias.metadata_object_id = ct.catalog_id AND pe_alias.metadata_object_type = 'CATALOG' LEFT JOIN schema_meta st ON pe_alias.metadata_object_id = st.schema_id AND pe_alias.metadata_object_type = 'SCHEMA' LEFT JOIN topic_meta tt ON pe_alias.metadata_object_id = tt.topic_id AND pe_alias.metadata_object_type = 'TOPIC' LEFT JOIN table_meta tat ON pe_alias.metadata_object_id = tat.table_id AND pe_alias.metadata_object_type = 'TABLE' LEFT JOIN fileset_meta ft ON pe_alias.metadata_object_id = ft.fileset_id AND pe_alias.metadata_object_type = 'FILESET' LEFT JOIN model_meta mt ON pe_alias.metadata_object_id = mt.model_id AND pe_alias.metadata_object_type = 'MODEL' WHERE pe.id = pe_alias.id AND pe.deleted_at = 0 AND (   ct.catalog_id = #{catalogId} OR st.catalog_id = #{catalogId} OR tt.catalog_id = #{catalogId}   OR tat.catalog_id = #{catalogId} OR ft.catalog_id = #{catalogId} OR mt.catalog_id = #{catalogId} )";
    }

    @Override
    public String softDeletePolicyMetadataObjectRelsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return "UPDATE policy_relation_meta pe SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) FROM policy_relation_meta pe_alias LEFT JOIN schema_meta st ON pe_alias.metadata_object_id = st.schema_id AND pe_alias.metadata_object_type = 'SCHEMA' LEFT JOIN topic_meta tt ON pe_alias.metadata_object_id = tt.topic_id AND pe_alias.metadata_object_type = 'TOPIC' LEFT JOIN table_meta tat ON pe_alias.metadata_object_id = tat.table_id AND pe_alias.metadata_object_type = 'TABLE' LEFT JOIN fileset_meta ft ON pe_alias.metadata_object_id = ft.fileset_id AND pe_alias.metadata_object_type = 'FILESET' LEFT JOIN model_meta mt ON pe_alias.metadata_object_id = mt.model_id AND pe_alias.metadata_object_type = 'MODEL' WHERE pe.id = pe_alias.id AND pe.deleted_at = 0 AND (   st.schema_id = #{schemaId} OR tt.schema_id = #{schemaId} OR tat.schema_id = #{schemaId}   OR ft.schema_id = #{schemaId} OR mt.schema_id = #{schemaId} )";
    }

    @Override
    public String softDeletePolicyMetadataObjectRelsByTableId(@Param(value="tableId") Long tableId) {
        return "UPDATE policy_relation_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE deleted_at = 0 AND (   (metadata_object_id = #{tableId} AND metadata_object_type = 'TABLE') OR    metadata_object_id IN (SELECT column_id FROM table_column_version_info WHERE table_id = #{tableId} AND deleted_at = 0) AND metadata_object_type = 'COLUMN')";
    }

    @Override
    public String batchDeletePolicyMetadataObjectRelsByPolicyIdsAndMetadataObject(Long metadataObjectId, String metadataObjectType, List<Long> policyIds) {
        return "<script>UPDATE policy_relation_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE policy_id IN <foreach item='policyId' collection='policyIds' open='(' separator=',' close=')'>#{policyId}</foreach> AND metadata_object_id = #{metadataObjectId} AND metadata_object_type = #{metadataObjectType} AND deleted_at = 0</script>";
    }

    @Override
    public String listPolicyMetadataObjectRelsByMetalakeAndPolicyName(String metalakeName, String policyName) {
        return "SELECT te.policy_id as policyId, te.metadata_object_id as metadataObjectId, te.metadata_object_type as metadataObjectType, te.audit_info as auditInfo, te.current_version as currentVersion, te.last_version as lastVersion, te.deleted_at as deletedAt FROM policy_relation_meta te JOIN policy_meta tm ON te.policy_id = tm.policy_id JOIN metalake_meta mm ON tm.metalake_id = mm.metalake_id WHERE mm.metalake_name = #{metalakeName} AND tm.policy_name = #{policyName} AND te.deleted_at = 0 AND tm.deleted_at = 0 AND mm.deleted_at = 0";
    }

    @Override
    public String deletePolicyEntityRelsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM policy_relation_meta WHERE id IN (SELECT id FROM policy_relation_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit})";
    }
}

