/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortCharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.ImmutableCharShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableShortCharMap;
import org.eclipse.collections.api.map.primitive.ShortCharMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.ShortCharPair;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.CharBags;
import org.eclipse.collections.impl.factory.primitive.CharShortMaps;
import org.eclipse.collections.impl.factory.primitive.ShortCharMaps;
import org.eclipse.collections.impl.factory.primitive.ShortLists;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.ShortCharHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableShortCharSingletonMap
implements ImmutableShortCharMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_VALUE = '\u0000';
    private final short key1;
    private final char value1;

    ImmutableShortCharSingletonMap(short key1, char value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public char get(short key) {
        return this.getIfAbsent(key, '\u0000');
    }

    public char getIfAbsent(short key, char ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public char getOrThrow(short key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(short key) {
        return this.key1 == key;
    }

    public boolean containsValue(char value) {
        return this.value1 == value;
    }

    public void forEachValue(CharProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(ShortProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ShortCharProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyShortIterable keysView() {
        return ShortLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ShortCharPair> keyValuesView() {
        return Lists.immutable.of((Object)PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableCharShortMap flipUniqueValues() {
        return CharShortMaps.immutable.with(this.value1, this.key1);
    }

    public ImmutableShortCharMap select(ShortCharPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? ShortCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new ShortCharHashMap().toImmutable();
    }

    public ImmutableShortCharMap reject(ShortCharPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new ShortCharHashMap().toImmutable() : ShortCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public RichIterable<CharIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.mutable.with((Object[])new CharIterable[]{CharBags.immutable.with(this.value1)});
    }

    public ImmutableShortCharMap toImmutable() {
        return this;
    }

    public CharIterator charIterator() {
        return new UnmodifiableCharIterator((CharIterator)ShortCharHashMap.newWithKeysValues(this.key1, this.value1).charIterator());
    }

    public void each(CharProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(CharPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public char min() {
        return this.value1;
    }

    public char max() {
        return this.value1;
    }

    public char maxIfEmpty(char defaultValue) {
        return this.value1;
    }

    public char minIfEmpty(char defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public char[] toSortedArray() {
        return new char[]{this.value1};
    }

    public MutableCharList toSortedList() {
        return CharArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableCharBag select(CharPredicate predicate) {
        return predicate.accept(this.value1) ? CharHashBag.newBagWith(this.value1).toImmutable() : CharBags.immutable.empty();
    }

    public ImmutableCharBag reject(CharPredicate predicate) {
        return predicate.accept(this.value1) ? CharBags.immutable.empty() : CharHashBag.newBagWith(this.value1).toImmutable();
    }

    public <V> ImmutableBag<V> collect(CharToObjectFunction<? extends V> function) {
        return Bags.immutable.of(function.valueOf(this.value1));
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public char[] toArray() {
        return new char[]{this.value1};
    }

    public char[] toArray(char[] target) {
        if (target.length < 1) {
            target = new char[]{this.value1};
        } else {
            target[0] = this.value1;
        }
        return target;
    }

    public boolean contains(char value) {
        return this.value1 == value;
    }

    public boolean containsAll(char ... source) {
        for (char value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(CharIterable source) {
        CharIterator iterator = source.charIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableCharList toList() {
        return CharArrayList.newListWith(this.value1);
    }

    public MutableCharSet toSet() {
        return CharHashSet.newSetWith(this.value1);
    }

    public MutableCharBag toBag() {
        return CharHashBag.newBagWith(this.value1);
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public ImmutableShortCharMap newWithKeyValue(short key, char value) {
        return ShortCharMaps.immutable.withAll((ShortCharMap)ShortCharHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableShortCharMap newWithoutKey(short key) {
        return this.key1 == key ? ShortCharMaps.immutable.with() : this;
    }

    public ImmutableShortCharMap newWithoutAllKeys(ShortIterable keys) {
        return keys.contains(this.key1) ? ShortCharMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableShortSet keySet() {
        return UnmodifiableShortSet.of(ShortHashSet.newSetWith(this.key1));
    }

    public MutableCharCollection values() {
        return UnmodifiableCharCollection.of((MutableCharCollection)CharArrayList.newListWith(this.value1));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShortCharMap)) {
            return false;
        }
        ShortCharMap map = (ShortCharMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return this.key1 ^ this.value1;
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

