/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lance.common.ops.gravitino;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.gravitino.connector.DataTypeConverter;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;

public class LanceDataTypeConverter
implements DataTypeConverter<ArrowType, Field> {
    public static final LanceDataTypeConverter CONVERTER = new LanceDataTypeConverter();
    private static final ObjectMapper mapper = new ObjectMapper();

    public Field toArrowField(String name, Type type, boolean nullable) {
        switch (type.name()) {
            case LIST: {
                Types.ListType listType = (Types.ListType)type;
                FieldType listField = new FieldType(nullable, (ArrowType)ArrowType.List.INSTANCE, null);
                return new Field(name, listField, (List)Lists.newArrayList((Object[])new Field[]{this.toArrowField("element", listType.elementType(), listType.elementNullable())}));
            }
            case STRUCT: {
                Types.StructType structType = (Types.StructType)type;
                FieldType structField = new FieldType(nullable, (ArrowType)ArrowType.Struct.INSTANCE, null);
                return new Field(name, structField, Arrays.stream(structType.fields()).map(field -> this.toArrowField(field.name(), field.type(), field.nullable())).toList());
            }
            case MAP: {
                Types.MapType mapType = (Types.MapType)type;
                FieldType mapField = new FieldType(nullable, (ArrowType)new ArrowType.Map(false), null);
                return new Field(name, mapField, (List)Lists.newArrayList((Object[])new Field[]{this.toArrowField("entries", (Type)Types.StructType.of((Types.StructType.Field[])new Types.StructType.Field[]{Types.StructType.Field.of((String)"key", (Type)mapType.keyType(), (boolean)false, null), Types.StructType.Field.of((String)"value", (Type)mapType.valueType(), (boolean)mapType.valueNullable(), null)}), false)}));
            }
            case UNION: {
                Types.UnionType unionType = (Types.UnionType)type;
                List<Field> types = Arrays.stream(unionType.types()).map(t -> this.toArrowField(t.simpleString(), (Type)t, true)).toList();
                int[] typeIds = types.stream().mapToInt(f -> Types.getMinorTypeForArrowType((ArrowType)f.getType()).ordinal()).toArray();
                FieldType unionField = new FieldType(nullable, (ArrowType)new ArrowType.Union(UnionMode.Sparse, typeIds), null);
                return new Field(name, unionField, types);
            }
            case EXTERNAL: {
                Field field2;
                Types.ExternalType externalType = (Types.ExternalType)type;
                try {
                    field2 = (Field)mapper.readValue(externalType.catalogString(), Field.class);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to parse external type catalog string: " + externalType.catalogString(), e);
                }
                Preconditions.checkArgument((boolean)name.equals(field2.getName()), (String)"expected field name %s but got %s", (Object)name, (Object)field2.getName());
                Preconditions.checkArgument((nullable == field2.isNullable() ? 1 : 0) != 0, (String)"expected field nullable %s but got %s", (Object)nullable, (Object)field2.isNullable());
                return field2;
            }
        }
        FieldType fieldType = new FieldType(nullable, this.fromGravitino(type), null);
        return new Field(name, fieldType, null);
    }

    public ArrowType fromGravitino(Type type) {
        switch (type.name()) {
            case BOOLEAN: {
                return ArrowType.Bool.INSTANCE;
            }
            case BYTE: {
                return new ArrowType.Int(8, ((Types.ByteType)type).signed());
            }
            case SHORT: {
                return new ArrowType.Int(16, ((Types.ShortType)type).signed());
            }
            case INTEGER: {
                return new ArrowType.Int(32, ((Types.IntegerType)type).signed());
            }
            case LONG: {
                return new ArrowType.Int(64, ((Types.LongType)type).signed());
            }
            case FLOAT: {
                return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
            }
            case DOUBLE: {
                return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
            }
            case STRING: {
                return ArrowType.Utf8.INSTANCE;
            }
            case BINARY: {
                return ArrowType.Binary.INSTANCE;
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                return new ArrowType.Decimal(decimalType.precision(), decimalType.scale(), 128);
            }
            case DATE: {
                return new ArrowType.Date(DateUnit.DAY);
            }
            case TIMESTAMP: {
                Types.TimestampType timestampType = (Types.TimestampType)type;
                TimeUnit timeUnit = TimeUnit.MICROSECOND;
                if (timestampType.hasPrecisionSet()) {
                    timeUnit = switch (timestampType.precision()) {
                        case 0 -> TimeUnit.SECOND;
                        case 3 -> TimeUnit.MILLISECOND;
                        case 6 -> TimeUnit.MICROSECOND;
                        case 9 -> TimeUnit.NANOSECOND;
                        default -> throw new UnsupportedOperationException("Expected precision to be one of 0, 3, 6, 9 but got: " + timestampType.precision());
                    };
                }
                if (timestampType.hasTimeZone()) {
                    return new ArrowType.Timestamp(timeUnit, "UTC");
                }
                return new ArrowType.Timestamp(timeUnit, null);
            }
            case TIME: {
                return new ArrowType.Time(TimeUnit.NANOSECOND, 64);
            }
            case NULL: {
                return ArrowType.Null.INSTANCE;
            }
            case INTERVAL_YEAR: {
                return new ArrowType.Interval(IntervalUnit.YEAR_MONTH);
            }
            case INTERVAL_DAY: {
                return new ArrowType.Duration(TimeUnit.MICROSECOND);
            }
            case FIXED: {
                Types.FixedType fixedType = (Types.FixedType)type;
                return new ArrowType.FixedSizeBinary(fixedType.length());
            }
        }
        throw new UnsupportedOperationException("Unsupported Gravitino type: " + String.valueOf(type.name()));
    }

    public Type toGravitino(Field arrowField) {
        String typeString;
        FieldType fieldType = arrowField.getFieldType();
        switch (fieldType.getType().getTypeID()) {
            case Map: {
                Field structField = (Field)arrowField.getChildren().get(0);
                Type keyType = this.toGravitino((Field)structField.getChildren().get(0));
                Type valueType = this.toGravitino((Field)structField.getChildren().get(1));
                boolean valueNullable = ((Field)structField.getChildren().get(1)).isNullable();
                return Types.MapType.of((Type)keyType, (Type)valueType, (boolean)valueNullable);
            }
            case List: {
                Type elementType = this.toGravitino((Field)arrowField.getChildren().get(0));
                boolean containsNull = ((Field)arrowField.getChildren().get(0)).isNullable();
                return Types.ListType.of((Type)elementType, (boolean)containsNull);
            }
            case Struct: {
                Types.StructType.Field[] fields = (Types.StructType.Field[])arrowField.getChildren().stream().map(child -> Types.StructType.Field.of((String)child.getName(), (Type)this.toGravitino((Field)child), (boolean)child.isNullable(), null)).toArray(Types.StructType.Field[]::new);
                return Types.StructType.of((Types.StructType.Field[])fields);
            }
            case Union: {
                List<Type> types = arrowField.getChildren().stream().map(this::toGravitino).toList();
                return Types.UnionType.of((Type[])types.toArray(new Type[0]));
            }
            case Bool: {
                return Types.BooleanType.get();
            }
            case Int: {
                ArrowType.Int intType = (ArrowType.Int)fieldType.getType();
                switch (intType.getBitWidth()) {
                    case 8: {
                        return intType.getIsSigned() ? Types.ByteType.get() : Types.ByteType.unsigned();
                    }
                    case 16: {
                        return intType.getIsSigned() ? Types.ShortType.get() : Types.ShortType.unsigned();
                    }
                    case 32: {
                        return intType.getIsSigned() ? Types.IntegerType.get() : Types.IntegerType.unsigned();
                    }
                    case 64: {
                        return intType.getIsSigned() ? Types.LongType.get() : Types.LongType.unsigned();
                    }
                }
                break;
            }
            case FloatingPoint: {
                ArrowType.FloatingPoint floatingPoint = (ArrowType.FloatingPoint)fieldType.getType();
                switch (floatingPoint.getPrecision()) {
                    case SINGLE: {
                        return Types.FloatType.get();
                    }
                    case DOUBLE: {
                        return Types.DoubleType.get();
                    }
                }
                break;
            }
            case Utf8: {
                return Types.StringType.get();
            }
            case Binary: {
                return Types.BinaryType.get();
            }
            case Decimal: {
                ArrowType.Decimal decimalType = (ArrowType.Decimal)fieldType.getType();
                return Types.DecimalType.of((int)decimalType.getPrecision(), (int)decimalType.getScale());
            }
            case Date: {
                if (((ArrowType.Date)fieldType.getType()).getUnit() != DateUnit.DAY) break;
                return Types.DateType.get();
            }
            case Timestamp: {
                ArrowType.Timestamp timestampType = (ArrowType.Timestamp)fieldType.getType();
                int precision = switch (timestampType.getUnit()) {
                    default -> throw new IncompatibleClassChangeError();
                    case TimeUnit.SECOND -> 0;
                    case TimeUnit.MILLISECOND -> 3;
                    case TimeUnit.MICROSECOND -> 6;
                    case TimeUnit.NANOSECOND -> 9;
                };
                boolean hasTimeZone = timestampType.getTimezone() != null;
                return hasTimeZone ? Types.TimestampType.withTimeZone((int)precision) : Types.TimestampType.withoutTimeZone((int)precision);
            }
            case Time: {
                ArrowType.Time timeType = (ArrowType.Time)fieldType.getType();
                if (timeType.getUnit() != TimeUnit.NANOSECOND || timeType.getBitWidth() != 64) break;
                return Types.TimeType.get();
            }
            case Null: {
                return Types.NullType.get();
            }
            case Interval: {
                IntervalUnit intervalUnit = ((ArrowType.Interval)fieldType.getType()).getUnit();
                if (intervalUnit != IntervalUnit.YEAR_MONTH) break;
                return Types.IntervalYearType.get();
            }
            case Duration: {
                TimeUnit timeUnit = ((ArrowType.Duration)fieldType.getType()).getUnit();
                if (timeUnit != TimeUnit.MICROSECOND) break;
                return Types.IntervalDayType.get();
            }
            case FixedSizeBinary: {
                ArrowType.FixedSizeBinary fixedSizeBinary = (ArrowType.FixedSizeBinary)fieldType.getType();
                return Types.FixedType.of((int)fixedSizeBinary.getByteWidth());
            }
        }
        try {
            typeString = mapper.writeValueAsString((Object)arrowField);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize Arrow field to string.", e);
        }
        return Types.ExternalType.of((String)typeString);
    }
}

