/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.time.Instant;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;

public class GravitinoCatalog {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private final String metalake;
    private final String provider;
    private final String name;
    private final Map<String, String> properties;
    private final long lastModifiedTime;

    public GravitinoCatalog(String metalake, Catalog catalog) {
        this.metalake = metalake;
        this.provider = catalog.provider();
        this.name = catalog.name();
        this.properties = catalog.properties();
        Instant time = catalog.auditInfo().lastModifiedTime() == null ? catalog.auditInfo().createTime() : catalog.auditInfo().lastModifiedTime();
        this.lastModifiedTime = time.toEpochMilli();
    }

    @JsonCreator
    public GravitinoCatalog(@JsonProperty(value="metalake") String metalake, @JsonProperty(value="provider") String provider, @JsonProperty(value="name") String name, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="lastModifiedTime") long lastModifiedTime) {
        this.metalake = metalake;
        this.provider = provider;
        this.name = name;
        this.properties = properties;
        this.lastModifiedTime = lastModifiedTime;
    }

    @JsonProperty
    public String getProvider() {
        return this.provider;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getMetalake() {
        return this.metalake;
    }

    public NameIdentifier geNameIdentifier() {
        return NameIdentifier.of((String[])new String[]{this.metalake, this.name});
    }

    public String getProperty(String name, String defaultValue) {
        return this.properties.getOrDefault(name, defaultValue);
    }

    public String getRequiredProperty(String name) throws Exception {
        String value = this.properties.getOrDefault(name, "");
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_MISSING_CONFIG, "Missing required config: " + name);
        }
        return value;
    }

    @JsonProperty
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty
    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public static String toJson(GravitinoCatalog catalog) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)catalog);
    }

    public static GravitinoCatalog fromJson(String jsonString) throws JsonProcessingException {
        return (GravitinoCatalog)objectMapper.readValue(jsonString, GravitinoCatalog.class);
    }

    public String getRegion() {
        return this.properties.getOrDefault("cloud.region-code", "");
    }

    public boolean isSameRegion(String region) {
        return StringUtils.isEmpty((CharSequence)region) || StringUtils.isEmpty((CharSequence)this.getRegion()) || region.equals(this.getRegion());
    }

    static {
        objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_CREATORS})).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS})).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_SETTERS})).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_GETTERS})).build();
    }
}

