/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.janitor;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.janitor.MetaFixer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestMetaFixerNoCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaFixerNoCluster.class);
    private static byte[] A = Bytes.toBytes((String)"a");
    private static byte[] B = Bytes.toBytes((String)"b");
    private static byte[] C = Bytes.toBytes((String)"c");
    private static byte[] D = Bytes.toBytes((String)"d");
    private static RegionInfo ALL = RegionInfoBuilder.FIRST_META_REGIONINFO;
    private static RegionInfo _ARI = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setEndKey(A).build();
    private static RegionInfo _BRI = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setEndKey(B).build();
    private static RegionInfo ABRI = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(A).setEndKey(B).build();
    private static RegionInfo ACRI = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(A).setEndKey(C).build();
    private static RegionInfo CDRI = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(C).setEndKey(D).build();
    private static RegionInfo ADRI = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(A).setEndKey(D).build();
    private static RegionInfo D_RI = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(D).build();
    private static RegionInfo C_RI = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(C).build();

    @Test
    public void testGetRegionInfoWithLargestEndKey() {
        Assert.assertTrue((boolean)MetaFixer.getRegionInfoWithLargestEndKey((RegionInfo)_ARI, (RegionInfo)_BRI).equals(_BRI));
        Assert.assertTrue((boolean)MetaFixer.getRegionInfoWithLargestEndKey((RegionInfo)C_RI, (RegionInfo)D_RI).equals(C_RI));
        Assert.assertTrue((boolean)MetaFixer.getRegionInfoWithLargestEndKey((RegionInfo)ABRI, (RegionInfo)CDRI).equals(CDRI));
        Assert.assertTrue((boolean)MetaFixer.getRegionInfoWithLargestEndKey(null, (RegionInfo)CDRI).equals(CDRI));
        Assert.assertTrue((MetaFixer.getRegionInfoWithLargestEndKey(null, null) == null ? 1 : 0) != 0);
    }

    @Test
    public void testIsOverlap() {
        Assert.assertTrue((boolean)MetaFixer.isOverlap((RegionInfo)_BRI, (Pair)new Pair((Object)ABRI, (Object)ACRI)));
        Assert.assertFalse((boolean)MetaFixer.isOverlap((RegionInfo)_ARI, (Pair)new Pair((Object)C_RI, (Object)D_RI)));
        Assert.assertTrue((boolean)MetaFixer.isOverlap((RegionInfo)ADRI, (Pair)new Pair((Object)CDRI, (Object)C_RI)));
        Assert.assertFalse((boolean)MetaFixer.isOverlap((RegionInfo)_BRI, (Pair)new Pair((Object)CDRI, (Object)C_RI)));
    }

    @Test
    public void testCalculateMergesNoAggregation() {
        ArrayList<Pair> overlaps = new ArrayList<Pair>();
        overlaps.add(new Pair((Object)_ARI, (Object)_BRI));
        overlaps.add(new Pair((Object)C_RI, (Object)D_RI));
        List merges = MetaFixer.calculateMerges((int)10, overlaps);
        Assert.assertEquals((long)2L, (long)merges.size());
        Assert.assertEquals((long)2L, (long)((SortedSet)merges.get(0)).size());
        Assert.assertEquals((long)2L, (long)((SortedSet)merges.get(1)).size());
    }

    @Test
    public void testCalculateMergesAggregation() {
        ArrayList<Pair> overlaps = new ArrayList<Pair>();
        overlaps.add(new Pair((Object)ALL, (Object)D_RI));
        overlaps.add(new Pair((Object)_ARI, (Object)_BRI));
        overlaps.add(new Pair((Object)C_RI, (Object)D_RI));
        List merges = MetaFixer.calculateMerges((int)10, overlaps);
        Assert.assertEquals((long)1L, (long)merges.size());
        Assert.assertEquals((long)5L, (long)((SortedSet)merges.get(0)).size());
    }

    @Test
    public void testCalculateMergesNoRepeatOfRegionNames() {
        ArrayList<Pair> overlaps = new ArrayList<Pair>();
        overlaps.add(new Pair((Object)_BRI, (Object)ABRI));
        overlaps.add(new Pair((Object)ABRI, (Object)ADRI));
        List merges = MetaFixer.calculateMerges((int)10, overlaps);
        Assert.assertEquals((long)1L, (long)merges.size());
        Assert.assertEquals((long)3L, (long)((SortedSet)merges.get(0)).size());
    }

    @Test
    public void testCalculateMergesRespectsMax() {
        ArrayList<Pair> overlaps = new ArrayList<Pair>();
        overlaps.add(new Pair((Object)_BRI, (Object)ABRI));
        overlaps.add(new Pair((Object)ABRI, (Object)ADRI));
        overlaps.add(new Pair((Object)C_RI, (Object)D_RI));
        List merges = MetaFixer.calculateMerges((int)3, overlaps);
        Assert.assertEquals((long)2L, (long)merges.size());
        Assert.assertEquals((long)3L, (long)((SortedSet)merges.get(0)).size());
        Assert.assertEquals((long)2L, (long)((SortedSet)merges.get(1)).size());
    }
}

