/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestSpaceQuotaBasicFunctioning {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSpaceQuotaBasicFunctioning.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSpaceQuotaBasicFunctioning.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int NUM_RETRIES = 10;
    @Rule
    public TestName testName = new TestName();
    private SpaceQuotaHelperForTests helper;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void removeAllQuotas() throws Exception {
        this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, new AtomicLong(0L));
        this.helper.removeAllQuotas();
    }

    @Test
    public void testNoInsertsWithPut() throws Exception {
        Put p = new Put(Bytes.toBytes((String)"to_reject"));
        p.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        this.helper.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_INSERTS, (Mutation)p);
    }

    @Test
    public void testNoInsertsWithAppend() throws Exception {
        Append a = new Append(Bytes.toBytes((String)"to_reject"));
        a.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        this.helper.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_INSERTS, (Mutation)a);
    }

    @Test
    public void testNoInsertsWithIncrement() throws Exception {
        Increment i = new Increment(Bytes.toBytes((String)"to_reject"));
        i.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"count"), 0L);
        this.helper.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_INSERTS, (Mutation)i);
    }

    @Test
    public void testDeletesAfterNoInserts() throws Exception {
        TableName tn = this.helper.writeUntilViolation(SpaceViolationPolicy.NO_INSERTS);
        Delete d = new Delete(Bytes.toBytes((String)"should_not_be_rejected"));
        for (int i = 0; i < 10; ++i) {
            try (Table t = TEST_UTIL.getConnection().getTable(tn);){
                t.delete(d);
                continue;
            }
        }
    }

    @Test
    public void testNoWritesWithPut() throws Exception {
        Put p = new Put(Bytes.toBytes((String)"to_reject"));
        p.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        this.helper.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_WRITES, (Mutation)p);
    }

    @Test
    public void testNoWritesWithAppend() throws Exception {
        Append a = new Append(Bytes.toBytes((String)"to_reject"));
        a.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        this.helper.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_WRITES, (Mutation)a);
    }

    @Test
    public void testNoWritesWithIncrement() throws Exception {
        Increment i = new Increment(Bytes.toBytes((String)"to_reject"));
        i.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"count"), 0L);
        this.helper.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_WRITES, (Mutation)i);
    }

    @Test
    public void testNoWritesWithDelete() throws Exception {
        Delete d = new Delete(Bytes.toBytes((String)"to_reject"));
        this.helper.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_WRITES, (Mutation)d);
    }

    @Test
    public void testNoCompactions() throws Exception {
        Put p = new Put(Bytes.toBytes((String)"to_reject"));
        p.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        TableName tn = this.helper.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_WRITES_COMPACTIONS, (Mutation)p);
        try {
            TEST_UTIL.getAdmin().majorCompact(tn);
            Assert.fail((String)"Expected that invoking the compaction should throw an Exception");
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
        try {
            TEST_UTIL.getAdmin().compact(tn);
            Assert.fail((String)"Expected that invoking the compaction should throw an Exception");
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
    }

    @Test
    public void testNoEnableAfterDisablePolicy() throws Exception {
        Put p = new Put(Bytes.toBytes((String)"to_reject"));
        p.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        TableName tn = this.helper.writeUntilViolation(SpaceViolationPolicy.DISABLE);
        Admin admin = TEST_UTIL.getAdmin();
        for (int i = 0; i < 20; ++i) {
            if (!admin.isTableEnabled(tn)) continue;
            LOG.info(tn + " is still enabled, expecting it to be disabled. Will wait and re-check.");
            Thread.sleep(2000L);
        }
        Assert.assertFalse((String)(tn + " is still enabled but it should be disabled"), (boolean)admin.isTableEnabled(tn));
        try {
            admin.enableTable(tn);
        }
        catch (AccessDeniedException e) {
            String exceptionContents = StringUtils.stringifyException((Throwable)e);
            String expectedText = "violated space quota";
            Assert.assertTrue((String)("Expected the exception to contain violated space quota, but was: " + exceptionContents), (boolean)exceptionContents.contains("violated space quota"));
        }
    }

    @Test
    public void testTableQuotaOverridesNamespaceQuota() throws Exception {
        SpaceViolationPolicy policy = SpaceViolationPolicy.NO_INSERTS;
        TableName tn = this.helper.createTableWithRegions(10);
        long tableLimit = 0x200000L;
        long namespaceLimit = 0x40000000L;
        TEST_UTIL.getAdmin().setQuota(QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x200000L, (SpaceViolationPolicy)policy));
        TEST_UTIL.getAdmin().setQuota(QuotaSettingsFactory.limitNamespaceSpace((String)tn.getNamespaceAsString(), (long)0x40000000L, (SpaceViolationPolicy)policy));
        this.helper.writeData(tn, 0x300000L);
        Thread.sleep(5000L);
        Put p = new Put(Bytes.toBytes((String)"to_reject"));
        p.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        this.helper.verifyViolation(policy, tn, (Mutation)p);
    }

    @Test
    public void testDisablePolicyQuotaAndViolate() throws Exception {
        final TableName tableName = this.helper.createTable();
        this.helper.setQuotaLimit(tableName, SpaceViolationPolicy.DISABLE, 1L);
        this.helper.writeData(tableName, 0x200000L);
        TEST_UTIL.getConfiguration().setLong("hbase.master.quotas.region.report.retention.millis", 100L);
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        final MasterQuotaManager quotaManager = master.getMasterQuotaManager();
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                Map regionSizes = quotaManager.snapshotRegionSizes();
                List tableRegions = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)tableName);
                return regionSizes.containsKey(tableRegions.get(0));
            }
        });
        long regionSizes = quotaManager.snapshotRegionSizes().keySet().stream().filter(k -> k.getTable().equals((Object)tableName)).count();
        Assert.assertTrue((regionSizes > 0L ? 1 : 0) != 0);
    }
}

