/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestRegionObserverScannerOpenHook {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionObserverScannerOpenHook.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    static final Path DIR = UTIL.getDataTestDir();
    @Rule
    public TestName name = new TestName();
    private static final InternalScanner NO_DATA = new InternalScanner(){

        public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
            return false;
        }

        public void close() throws IOException {
        }
    };

    HRegion initHRegion(byte[] tableName, String callingMethod, Configuration conf, byte[] ... families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        for (byte[] family : families) {
            htd.addFamily(new HColumnDescriptor(family));
        }
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        Path path = new Path(DIR + callingMethod);
        WAL wal = HBaseTestingUtility.createWal(conf, path, (RegionInfo)info);
        HRegion r = HRegion.createHRegion((RegionInfo)info, (Path)path, (Configuration)conf, (TableDescriptor)htd, (WAL)wal);
        RegionCoprocessorHost host = new RegionCoprocessorHost(r, null, conf);
        r.setCoprocessorHost(host);
        return r;
    }

    @Test
    public void testRegionObserverScanTimeStacking() throws Exception {
        byte[] ROW = Bytes.toBytes((String)"testRow");
        byte[] TABLE = Bytes.toBytes((String)this.getClass().getName());
        byte[] A = Bytes.toBytes((String)"A");
        byte[][] FAMILIES = new byte[][]{A};
        Configuration conf = new HBaseTestingUtility().getConfiguration();
        HRegion region = this.initHRegion(TABLE, this.getClass().getName(), conf, FAMILIES);
        RegionCoprocessorHost h = region.getCoprocessorHost();
        h.load(NoDataFromScan.class, 0, conf);
        h.load(EmptyRegionObsever.class, 0x3FFFFFFF, conf);
        Put put = new Put(ROW);
        put.addColumn(A, A, A);
        region.put(put);
        Get get = new Get(ROW);
        Result r = region.get(get);
        Assert.assertNull((String)("Got an unexpected number of rows - no data should be returned with the NoDataFromScan coprocessor. Found: " + r), (Object)r.listCells());
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test
    public void testRegionObserverFlushTimeStacking() throws Exception {
        byte[] ROW = Bytes.toBytes((String)"testRow");
        byte[] TABLE = Bytes.toBytes((String)this.getClass().getName());
        byte[] A = Bytes.toBytes((String)"A");
        byte[][] FAMILIES = new byte[][]{A};
        Configuration conf = new HBaseTestingUtility().getConfiguration();
        HRegion region = this.initHRegion(TABLE, this.getClass().getName(), conf, FAMILIES);
        RegionCoprocessorHost h = region.getCoprocessorHost();
        h.load(NoDataFromFlush.class, 0, conf);
        h.load(EmptyRegionObsever.class, 0x3FFFFFFF, conf);
        Put put = new Put(ROW);
        put.addColumn(A, A, A);
        region.put(put);
        region.flush(true);
        Get get = new Get(ROW);
        Result r = region.get(get);
        Assert.assertNull((String)("Got an unexpected number of rows - no data should be returned with the NoDataFromScan coprocessor. Found: " + r), (Object)r.listCells());
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test
    public void testRegionObserverCompactionTimeStacking() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setClass("hbase.hregion.impl", CompactionCompletionNotifyingRegion.class, HRegion.class);
        conf.setInt("hbase.hstore.compaction.min", 2);
        UTIL.startMiniCluster();
        byte[] ROW = Bytes.toBytes((String)"testRow");
        byte[] A = Bytes.toBytes((String)"A");
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        desc.addFamily(new HColumnDescriptor(A));
        desc.addCoprocessor(EmptyRegionObsever.class.getName(), null, 0x3FFFFFFF, null);
        desc.addCoprocessor(NoDataFromCompaction.class.getName(), null, 0, null);
        Admin admin = UTIL.getAdmin();
        admin.createTable((TableDescriptor)desc);
        Table table = UTIL.getConnection().getTable(desc.getTableName());
        Put put = new Put(ROW);
        put.addColumn(A, A, A);
        table.put(put);
        HRegionServer rs = UTIL.getRSForFirstRegionInTable(desc.getTableName());
        List regions = rs.getRegions(desc.getTableName());
        Assert.assertEquals((String)"More than 1 region serving test table with 1 row", (long)1L, (long)regions.size());
        Region region = (Region)regions.get(0);
        admin.flushRegion(region.getRegionInfo().getRegionName());
        CountDownLatch latch = ((CompactionCompletionNotifyingRegion)region).getCompactionStateChangeLatch();
        put = new Put(Bytes.toBytes((String)"anotherrow"));
        put.addColumn(A, A, A);
        table.put(put);
        admin.flushRegion(region.getRegionInfo().getRegionName());
        latch.await();
        Get get = new Get(ROW);
        Result r = table.get(get);
        Assert.assertNull((String)("Got an unexpected number of rows - no data should be returned with the NoDataFromScan coprocessor. Found: " + r), (Object)r.listCells());
        get = new Get(Bytes.toBytes((String)"anotherrow"));
        r = table.get(get);
        Assert.assertNull((String)("Got an unexpected number of rows - no data should be returned with the NoDataFromScan coprocessor Found: " + r), (Object)r.listCells());
        table.close();
        UTIL.shutdownMiniCluster();
    }

    public static class CompactionCompletionNotifyingRegion
    extends HRegion {
        private static volatile CountDownLatch compactionStateChangeLatch = null;

        public CompactionCompletionNotifyingRegion(Path tableDir, WAL log, FileSystem fs, Configuration confParam, RegionInfo info, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, log, fs, confParam, info, htd, rsServices);
        }

        public CountDownLatch getCompactionStateChangeLatch() {
            if (compactionStateChangeLatch == null) {
                compactionStateChangeLatch = new CountDownLatch(1);
            }
            return compactionStateChangeLatch;
        }

        public boolean compact(CompactionContext compaction, HStore store, ThroughputController throughputController) throws IOException {
            boolean ret = super.compact(compaction, store, throughputController);
            if (ret) {
                compactionStateChangeLatch.countDown();
            }
            return ret;
        }

        public boolean compact(CompactionContext compaction, HStore store, ThroughputController throughputController, User user) throws IOException {
            boolean ret = super.compact(compaction, store, throughputController, user);
            if (ret) {
                compactionStateChangeLatch.countDown();
            }
            return ret;
        }
    }

    public static class NoDataFromCompaction
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
            return NO_DATA;
        }
    }

    public static class NoDataFromFlush
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public InternalScanner preFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, FlushLifeCycleTracker tracker) throws IOException {
            return NO_DATA;
        }
    }

    public static class NoDataFromScan
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
            c.bypass();
        }

        public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan) throws IOException {
            scan.setFilter((Filter)new NoDataFilter());
        }
    }

    public static class EmptyRegionObsever
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }
    }

    public static class NoDataFilter
    extends FilterBase {
        public Filter.ReturnCode filterCell(Cell ignored) {
            return Filter.ReturnCode.SKIP;
        }

        public boolean filterAllRemaining() throws IOException {
            return true;
        }

        public boolean filterRow() throws IOException {
            return true;
        }
    }
}

