/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.NamespacePermission;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.SnapshotScannerHDFSAclController;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SnapshotScannerHDFSAclHelper
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotScannerHDFSAclHelper.class);
    public static final String ACL_SYNC_TO_HDFS_ENABLE = "hbase.acl.sync.to.hdfs.enable";
    public static final String ACL_SYNC_TO_HDFS_THREAD_NUMBER = "hbase.acl.sync.to.hdfs.thread.number";
    public static final String SNAPSHOT_RESTORE_TMP_DIR = "hbase.snapshot.restore.tmp.dir";
    public static final String SNAPSHOT_RESTORE_TMP_DIR_DEFAULT = "/hbase/.tmpdir-to-restore-snapshot";
    public static final String COMMON_DIRECTORY_PERMISSION = "hbase.acl.sync.to.hdfs.common.directory.permission";
    public static final String COMMON_DIRECTORY_PERMISSION_DEFAULT = "751";
    public static final String SNAPSHOT_RESTORE_DIRECTORY_PERMISSION = "hbase.acl.sync.to.hdfs.restore.directory.permission";
    public static final String SNAPSHOT_RESTORE_DIRECTORY_PERMISSION_DEFAULT = "753";
    private Admin admin;
    private final Configuration conf;
    private FileSystem fs;
    private PathHelper pathHelper;
    private ExecutorService pool;

    public SnapshotScannerHDFSAclHelper(Configuration configuration, Connection connection) throws IOException {
        this.conf = configuration;
        this.pathHelper = new PathHelper(this.conf);
        this.fs = this.pathHelper.getFileSystem();
        this.pool = Executors.newFixedThreadPool(this.conf.getInt(ACL_SYNC_TO_HDFS_THREAD_NUMBER, 10), new ThreadFactoryBuilder().setNameFormat("hdfs-acl-thread-%d").setDaemon(true).build());
        this.admin = connection.getAdmin();
    }

    @Override
    public void close() {
        if (this.pool != null) {
            this.pool.shutdown();
        }
        try {
            this.admin.close();
        }
        catch (IOException e) {
            LOG.error("Close admin error", (Throwable)e);
        }
    }

    public void setCommonDirectoryPermission() throws IOException {
        ArrayList<Path> paths = Lists.newArrayList(this.pathHelper.getRootDir(), this.pathHelper.getMobDir(), this.pathHelper.getTmpDir(), this.pathHelper.getArchiveDir());
        paths.addAll(this.getGlobalRootPaths());
        for (Path path : paths) {
            this.createDirIfNotExist(path);
            this.fs.setPermission(path, new FsPermission(this.conf.get(COMMON_DIRECTORY_PERMISSION, COMMON_DIRECTORY_PERMISSION_DEFAULT)));
        }
        Path restoreDir = new Path(this.conf.get(SNAPSHOT_RESTORE_TMP_DIR, SNAPSHOT_RESTORE_TMP_DIR_DEFAULT));
        this.createDirIfNotExist(restoreDir);
        this.fs.setPermission(restoreDir, new FsPermission(this.conf.get(SNAPSHOT_RESTORE_DIRECTORY_PERMISSION, SNAPSHOT_RESTORE_DIRECTORY_PERMISSION_DEFAULT)));
    }

    public boolean grantAcl(UserPermission userPermission, Set<String> skipNamespaces, Set<TableName> skipTables) {
        try {
            long start = EnvironmentEdgeManager.currentTime();
            this.handleGrantOrRevokeAcl(userPermission, HDFSAclOperation.OperationType.MODIFY, skipNamespaces, skipTables);
            LOG.info("Set HDFS acl when grant {}, skipNamespaces: {}, skipTables: {}, cost {} ms", new Object[]{userPermission, skipNamespaces, skipTables, EnvironmentEdgeManager.currentTime() - start});
            return true;
        }
        catch (Exception e) {
            LOG.error("Set HDFS acl error when grant: {}, skipNamespaces: {}, skipTables: {}", new Object[]{userPermission, skipNamespaces, skipTables, e});
            return false;
        }
    }

    public boolean revokeAcl(UserPermission userPermission, Set<String> skipNamespaces, Set<TableName> skipTables) {
        try {
            long start = EnvironmentEdgeManager.currentTime();
            this.handleGrantOrRevokeAcl(userPermission, HDFSAclOperation.OperationType.REMOVE, skipNamespaces, skipTables);
            LOG.info("Set HDFS acl when revoke {}, skipNamespaces: {}, skipTables: {}, cost {} ms", new Object[]{userPermission, skipNamespaces, skipTables, EnvironmentEdgeManager.currentTime() - start});
            return true;
        }
        catch (Exception e) {
            LOG.error("Set HDFS acl error when revoke: {}, skipNamespaces: {}, skipTables: {}", new Object[]{userPermission, skipNamespaces, skipTables, e});
            return false;
        }
    }

    public boolean snapshotAcl(SnapshotDescription snapshot) {
        try {
            long start = EnvironmentEdgeManager.currentTime();
            TableName tableName = snapshot.getTableName();
            Set<String> userSet = this.getUsersWithTableReadAction(tableName, true, false);
            if (userSet.size() > 0) {
                Path path = this.pathHelper.getSnapshotDir(snapshot.getName());
                this.handleHDFSAcl(new HDFSAclOperation(this.fs, path, userSet, HDFSAclOperation.OperationType.MODIFY, true, HDFSAclOperation.AclType.DEFAULT_ADN_ACCESS)).get();
            }
            LOG.info("Set HDFS acl when snapshot {}, cost {} ms", (Object)snapshot.getName(), (Object)(EnvironmentEdgeManager.currentTime() - start));
            return true;
        }
        catch (Exception e) {
            LOG.error("Set HDFS acl error when snapshot {}", (Object)snapshot, (Object)e);
            return false;
        }
    }

    public boolean removeNamespaceAccessAcl(TableName tableName, Set<String> removeUsers, String operation) {
        try {
            long start = EnvironmentEdgeManager.currentTime();
            if (removeUsers.size() > 0) {
                this.handleNamespaceAccessAcl(tableName.getNamespaceAsString(), removeUsers, HDFSAclOperation.OperationType.REMOVE);
            }
            LOG.info("Remove HDFS acl when {} table {}, cost {} ms", new Object[]{operation, tableName, EnvironmentEdgeManager.currentTime() - start});
            return true;
        }
        catch (Exception e) {
            LOG.error("Remove HDFS acl error when {} table {}", new Object[]{operation, tableName, e});
            return false;
        }
    }

    public boolean removeNamespaceDefaultAcl(String namespace, Set<String> removeUsers) {
        try {
            long start = EnvironmentEdgeManager.currentTime();
            Path archiveNsDir = this.pathHelper.getArchiveNsDir(namespace);
            HDFSAclOperation operation = new HDFSAclOperation(this.fs, archiveNsDir, removeUsers, HDFSAclOperation.OperationType.REMOVE, false, HDFSAclOperation.AclType.DEFAULT);
            operation.handleAcl();
            LOG.info("Remove HDFS acl when delete namespace {}, cost {} ms", (Object)namespace, (Object)(EnvironmentEdgeManager.currentTime() - start));
            return true;
        }
        catch (Exception e) {
            LOG.error("Remove HDFS acl error when delete namespace {}", (Object)namespace, (Object)e);
            return false;
        }
    }

    public boolean removeTableDefaultAcl(TableName tableName, Set<String> removeUsers) {
        try {
            long start = EnvironmentEdgeManager.currentTime();
            Path archiveTableDir = this.pathHelper.getArchiveTableDir(tableName);
            HDFSAclOperation operation = new HDFSAclOperation(this.fs, archiveTableDir, removeUsers, HDFSAclOperation.OperationType.REMOVE, false, HDFSAclOperation.AclType.DEFAULT);
            operation.handleAcl();
            LOG.info("Remove HDFS acl when delete table {}, cost {} ms", (Object)tableName, (Object)(EnvironmentEdgeManager.currentTime() - start));
            return true;
        }
        catch (Exception e) {
            LOG.error("Remove HDFS acl error when delete table {}", (Object)tableName, (Object)e);
            return false;
        }
    }

    public boolean addTableAcl(TableName tableName, Set<String> users, String operation) {
        try {
            long start = EnvironmentEdgeManager.currentTime();
            if (users.size() > 0) {
                HDFSAclOperation.OperationType operationType = HDFSAclOperation.OperationType.MODIFY;
                this.handleNamespaceAccessAcl(tableName.getNamespaceAsString(), users, operationType);
                this.handleTableAcl(Sets.newHashSet(tableName), users, new HashSet<String>(0), new HashSet<TableName>(0), operationType);
            }
            LOG.info("Set HDFS acl when {} table {}, cost {} ms", new Object[]{operation, tableName, EnvironmentEdgeManager.currentTime() - start});
            return true;
        }
        catch (Exception e) {
            LOG.error("Set HDFS acl error when {} table {}", new Object[]{operation, tableName, e});
            return false;
        }
    }

    public boolean removeTableAcl(TableName tableName, Set<String> users) {
        try {
            long start = EnvironmentEdgeManager.currentTime();
            if (users.size() > 0) {
                this.handleTableAcl(Sets.newHashSet(tableName), users, new HashSet<String>(0), new HashSet<TableName>(0), HDFSAclOperation.OperationType.REMOVE);
            }
            LOG.info("Set HDFS acl when create or modify table {}, cost {} ms", (Object)tableName, (Object)(EnvironmentEdgeManager.currentTime() - start));
            return true;
        }
        catch (Exception e) {
            LOG.error("Set HDFS acl error when create or modify table {}", (Object)tableName, (Object)e);
            return false;
        }
    }

    private void handleGrantOrRevokeAcl(UserPermission userPermission, HDFSAclOperation.OperationType operationType, Set<String> skipNamespaces, Set<TableName> skipTables) throws ExecutionException, InterruptedException, IOException {
        HashSet<String> users = Sets.newHashSet(userPermission.getUser());
        switch (userPermission.getAccessScope()) {
            case GLOBAL: {
                this.handleGlobalAcl(users, skipNamespaces, skipTables, operationType);
                break;
            }
            case NAMESPACE: {
                NamespacePermission namespacePermission = (NamespacePermission)userPermission.getPermission();
                this.handleNamespaceAcl(Sets.newHashSet(namespacePermission.getNamespace()), users, skipNamespaces, skipTables, operationType);
                break;
            }
            case TABLE: {
                TablePermission tablePermission = (TablePermission)userPermission.getPermission();
                this.handleNamespaceAccessAcl(tablePermission.getNamespace(), users, operationType);
                this.handleTableAcl(Sets.newHashSet(tablePermission.getTableName()), users, skipNamespaces, skipTables, operationType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal user permission scope " + (Object)((Object)userPermission.getAccessScope()));
            }
        }
    }

    private void handleGlobalAcl(Set<String> users, Set<String> skipNamespaces, Set<TableName> skipTables, HDFSAclOperation.OperationType operationType) throws ExecutionException, InterruptedException, IOException {
        List<HDFSAclOperation> hdfsAclOperations = this.getGlobalRootPaths().stream().map(path -> new HDFSAclOperation(this.fs, (Path)path, users, operationType, false, HDFSAclOperation.AclType.DEFAULT_ADN_ACCESS)).collect(Collectors.toList());
        this.handleHDFSAclParallel(hdfsAclOperations).get();
        this.handleNamespaceAcl(Sets.newHashSet(this.admin.listNamespaces()), users, skipNamespaces, skipTables, operationType);
    }

    private void handleNamespaceAcl(Set<String> namespaces, Set<String> users, Set<String> skipNamespaces, Set<TableName> skipTables, HDFSAclOperation.OperationType operationType) throws ExecutionException, InterruptedException, IOException {
        namespaces.removeAll(skipNamespaces);
        namespaces.remove(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR);
        ArrayList<HDFSAclOperation> hdfsAclOperations = new ArrayList<HDFSAclOperation>();
        Set skipTableNamespaces = skipTables.stream().map(TableName::getNamespaceAsString).collect(Collectors.toSet());
        for (String ns : namespaces) {
            HDFSAclOperation.OperationType op = operationType;
            HDFSAclOperation.AclType aclType = HDFSAclOperation.AclType.DEFAULT_ADN_ACCESS;
            if (operationType == HDFSAclOperation.OperationType.REMOVE && skipTableNamespaces.contains(ns)) {
                op = HDFSAclOperation.OperationType.REMOVE;
                aclType = HDFSAclOperation.AclType.DEFAULT;
            }
            for (Path path : this.getNamespaceRootPaths(ns)) {
                hdfsAclOperations.add(new HDFSAclOperation(this.fs, path, users, op, false, aclType));
            }
        }
        this.handleHDFSAclParallel(hdfsAclOperations).get();
        HashSet<TableName> tables = new HashSet<TableName>();
        for (String namespace : namespaces) {
            tables.addAll(this.admin.listTableDescriptorsByNamespace(Bytes.toBytes(namespace)).stream().filter(this::isAclSyncToHdfsEnabled).map(TableDescriptor::getTableName).collect(Collectors.toSet()));
        }
        this.handleTableAcl(tables, users, skipNamespaces, skipTables, operationType);
    }

    private void handleTableAcl(Set<TableName> tableNames, Set<String> users, Set<String> skipNamespaces, Set<TableName> skipTables, HDFSAclOperation.OperationType operationType) throws ExecutionException, InterruptedException, IOException {
        HashSet<TableName> filterTableNames = new HashSet<TableName>();
        for (TableName tableName : tableNames) {
            if (skipTables.contains(tableName) || skipNamespaces.contains(tableName.getNamespaceAsString())) continue;
            filterTableNames.add(tableName);
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (TableName tableName : filterTableNames) {
            List<HDFSAclOperation> hdfsAclOperations = this.getTableRootPaths(tableName, true).stream().map(path -> new HDFSAclOperation(this.fs, (Path)path, users, operationType, true, HDFSAclOperation.AclType.DEFAULT_ADN_ACCESS)).collect(Collectors.toList());
            CompletableFuture<Void> future = this.handleHDFSAclSequential(hdfsAclOperations);
            futures.add(future);
        }
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        completableFuture.get();
    }

    private void handleNamespaceAccessAcl(String namespace, Set<String> users, HDFSAclOperation.OperationType operationType) throws ExecutionException, InterruptedException {
        List<HDFSAclOperation> hdfsAclOperations = this.getNamespaceRootPaths(namespace).stream().map(path -> new HDFSAclOperation(this.fs, (Path)path, users, operationType, false, HDFSAclOperation.AclType.ACCESS)).collect(Collectors.toList());
        CompletableFuture<Void> future = this.handleHDFSAclParallel(hdfsAclOperations);
        future.get();
    }

    void createTableDirectories(TableName tableName) throws IOException {
        List<Path> paths = this.getTableRootPaths(tableName, false);
        for (Path path : paths) {
            this.createDirIfNotExist(path);
        }
    }

    List<Path> getGlobalRootPaths() {
        return Lists.newArrayList(this.pathHelper.getTmpDataDir(), this.pathHelper.getDataDir(), this.pathHelper.getMobDataDir(), this.pathHelper.getArchiveDataDir(), this.pathHelper.getSnapshotRootDir());
    }

    List<Path> getNamespaceRootPaths(String namespace) {
        return Lists.newArrayList(this.pathHelper.getTmpNsDir(namespace), this.pathHelper.getDataNsDir(namespace), this.pathHelper.getMobDataNsDir(namespace), this.pathHelper.getArchiveNsDir(namespace));
    }

    List<Path> getTableRootPaths(TableName tableName, boolean includeSnapshotPath) throws IOException {
        ArrayList<Path> paths = Lists.newArrayList(this.pathHelper.getDataTableDir(tableName), this.pathHelper.getMobTableDir(tableName), this.pathHelper.getArchiveTableDir(tableName));
        if (includeSnapshotPath) {
            paths.addAll(this.getTableSnapshotPaths(tableName));
        }
        return paths;
    }

    private List<Path> getTableSnapshotPaths(TableName tableName) throws IOException {
        return this.admin.listSnapshots().stream().filter(snapDesc -> snapDesc.getTableName().equals(tableName)).map(snapshotDescription -> this.pathHelper.getSnapshotDir(snapshotDescription.getName())).collect(Collectors.toList());
    }

    private Set<String> getUsersWithGlobalReadAction() throws IOException {
        return this.getUsersWithReadAction(PermissionStorage.getGlobalPermissions(this.conf));
    }

    Set<String> getUsersWithNamespaceReadAction(String namespace, boolean includeGlobal) throws IOException {
        Set<String> users = this.getUsersWithReadAction(PermissionStorage.getNamespacePermissions(this.conf, namespace));
        if (includeGlobal) {
            users.addAll(this.getUsersWithGlobalReadAction());
        }
        return users;
    }

    Set<String> getUsersWithTableReadAction(TableName tableName, boolean includeNamespace, boolean includeGlobal) throws IOException {
        Set<String> users = this.getUsersWithReadAction(PermissionStorage.getTablePermissions(this.conf, tableName));
        if (includeNamespace) {
            users.addAll(this.getUsersWithNamespaceReadAction(tableName.getNamespaceAsString(), includeGlobal));
        }
        return users;
    }

    private Set<String> getUsersWithReadAction(ListMultimap<String, UserPermission> permissionMultimap) {
        return permissionMultimap.entries().stream().filter(entry -> this.checkUserPermission((UserPermission)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private boolean checkUserPermission(UserPermission userPermission) {
        boolean result = this.containReadAction(userPermission);
        if (result && userPermission.getPermission() instanceof TablePermission) {
            result = this.isNotFamilyOrQualifierPermission((TablePermission)userPermission.getPermission());
        }
        return result;
    }

    boolean containReadAction(UserPermission userPermission) {
        return userPermission.getPermission().implies(Permission.Action.READ);
    }

    boolean isNotFamilyOrQualifierPermission(TablePermission tablePermission) {
        return !tablePermission.hasFamily() && !tablePermission.hasQualifier();
    }

    public static boolean isAclSyncToHdfsEnabled(Configuration conf) {
        String[] masterCoprocessors = conf.getStrings("hbase.coprocessor.master.classes");
        HashSet masterCoprocessorSet = new HashSet();
        if (masterCoprocessors != null) {
            Collections.addAll(masterCoprocessorSet, masterCoprocessors);
        }
        return conf.getBoolean(ACL_SYNC_TO_HDFS_ENABLE, false) && masterCoprocessorSet.contains(SnapshotScannerHDFSAclController.class.getName()) && masterCoprocessorSet.contains(AccessController.class.getName());
    }

    boolean isAclSyncToHdfsEnabled(TableDescriptor tableDescriptor) {
        return tableDescriptor == null ? false : Boolean.valueOf(tableDescriptor.getValue(ACL_SYNC_TO_HDFS_ENABLE));
    }

    PathHelper getPathHelper() {
        return this.pathHelper;
    }

    private CompletableFuture<Void> handleHDFSAcl(HDFSAclOperation acl) {
        return CompletableFuture.supplyAsync(() -> {
            List<Object> childAclOperations = new ArrayList();
            try {
                acl.handleAcl();
                childAclOperations = acl.getChildAclOperations();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                LOG.error("Set HDFS acl error for path {}", (Object)acl.path, (Object)e);
            }
            return childAclOperations;
        }, this.pool).thenComposeAsync(this::handleHDFSAclParallel, (Executor)this.pool);
    }

    private CompletableFuture<Void> handleHDFSAclSequential(List<HDFSAclOperation> operations) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                for (HDFSAclOperation hdfsAclOperation : operations) {
                    this.handleHDFSAcl(hdfsAclOperation).get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Set HDFS acl error", (Throwable)e);
            }
            return null;
        }, this.pool);
    }

    private CompletableFuture<Void> handleHDFSAclParallel(List<HDFSAclOperation> operations) {
        List<CompletableFuture> futures = operations.stream().map(this::handleHDFSAcl).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
    }

    private static AclEntry aclEntry(AclEntryScope scope, String name) {
        return new AclEntry.Builder().setScope(scope).setType(AuthUtil.isGroupPrincipal(name) ? AclEntryType.GROUP : AclEntryType.USER).setName(name).setPermission(FsAction.READ_EXECUTE).build();
    }

    void createDirIfNotExist(Path path) throws IOException {
        if (!this.fs.exists(path)) {
            this.fs.mkdirs(path);
        }
    }

    void deleteEmptyDir(Path path) throws IOException {
        if (this.fs.exists(path) && this.fs.listStatus(path).length == 0) {
            this.fs.delete(path, false);
        }
    }

    static final class PathHelper {
        Configuration conf;
        Path rootDir;
        Path tmpDataDir;
        Path dataDir;
        Path mobDataDir;
        Path archiveDataDir;
        Path snapshotDir;

        PathHelper(Configuration conf) {
            this.conf = conf;
            this.rootDir = new Path(conf.get("hbase.rootdir"));
            this.tmpDataDir = new Path(new Path(this.rootDir, ".tmp"), "data");
            this.dataDir = new Path(this.rootDir, "data");
            this.mobDataDir = new Path(MobUtils.getMobHome(this.rootDir), "data");
            this.archiveDataDir = new Path(new Path(this.rootDir, "archive"), "data");
            this.snapshotDir = new Path(this.rootDir, ".hbase-snapshot");
        }

        Path getRootDir() {
            return this.rootDir;
        }

        Path getDataDir() {
            return this.dataDir;
        }

        Path getMobDir() {
            return this.mobDataDir.getParent();
        }

        Path getMobDataDir() {
            return this.mobDataDir;
        }

        Path getTmpDir() {
            return new Path(this.rootDir, ".tmp");
        }

        Path getTmpDataDir() {
            return this.tmpDataDir;
        }

        Path getArchiveDir() {
            return new Path(this.rootDir, "archive");
        }

        Path getArchiveDataDir() {
            return this.archiveDataDir;
        }

        Path getDataNsDir(String namespace) {
            return new Path(this.dataDir, namespace);
        }

        Path getMobDataNsDir(String namespace) {
            return new Path(this.mobDataDir, namespace);
        }

        Path getDataTableDir(TableName tableName) {
            return new Path(this.getDataNsDir(tableName.getNamespaceAsString()), tableName.getQualifierAsString());
        }

        Path getMobTableDir(TableName tableName) {
            return new Path(this.getMobDataNsDir(tableName.getNamespaceAsString()), tableName.getQualifierAsString());
        }

        Path getArchiveNsDir(String namespace) {
            return new Path(this.archiveDataDir, namespace);
        }

        Path getArchiveTableDir(TableName tableName) {
            return new Path(this.getArchiveNsDir(tableName.getNamespaceAsString()), tableName.getQualifierAsString());
        }

        Path getTmpNsDir(String namespace) {
            return new Path(this.tmpDataDir, namespace);
        }

        Path getTmpTableDir(TableName tableName) {
            return new Path(this.getTmpNsDir(tableName.getNamespaceAsString()), tableName.getQualifierAsString());
        }

        Path getSnapshotRootDir() {
            return this.snapshotDir;
        }

        Path getSnapshotDir(String snapshot) {
            return new Path(this.snapshotDir, snapshot);
        }

        FileSystem getFileSystem() throws IOException {
            return this.rootDir.getFileSystem(this.conf);
        }
    }

    private static class HDFSAclOperation {
        private FileSystem fs;
        private Path path;
        private Operation operation;
        private boolean recursive;
        private AclType aclType;
        private List<AclEntry> defaultAndAccessAclEntries;
        private List<AclEntry> accessAclEntries;
        private List<AclEntry> defaultAclEntries;

        HDFSAclOperation(FileSystem fs, Path path, Set<String> users, OperationType operationType, boolean recursive, AclType aclType) {
            this.fs = fs;
            this.path = path;
            this.defaultAndAccessAclEntries = this.getAclEntries(AclType.DEFAULT_ADN_ACCESS, users);
            this.accessAclEntries = this.getAclEntries(AclType.ACCESS, users);
            this.defaultAclEntries = this.getAclEntries(AclType.DEFAULT, users);
            if (operationType == OperationType.MODIFY) {
                this.operation = FileSystem::modifyAclEntries;
            } else if (operationType == OperationType.REMOVE) {
                this.operation = FileSystem::removeAclEntries;
            } else {
                throw new IllegalArgumentException("Illegal HDFS acl operation type: " + (Object)((Object)operationType));
            }
            this.recursive = recursive;
            this.aclType = aclType;
        }

        HDFSAclOperation(Path path, HDFSAclOperation parent) {
            this.fs = parent.fs;
            this.path = path;
            this.defaultAndAccessAclEntries = parent.defaultAndAccessAclEntries;
            this.accessAclEntries = parent.accessAclEntries;
            this.defaultAclEntries = parent.defaultAclEntries;
            this.operation = parent.operation;
            this.recursive = parent.recursive;
            this.aclType = parent.aclType;
        }

        List<HDFSAclOperation> getChildAclOperations() throws IOException {
            ArrayList<HDFSAclOperation> hdfsAclOperations = new ArrayList<HDFSAclOperation>();
            if (this.recursive && this.fs.isDirectory(this.path)) {
                FileStatus[] fileStatuses;
                for (FileStatus fileStatus : fileStatuses = this.fs.listStatus(this.path)) {
                    hdfsAclOperations.add(new HDFSAclOperation(fileStatus.getPath(), this));
                }
            }
            return hdfsAclOperations;
        }

        void handleAcl() throws IOException {
            block5: {
                block6: {
                    if (!this.fs.exists(this.path)) break block5;
                    if (!this.fs.isDirectory(this.path)) break block6;
                    switch (this.aclType) {
                        case ACCESS: {
                            this.operation.apply(this.fs, this.path, this.accessAclEntries);
                            break block5;
                        }
                        case DEFAULT: {
                            this.operation.apply(this.fs, this.path, this.defaultAclEntries);
                            break block5;
                        }
                        case DEFAULT_ADN_ACCESS: {
                            this.operation.apply(this.fs, this.path, this.defaultAndAccessAclEntries);
                            break block5;
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal HDFS acl type: " + (Object)((Object)this.aclType));
                        }
                    }
                }
                this.operation.apply(this.fs, this.path, this.accessAclEntries);
            }
        }

        private List<AclEntry> getAclEntries(AclType aclType, Set<String> users) {
            ArrayList<AclEntry> aclEntries = new ArrayList<AclEntry>();
            switch (aclType) {
                case ACCESS: {
                    for (String user : users) {
                        aclEntries.add(SnapshotScannerHDFSAclHelper.aclEntry(AclEntryScope.ACCESS, user));
                    }
                    break;
                }
                case DEFAULT: {
                    for (String user : users) {
                        aclEntries.add(SnapshotScannerHDFSAclHelper.aclEntry(AclEntryScope.DEFAULT, user));
                    }
                    break;
                }
                case DEFAULT_ADN_ACCESS: {
                    for (String user : users) {
                        aclEntries.add(SnapshotScannerHDFSAclHelper.aclEntry(AclEntryScope.ACCESS, user));
                        aclEntries.add(SnapshotScannerHDFSAclHelper.aclEntry(AclEntryScope.DEFAULT, user));
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal HDFS acl type: " + (Object)((Object)aclType));
                }
            }
            return aclEntries;
        }

        private static interface Operation {
            public void apply(FileSystem var1, Path var2, List<AclEntry> var3) throws IOException;
        }

        static enum AclType {
            ACCESS,
            DEFAULT,
            DEFAULT_ADN_ACCESS;

        }

        static enum OperationType {
            MODIFY,
            REMOVE;

        }
    }
}

