/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.server.namenode.ErasureCodingPolicyManager;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageLoader;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageTextWriter;

public class PBImageDelimitedTextWriter
extends PBImageTextWriter {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private boolean printStoragePolicy;
    private boolean printECPolicy;
    private ErasureCodingPolicyManager ecManager;

    PBImageDelimitedTextWriter(PrintStream out, String delimiter, String tempPath) throws IOException {
        this(out, delimiter, tempPath, false);
    }

    PBImageDelimitedTextWriter(PrintStream out, String delimiter, String tempPath, boolean printStoragePolicy) throws IOException {
        this(out, delimiter, tempPath, printStoragePolicy, false, 1, "-", null);
    }

    PBImageDelimitedTextWriter(PrintStream out, String delimiter, String tempPath, boolean printStoragePolicy, boolean printECPolicy, int threads, String parallelOut, Configuration conf) throws IOException {
        super(out, delimiter, tempPath, threads, parallelOut);
        this.printStoragePolicy = printStoragePolicy;
        if (printECPolicy && conf != null) {
            this.printECPolicy = true;
            this.ecManager = ErasureCodingPolicyManager.getInstance();
            this.ecManager.init(conf);
        }
    }

    @Override
    public String getEntry(String parent, FsImageProto.INodeSection.INode inode) {
        OutputEntryBuilder entryBuilder = new OutputEntryBuilder(this, inode);
        String inodeName = inode.getName().toStringUtf8();
        Path path = new Path(parent.isEmpty() ? "/" : parent, inodeName.isEmpty() ? "/" : inodeName);
        entryBuilder.setPath(path);
        return entryBuilder.build();
    }

    @Override
    public String getHeader() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Path");
        this.append(buffer, "Replication");
        this.append(buffer, "ModificationTime");
        this.append(buffer, "AccessTime");
        this.append(buffer, "PreferredBlockSize");
        this.append(buffer, "BlocksCount");
        this.append(buffer, "FileSize");
        this.append(buffer, "NSQUOTA");
        this.append(buffer, "DSQUOTA");
        this.append(buffer, "Permission");
        this.append(buffer, "UserName");
        this.append(buffer, "GroupName");
        if (this.printStoragePolicy) {
            this.append(buffer, "StoragePolicyId");
        }
        if (this.printECPolicy) {
            this.append(buffer, "ErasureCodingPolicy");
        }
        return buffer.toString();
    }

    @Override
    public void afterOutput() {
    }

    static class OutputEntryBuilder {
        private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        private PBImageDelimitedTextWriter writer;
        private Path path;
        private int replication = 0;
        private long modificationTime;
        private long accessTime = 0L;
        private long preferredBlockSize = 0L;
        private int blocksCount = 0;
        private long fileSize = 0L;
        private long nsQuota = 0L;
        private long dsQuota = 0L;
        private int storagePolicy = 0;
        private String ecPolicy = "-";
        private String dirPermission = "-";
        private PermissionStatus permissionStatus;
        private String aclPermission = "";

        OutputEntryBuilder(PBImageDelimitedTextWriter writer, FsImageProto.INodeSection.INode inode) {
            this.writer = writer;
            switch (inode.getType()) {
                case FILE: {
                    ErasureCodingPolicy policy;
                    FsImageProto.INodeSection.INodeFile file = inode.getFile();
                    this.replication = file.getReplication();
                    this.modificationTime = file.getModificationTime();
                    this.accessTime = file.getAccessTime();
                    this.preferredBlockSize = file.getPreferredBlockSize();
                    this.blocksCount = file.getBlocksCount();
                    this.fileSize = FSImageLoader.getFileSize(file);
                    this.permissionStatus = writer.getPermission(file.getPermission());
                    if (file.hasAcl() && file.getAcl().getEntriesCount() > 0) {
                        this.aclPermission = "+";
                    }
                    this.storagePolicy = file.getStoragePolicyID();
                    if (!writer.printECPolicy || !file.hasErasureCodingPolicyID() || (policy = writer.ecManager.getByID((byte)file.getErasureCodingPolicyID())) == null) break;
                    this.ecPolicy = policy.getName();
                    break;
                }
                case DIRECTORY: {
                    String name;
                    FsImageProto.INodeSection.INodeDirectory dir = inode.getDirectory();
                    this.modificationTime = dir.getModificationTime();
                    this.nsQuota = dir.getNsQuota();
                    this.dsQuota = dir.getDsQuota();
                    this.dirPermission = "d";
                    this.permissionStatus = writer.getPermission(dir.getPermission());
                    if (dir.hasAcl() && dir.getAcl().getEntriesCount() > 0) {
                        this.aclPermission = "+";
                    }
                    this.storagePolicy = writer.getStoragePolicy(dir.getXAttrs());
                    if (!writer.printECPolicy || (name = writer.getErasureCodingPolicyName(dir.getXAttrs())) == null) break;
                    this.ecPolicy = name;
                    break;
                }
                case SYMLINK: {
                    FsImageProto.INodeSection.INodeSymlink s = inode.getSymlink();
                    this.modificationTime = s.getModificationTime();
                    this.accessTime = s.getAccessTime();
                    this.permissionStatus = writer.getPermission(s.getPermission());
                    this.storagePolicy = 0;
                    break;
                }
            }
        }

        void setPath(Path path) {
            this.path = path;
        }

        public String build() {
            assert (this.permissionStatus != null) : "The PermissionStatus is null!";
            assert (this.permissionStatus.getUserName() != null) : "User name is null!";
            assert (this.permissionStatus.getGroupName() != null) : "Group name is null!";
            StringBuffer buffer = new StringBuffer();
            this.writer.append(buffer, this.path.toString());
            this.writer.append(buffer, this.replication);
            this.writer.append(buffer, this.dateFormatter.format(this.modificationTime));
            this.writer.append(buffer, this.dateFormatter.format(this.accessTime));
            this.writer.append(buffer, this.preferredBlockSize);
            this.writer.append(buffer, this.blocksCount);
            this.writer.append(buffer, this.fileSize);
            this.writer.append(buffer, this.nsQuota);
            this.writer.append(buffer, this.dsQuota);
            this.writer.append(buffer, this.dirPermission + this.permissionStatus.getPermission().toString() + this.aclPermission);
            this.writer.append(buffer, this.permissionStatus.getUserName());
            this.writer.append(buffer, this.permissionStatus.getGroupName());
            if (this.writer.printStoragePolicy) {
                this.writer.append(buffer, this.storagePolicy);
            }
            if (this.writer.printECPolicy) {
                this.writer.append(buffer, this.ecPolicy);
            }
            return buffer.substring(1);
        }
    }
}

