/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.webapp;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomains;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainersInfo;
import org.apache.hadoop.yarn.webapp.RemoteExceptionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ContextFactory.class);
    private static JAXBContext cacheContext;
    private static final Class[] CTYPES;
    private static final Set<Class> CLASS_SET;
    private static final Class[] IGNORE_TYPES;
    private static final Set<Class> IGNORE_SET;
    private static JAXBException je;
    private static StackTraceElement[] stackTrace;

    private ContextFactory() {
    }

    public static JAXBContext newContext(Class[] classes, Map<String, Object> properties) throws Exception {
        Class<?> spFactory = Class.forName("com.sun.xml.bind.v2.ContextFactory");
        Method m = spFactory.getMethod("createContext", Class[].class, Map.class);
        return (JAXBContext)m.invoke(null, classes, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext createContext(Class[] classes, Map<String, Object> properties) throws Exception {
        for (Class c : classes) {
            if (IGNORE_SET.contains(c)) {
                je.setStackTrace(stackTrace);
                throw je;
            }
            if (CLASS_SET.contains(c)) continue;
            try {
                return ContextFactory.newContext(classes, properties);
            }
            catch (Exception e) {
                LOG.warn("Error while Creating JAXBContext", (Throwable)e);
                throw e;
            }
        }
        try {
            Class<ContextFactory> clazz = ContextFactory.class;
            synchronized (ContextFactory.class) {
                if (cacheContext == null) {
                    cacheContext = ContextFactory.newContext(CTYPES, properties);
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
            }
        }
        catch (Exception exception) {
            LOG.warn("Error while Creating JAXBContext", (Throwable)exception);
            throw exception;
        }
        {
            return cacheContext;
        }
    }

    public static JAXBContext createContext(String contextPath, ClassLoader classLoader, Map<String, Object> properties) throws Exception {
        Class<?> spFactory = Class.forName("com.sun.xml.bind.v2.ContextFactory");
        Method m = spFactory.getMethod("createContext", String.class, ClassLoader.class, Map.class);
        return (JAXBContext)m.invoke(null, contextPath, classLoader, properties);
    }

    static {
        CTYPES = new Class[]{AppInfo.class, AppsInfo.class, AppAttemptInfo.class, AppAttemptsInfo.class, ContainerInfo.class, ContainersInfo.class, RemoteExceptionData.class, TimelineDomain.class, TimelineDomains.class, TimelineEvents.class, TimelinePutResponse.class};
        CLASS_SET = new HashSet<Class>(Arrays.asList(CTYPES));
        IGNORE_TYPES = new Class[]{TimelineEntity.class, TimelineEntities.class};
        IGNORE_SET = new HashSet<Class>(Arrays.asList(IGNORE_TYPES));
        je = new JAXBException("TimelineEntity and TimelineEntities has IllegalAnnotation");
        stackTrace = new StackTraceElement[]{new StackTraceElement(ContextFactory.class.getName(), "createContext", "ContextFactory.java", -1)};
    }
}

