/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.common.caches.AbstractDataCache;
import org.apache.helix.common.controllers.ControlContextProvider;
import org.apache.helix.controller.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyCache<T extends HelixProperty>
extends AbstractDataCache<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyCache.class);
    private Map<String, T> _objMap;
    private Map<String, T> _objCache;
    private final String _propertyDescription;
    private final boolean _useSelectiveUpdate;
    private final PropertyCacheKeyFuncs<T> _keyFuncs;

    public PropertyCache(ControlContextProvider contextProvider, String propertyDescription, PropertyCacheKeyFuncs<T> keyFuncs, boolean useSelectiveUpdate) {
        super(contextProvider);
        this._propertyDescription = propertyDescription;
        this._keyFuncs = keyFuncs;
        this._objMap = new HashMap<String, T>();
        this._objCache = new HashMap<String, T>();
        this._useSelectiveUpdate = useSelectiveUpdate;
    }

    @VisibleForTesting
    SelectivePropertyRefreshInputs<T> genSelectiveUpdateInput(HelixDataAccessor accessor, Map<String, T> oldCache, PropertyCacheKeyFuncs<T> propertyKeyFuncs) {
        HashSet latestKeys = Sets.newHashSet();
        for (String liveInstanceName : accessor.getChildNames(propertyKeyFuncs.getRootKey(accessor))) {
            latestKeys.add(propertyKeyFuncs.getObjPropertyKey(accessor, liveInstanceName));
        }
        HashSet oldCachedKeys = Sets.newHashSet();
        HashMap<PropertyKey, T> cachedObjs = new HashMap<PropertyKey, T>();
        for (String objName : oldCache.keySet()) {
            PropertyKey objKey = propertyKeyFuncs.getObjPropertyKey(accessor, objName);
            oldCachedKeys.add(objKey);
            cachedObjs.put(objKey, oldCache.get(objName));
        }
        Sets.SetView cachedKeys = Sets.intersection((Set)oldCachedKeys, (Set)latestKeys);
        Sets.SetView reloadKeys = Sets.difference((Set)latestKeys, (Set)cachedKeys);
        return new SelectivePropertyRefreshInputs(new ArrayList<PropertyKey>((Collection<PropertyKey>)reloadKeys), new ArrayList<PropertyKey>((Collection<PropertyKey>)cachedKeys), cachedObjs);
    }

    public void refresh(HelixDataAccessor accessor) {
        long start = System.currentTimeMillis();
        if (this._useSelectiveUpdate) {
            this.doRefreshWithSelectiveUpdate(accessor);
        } else {
            this.doSimpleCacheRefresh(accessor);
        }
        LogUtil.logInfo(LOG, this.genEventInfo(), String.format("Refreshed %s property %s took %s ms. Selective: %s", this._objMap.size(), this._propertyDescription, System.currentTimeMillis() - start, this._useSelectiveUpdate));
    }

    private void doSimpleCacheRefresh(HelixDataAccessor accessor) {
        this._objCache = accessor.getChildValuesMap(this._keyFuncs.getRootKey(accessor), true);
        this._objMap = new HashMap<String, T>(this._objCache);
    }

    private void doRefreshWithSelectiveUpdate(HelixDataAccessor accessor) {
        SelectivePropertyRefreshInputs<T> input = this.genSelectiveUpdateInput(accessor, this._objCache, this._keyFuncs);
        Map<PropertyKey, T> updatedData = this.refreshProperties(accessor, new HashSet<PropertyKey>(input.getReloadKeys()), input.getCachedKeys(), input.getCachedPropertyMap(), new HashSet<PropertyKey>());
        this._objCache = this.propertyKeyMapToStringMap(updatedData, this._keyFuncs);
        this._objMap = new HashMap<String, T>(this._objCache);
    }

    private Map<String, T> propertyKeyMapToStringMap(Map<PropertyKey, T> propertyKeyMap, PropertyCacheKeyFuncs<T> objNameFunc) {
        HashMap<String, HelixProperty> stringMap = new HashMap<String, HelixProperty>();
        for (HelixProperty obj : propertyKeyMap.values()) {
            stringMap.put(objNameFunc.getObjName(obj), obj);
        }
        return stringMap;
    }

    public Map<String, T> getPropertyMap() {
        return Collections.unmodifiableMap(this._objMap);
    }

    public T getPropertyByName(String name) {
        if (name == null) {
            return null;
        }
        return (T)((HelixProperty)this._objMap.get(name));
    }

    public void setPropertyMap(Map<String, T> objMap) {
        this._objMap = new HashMap<String, T>(objMap);
    }

    public void setProperty(T obj) {
        this._objMap.put(this._keyFuncs.getObjName(obj), obj);
    }

    public void deletePropertyByName(String name) {
        this._objMap.remove(name);
    }

    static class SelectivePropertyRefreshInputs<K extends HelixProperty> {
        private final List<PropertyKey> reloadKeys;
        private final List<PropertyKey> cachedKeys;
        private final Map<PropertyKey, K> cachedPropertyMap;

        SelectivePropertyRefreshInputs(List<PropertyKey> keysToReload, List<PropertyKey> currentlyCachedKeys, Map<PropertyKey, K> currentCache) {
            this.reloadKeys = keysToReload;
            this.cachedKeys = currentlyCachedKeys;
            this.cachedPropertyMap = currentCache;
        }

        List<PropertyKey> getCachedKeys() {
            return this.cachedKeys;
        }

        List<PropertyKey> getReloadKeys() {
            return this.reloadKeys;
        }

        Map<PropertyKey, K> getCachedPropertyMap() {
            return this.cachedPropertyMap;
        }
    }

    public static interface PropertyCacheKeyFuncs<O extends HelixProperty> {
        public PropertyKey getRootKey(HelixDataAccessor var1);

        public PropertyKey getObjPropertyKey(HelixDataAccessor var1, String var2);

        public String getObjName(O var1);
    }
}

