"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PROXY_URL = exports.APP_INSIGHTS_CONNECTION_STRING = exports.TOKEN_EXPIRATION_KEY = exports.TOKEN_RESPONSE_KEY = exports.CUSTOM_IDENTITY_TOKEN_REQUEST_BODY = exports.IDENTITY_TOKEN_SOURCE = exports.LDAP = exports.SSL = exports.SESSION_STORE = exports.HELIX_ENDPOINTS = void 0;
exports.HELIX_ENDPOINTS = {
    helix: [
        {
            default: 'http://localhost:8100/admin/v2',
        },
    ],
};
exports.SESSION_STORE = undefined;
exports.SSL = {
    port: 0,
    keyfile: '',
    certfile: '',
    passfile: '',
    cafiles: [],
};
exports.LDAP = {
    uri: 'ldap://example.com',
    base: 'DC=example,DC=com',
    principalSuffix: '@example.com',
    adminGroup: 'admin',
};
/**
 * The url of your Identity Token API.
 * This an API that should expect LDAP credentials
 * and if the LDAP credentials are valid
 * respond with a unique token of some kind.
 */
exports.IDENTITY_TOKEN_SOURCE = undefined; // 'www.example.com';
/**
 * Any custom object that you would like
 * to include in the body of the request
 * to your custom identity source.
 */
exports.CUSTOM_IDENTITY_TOKEN_REQUEST_BODY = {};
/**
 * This is the key that helix-front uses
 * to access the token itself
 * from the custom identity token response
 * sent by your Identity Token API.
 */
exports.TOKEN_RESPONSE_KEY = 'token';
/**
 * This is the key that helix-front uses
 * to access the token expiration datetime
 */
exports.TOKEN_EXPIRATION_KEY = 'expires';
/**
 * This is the key that helix-front uses
 * to authenticate with the Azure AppInsights
 * metrics service, if desired.
 * This key can be null or a string.
 */
exports.APP_INSIGHTS_CONNECTION_STRING = null;
/**
 * An optional proxy url
 *
 */
exports.PROXY_URL = 'www.example.com';
//# sourceMappingURL=config.js.map