/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.authentication;

import com.mongodb.internal.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;

public final class NativeAuthenticationHelper {
    public static String createAuthenticationHash(String userName, char[] password) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(userName.length() + 20 + password.length);
        try {
            bout.write(userName.getBytes(StandardCharsets.UTF_8));
            bout.write(":mongo:".getBytes(StandardCharsets.UTF_8));
            bout.write(new String(password).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ioe) {
            throw new RuntimeException("impossible", ioe);
        }
        return HexUtils.hexMD5(bout.toByteArray());
    }

    public static BsonDocument getAuthCommand(String userName, char[] password, String nonce) {
        return NativeAuthenticationHelper.getAuthCommand(userName, NativeAuthenticationHelper.createAuthenticationHash(userName, password), nonce);
    }

    public static BsonDocument getAuthCommand(String userName, String authHash, String nonce) {
        String key = nonce + userName + authHash;
        BsonDocument cmd = new BsonDocument();
        cmd.put("authenticate", (BsonValue)new BsonInt32(1));
        cmd.put("user", (BsonValue)new BsonString(userName));
        cmd.put("nonce", (BsonValue)new BsonString(nonce));
        cmd.put("key", (BsonValue)new BsonString(HexUtils.hexMD5(key.getBytes(StandardCharsets.UTF_8))));
        return cmd;
    }

    public static BsonDocument getNonceCommand() {
        return new BsonDocument("getnonce", (BsonValue)new BsonInt32(1));
    }

    private NativeAuthenticationHelper() {
    }
}

