/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring6.processor;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring6.context.IThymeleafBindStatus;
import org.thymeleaf.spring6.processor.AbstractSpringFieldTagProcessor;
import org.thymeleaf.spring6.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.spring6.util.SpringSelectedValueComparator;
import org.thymeleaf.standard.util.StandardProcessorUtils;
import org.unbescape.html.HtmlEscape;

public final class SpringOptionFieldTagProcessor
extends AbstractSpringFieldTagProcessor {
    public SpringOptionFieldTagProcessor(String dialectPrefix) {
        super(dialectPrefix, "option", null, null, true);
    }

    @Override
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IThymeleafBindStatus bindStatus, IElementTagStructureHandler structureHandler) {
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String value = tag.getAttributeValue(this.valueAttributeDefinition.getAttributeName());
        if (value == null) {
            throw new TemplateProcessingException("Attribute \"value\" is required in \"option\" tags");
        }
        boolean selected = SpringSelectedValueComparator.isSelected(bindStatus, HtmlEscape.unescapeHtml((String)value));
        StandardProcessorUtils.setAttribute((IElementTagStructureHandler)structureHandler, (AttributeDefinition)this.valueAttributeDefinition, (String)"value", (String)RequestDataValueProcessorUtils.processFormFieldValue(context, name, value, "option"));
        if (selected) {
            StandardProcessorUtils.setAttribute((IElementTagStructureHandler)structureHandler, (AttributeDefinition)this.selectedAttributeDefinition, (String)"selected", (String)"selected");
        } else {
            structureHandler.removeAttribute(this.selectedAttributeDefinition.getAttributeName());
        }
    }
}

