/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import io.opentelemetry.instrumentation.api.internal.SpanKeyProvider;
import javax.annotation.Nullable;

abstract class DbClientCommonAttributesExtractor<REQUEST, RESPONSE, GETTER extends DbClientCommonAttributesGetter<REQUEST>>
implements AttributesExtractor<REQUEST, RESPONSE>,
SpanKeyProvider {
    private static final AttributeKey<String> DB_NAME = AttributeKey.stringKey((String)"db.name");
    static final AttributeKey<String> DB_NAMESPACE = AttributeKey.stringKey((String)"db.namespace");
    static final AttributeKey<String> DB_SYSTEM = AttributeKey.stringKey((String)"db.system");
    public static final AttributeKey<String> DB_SYSTEM_NAME = AttributeKey.stringKey((String)"db.system.name");
    private static final AttributeKey<String> DB_USER = AttributeKey.stringKey((String)"db.user");
    private static final AttributeKey<String> DB_CONNECTION_STRING = AttributeKey.stringKey((String)"db.connection_string");
    final GETTER getter;

    DbClientCommonAttributesExtractor(GETTER getter) {
        this.getter = getter;
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        if (SemconvStability.emitStableDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_SYSTEM_NAME, (Object)SemconvStability.stableDbSystemName((String)this.getter.getDbSystem(request)));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_NAMESPACE, (Object)this.getter.getDbNamespace(request));
        }
        if (SemconvStability.emitOldDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_SYSTEM, (Object)this.getter.getDbSystem(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_USER, (Object)this.getter.getUser(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_NAME, (Object)this.getter.getDbNamespace(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_CONNECTION_STRING, (Object)this.getter.getConnectionString(request));
        }
    }

    public final void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }

    public SpanKey internalGetSpanKey() {
        return SpanKey.DB_CLIENT;
    }
}

