/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.service.AbstractRequestConvertor;
import com.obs.services.internal.trans.NewTransResult;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.SpecialParamEnum;
import java.util.HashMap;
import java.util.Map;

public abstract class AclHeaderConvertor
extends AbstractRequestConvertor {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.ObsClient");

    boolean prepareRESTHeaderAclForV2(String bucketName, Map<String, String> metadata, AccessControlList acl) {
        String restHeaderAclValue = null;
        if (acl == AccessControlList.REST_CANNED_PRIVATE) {
            restHeaderAclValue = "private";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ) {
            restHeaderAclValue = "public-read";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE) {
            restHeaderAclValue = "public-read-write";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_DELIVERED) {
            restHeaderAclValue = "public-read";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE_DELIVERED) {
            restHeaderAclValue = "public-read-write";
        } else if (acl == AccessControlList.REST_CANNED_AUTHENTICATED_READ) {
            restHeaderAclValue = "authenticated-read";
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_READ) {
            restHeaderAclValue = "bucket-owner-read";
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL) {
            restHeaderAclValue = "bucket-owner-full-control";
        } else if (acl == AccessControlList.REST_CANNED_LOG_DELIVERY_WRITE) {
            restHeaderAclValue = "log-delivery-write";
        }
        String aclHeader = this.getIHeaders(bucketName).aclHeader();
        if (restHeaderAclValue != null) {
            metadata.put(aclHeader, restHeaderAclValue);
        }
        return metadata.containsKey(aclHeader);
    }

    boolean prepareRESTHeaderAclForOBS(String bucketName, Map<String, String> metadata, AccessControlList acl) throws ServiceException {
        String restHeaderAclValue = null;
        boolean invalid = false;
        if (acl == AccessControlList.REST_CANNED_PRIVATE) {
            restHeaderAclValue = "private";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ) {
            restHeaderAclValue = "public-read";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE) {
            restHeaderAclValue = "public-read-write";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_DELIVERED) {
            restHeaderAclValue = "public-read-delivered";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE_DELIVERED) {
            restHeaderAclValue = "public-read-write-delivered";
        } else if (acl == AccessControlList.REST_CANNED_AUTHENTICATED_READ) {
            restHeaderAclValue = "authenticated-read";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_READ) {
            restHeaderAclValue = "bucket-owner-read";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL) {
            restHeaderAclValue = "bucket-owner-full-control";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_LOG_DELIVERY_WRITE) {
            restHeaderAclValue = "log-delivery-write";
            invalid = true;
        }
        if (invalid) {
            log.info("Invalid Canned ACL:" + restHeaderAclValue);
        }
        String aclHeader = this.getIHeaders(bucketName).aclHeader();
        if (restHeaderAclValue != null) {
            metadata.put(aclHeader, restHeaderAclValue);
        }
        return metadata.containsKey(aclHeader);
    }

    protected boolean prepareRESTHeaderAclObject(String bucketName, Map<String, String> metadata, AccessControlList acl) throws ServiceException {
        return this.getProviderCredentials().getLocalAuthType(bucketName) == AuthTypeEnum.OBS ? this.prepareRESTHeaderAclForOBSObject(bucketName, metadata, acl) : this.prepareRESTHeaderAclForV2(bucketName, metadata, acl);
    }

    boolean prepareRESTHeaderAclForOBSObject(String bucketName, Map<String, String> metadata, AccessControlList acl) throws ServiceException {
        String restHeaderAclValue = null;
        boolean invalid = false;
        if (acl == AccessControlList.REST_CANNED_PRIVATE) {
            restHeaderAclValue = "private";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ) {
            restHeaderAclValue = "public-read";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE) {
            restHeaderAclValue = "public-read-write";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_DELIVERED) {
            restHeaderAclValue = "public-read";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE_DELIVERED) {
            restHeaderAclValue = "public-read-write";
        } else if (acl == AccessControlList.REST_CANNED_AUTHENTICATED_READ) {
            restHeaderAclValue = "authenticated-read";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_READ) {
            restHeaderAclValue = "bucket-owner-read";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL) {
            restHeaderAclValue = "bucket-owner-full-control";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_LOG_DELIVERY_WRITE) {
            restHeaderAclValue = "log-delivery-write";
            invalid = true;
        }
        if (invalid) {
            log.info("Invalid Canned ACL:" + restHeaderAclValue);
        }
        String aclHeader = this.getIHeaders(bucketName).aclHeader();
        if (restHeaderAclValue != null) {
            metadata.put(aclHeader, restHeaderAclValue);
        }
        return metadata.containsKey(aclHeader);
    }

    protected boolean prepareRESTHeaderAcl(String bucketName, Map<String, String> metadata, AccessControlList acl) throws ServiceException {
        return this.getProviderCredentials().getLocalAuthType(bucketName) == AuthTypeEnum.OBS ? this.prepareRESTHeaderAclForOBS(bucketName, metadata, acl) : this.prepareRESTHeaderAclForV2(bucketName, metadata, acl);
    }

    protected String getCredential(String shortDate, String accessKey) {
        return accessKey + "/" + shortDate + "/" + "region" + "/" + "s3" + "/" + "aws4_request";
    }

    protected void putAclImpl(String bucketName, String objectKey, AccessControlList acl, String versionId, boolean isRequesterPays) throws ServiceException {
        if (acl != null) {
            HashMap<String, String> requestParams = new HashMap<String, String>();
            requestParams.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
            if (versionId != null) {
                requestParams.put("versionId", versionId);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/xml");
            String xml = this.getIConvertor(bucketName).transAccessControlList(acl, !ServiceUtils.isValid(objectKey));
            headers.put("Content-Length", String.valueOf(xml.length()));
            headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
            this.transRequestPaymentHeaders(isRequesterPays, headers, this.getIHeaders(bucketName));
            NewTransResult result = new NewTransResult();
            result.setHttpMethod(HttpMethodEnum.PUT);
            result.setBucketName(bucketName);
            result.setObjectKey(objectKey);
            result.setHeaders(headers);
            result.setParams(requestParams);
            result.setBody(this.createRequestBody("application/xml", xml));
            this.performRequest(result);
        }
    }
}

