/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.utils;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.utils.ServiceUtils;
import java.lang.ref.SoftReference;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AccessLoggerUtils {
    private static final ILogger ACCESS_LOG = LoggerBuilder.getLogger("com.obs.log.AccessLogger");
    private static final ThreadLocal<StringBuilder> THREADLOCAL_LOG = new ThreadLocal();
    private static final ThreadLocal<SoftReference<SimpleDateFormat>> DATE_FORMAT_HOLDER = new ThreadLocal();
    private static final int INDEX = 5;
    public static volatile boolean accesslogEnabled = true;

    private static String getLogPrefix() {
        if (!accesslogEnabled) {
            return "";
        }
        StackTraceElement[] stacktraces = Thread.currentThread().getStackTrace();
        StackTraceElement stacktrace = null;
        stacktrace = stacktraces.length > 5 ? stacktraces[5] : stacktraces[stacktraces.length - 1];
        return stacktrace.getClassName() + "|" + stacktrace.getMethodName() + "|" + stacktrace.getLineNumber() + "|";
    }

    private static StringBuilder getLog() {
        StringBuilder logSb = THREADLOCAL_LOG.get();
        if (logSb == null) {
            logSb = new StringBuilder();
            THREADLOCAL_LOG.set(logSb);
        }
        return logSb;
    }

    public static void appendLog(Object log, String level) {
        if (!accesslogEnabled) {
            return;
        }
        Boolean isLog = false;
        if ("info".equalsIgnoreCase(level)) {
            isLog = ACCESS_LOG.isInfoEnabled();
        } else if ("debug".equalsIgnoreCase(level)) {
            isLog = ACCESS_LOG.isDebugEnabled();
        } else if ("warn".equalsIgnoreCase(level)) {
            isLog = ACCESS_LOG.isWarnEnabled();
        } else if ("error".equalsIgnoreCase(level)) {
            isLog = ACCESS_LOG.isErrorEnabled();
        } else if ("trace".equalsIgnoreCase(level)) {
            isLog = ACCESS_LOG.isTraceEnabled();
        }
        if (isLog.booleanValue()) {
            StringBuilder sb = new StringBuilder(AccessLoggerUtils.getFormat().format(new Date()));
            sb.append("|").append(AccessLoggerUtils.getLogPrefix()).append(log.toString()).append("\n");
            AccessLoggerUtils.getLog().append(sb.toString());
        }
    }

    public static SimpleDateFormat getFormat() {
        SimpleDateFormat format;
        SoftReference<SimpleDateFormat> holder = DATE_FORMAT_HOLDER.get();
        if (holder == null || (format = holder.get()) == null) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
            holder = new SoftReference<SimpleDateFormat>(format);
            DATE_FORMAT_HOLDER.set(holder);
        }
        return format;
    }

    public static void printLog() {
        if (!accesslogEnabled) {
            return;
        }
        String message = AccessLoggerUtils.getLog().toString();
        if (ServiceUtils.isValid(message)) {
            ACCESS_LOG.accessRecord(message);
        }
        THREADLOCAL_LOG.remove();
    }
}

