/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.CacheOptionEnum;
import com.obs.services.model.GetObjectMetadataRequest;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.ObjectRepleaceMetadata;
import com.obs.services.model.ProgressListener;
import com.obs.services.model.SseCHeader;
import java.util.Date;
import java.util.Map;

public class GetObjectRequest
extends GetObjectMetadataRequest {
    private Long rangeStart;
    private Long rangeEnd;
    private ObjectRepleaceMetadata replaceMetadata;
    private Date ifModifiedSince;
    private Date ifUnmodifiedSince;
    private String ifMatchTag;
    private String ifNoneMatchTag;
    private String imageProcess;
    private ProgressListener progressListener;
    private long progressInterval;
    private CacheOptionEnum cacheOption;
    private long ttl;
    private Map<String, String> requestParameters;
    private boolean autoUnzipResponse;

    public GetObjectRequest() {
        this.httpMethod = HttpMethodEnum.GET;
        this.progressInterval = 102400L;
        this.autoUnzipResponse = false;
    }

    public GetObjectRequest(String bucketName, String objectKey) {
        this.httpMethod = HttpMethodEnum.GET;
        this.progressInterval = 102400L;
        this.autoUnzipResponse = false;
        this.bucketName = bucketName;
        this.objectKey = objectKey;
    }

    public GetObjectRequest(String bucketName, String objectKey, String versionId) {
        this.httpMethod = HttpMethodEnum.GET;
        this.progressInterval = 102400L;
        this.autoUnzipResponse = false;
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.versionId = versionId;
    }

    public ObjectRepleaceMetadata getReplaceMetadata() {
        return this.replaceMetadata;
    }

    public void setReplaceMetadata(ObjectRepleaceMetadata replaceMetadata) {
        this.replaceMetadata = replaceMetadata;
    }

    @Override
    public SseCHeader getSseCHeader() {
        return this.sseCHeader;
    }

    @Override
    public void setSseCHeader(SseCHeader sseCHeader) {
        this.sseCHeader = sseCHeader;
    }

    public Long getRangeStart() {
        return this.rangeStart;
    }

    public void setRangeStart(Long rangeStart) {
        this.rangeStart = rangeStart;
    }

    public Long getRangeEnd() {
        return this.rangeEnd;
    }

    public void setRangeEnd(Long rangeEnd) {
        this.rangeEnd = rangeEnd;
    }

    @Override
    public String getVersionId() {
        return this.versionId;
    }

    @Override
    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public Date getIfModifiedSince() {
        return ServiceUtils.cloneDateIgnoreNull(this.ifModifiedSince);
    }

    public void setIfModifiedSince(Date ifModifiedSince) {
        this.ifModifiedSince = ServiceUtils.cloneDateIgnoreNull(ifModifiedSince);
    }

    public Date getIfUnmodifiedSince() {
        return ServiceUtils.cloneDateIgnoreNull(this.ifUnmodifiedSince);
    }

    public void setIfUnmodifiedSince(Date ifUnmodifiedSince) {
        this.ifUnmodifiedSince = ServiceUtils.cloneDateIgnoreNull(ifUnmodifiedSince);
    }

    public String getIfMatchTag() {
        return this.ifMatchTag;
    }

    public void setIfMatchTag(String ifMatchTag) {
        this.ifMatchTag = ifMatchTag;
    }

    public String getIfNoneMatchTag() {
        return this.ifNoneMatchTag;
    }

    public void setIfNoneMatchTag(String ifNoneMatchTag) {
        this.ifNoneMatchTag = ifNoneMatchTag;
    }

    public String getImageProcess() {
        return this.imageProcess;
    }

    public void setImageProcess(String imageProcess) {
        this.imageProcess = imageProcess;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public long getProgressInterval() {
        return this.progressInterval;
    }

    public void setProgressInterval(long progressInterval) {
        this.progressInterval = progressInterval;
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public CacheOptionEnum getCacheOption() {
        return this.cacheOption;
    }

    public void setCacheOption(CacheOptionEnum cacheOption) {
        this.cacheOption = cacheOption;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        if (ttl < 0L || ttl > 259200L) {
            ttl = 86400L;
        }
        this.ttl = ttl;
    }

    public void setRequestParameters(Map<String, String> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public boolean isAutoUnzipResponse() {
        return this.autoUnzipResponse;
    }

    public void setAutoUnzipResponse(boolean autoUnzipResponse) {
        this.autoUnzipResponse = autoUnzipResponse;
    }

    @Override
    public void setIsEncodeHeaders(boolean encodeHeaders) {
        this.encodeHeaders = encodeHeaders;
    }

    @Override
    public boolean isEncodeHeaders() {
        return this.encodeHeaders;
    }

    @Override
    public String toString() {
        return "GetObjectRequest [bucketName=" + this.bucketName + ", objectKey=" + this.objectKey + ", rangeStart=" + this.rangeStart + ", rangeEnd=" + this.rangeEnd + ", versionId=" + this.versionId + ", replaceMetadata=" + this.replaceMetadata + ", isEncodeHeaders=" + this.encodeHeaders + ", sseCHeader=" + this.sseCHeader + ", ifModifiedSince=" + this.ifModifiedSince + ", ifUnmodifiedSince=" + this.ifUnmodifiedSince + ", ifMatchTag=" + this.ifMatchTag + ", ifNoneMatchTag=" + this.ifNoneMatchTag + ", imageProcess=" + this.imageProcess + ", autoUnzipResponse=" + this.autoUnzipResponse + "]";
    }
}

