/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.dto;

import jakarta.validation.constraints.NotNull;
import org.apache.hertzbeat.common.constants.ImportTaskStatusEnum;
import org.apache.hertzbeat.common.constants.ManagerEventTypeEnum;
import org.apache.hertzbeat.common.constants.NotifyLevelEnum;
import org.apache.hertzbeat.common.entity.dto.ManagerMessage;
import org.springframework.lang.Nullable;

public class ImportTaskMessage
extends ManagerMessage {
    @NotNull
    private String taskName;
    @Nullable
    private Integer progress;
    @NotNull
    private String status;
    @Nullable
    private String errMsg;

    public ImportTaskMessage(String notifyLevel, String managerEventType, String taskName, @Nullable Integer progress, String status, @Nullable String errMsg) {
        super(notifyLevel, managerEventType);
        this.taskName = taskName;
        this.progress = progress;
        this.status = status;
        this.errMsg = errMsg;
    }

    public static ManagerMessage createInProgressMessage(String taskName, Integer process) {
        return new ImportTaskMessage(NotifyLevelEnum.INFO.getValue(), ManagerEventTypeEnum.IMPORT_TASK_EVENT.getValue(), taskName, process, ImportTaskStatusEnum.IN_PROGRESS.getValue(), null);
    }

    public static ManagerMessage createCompletedMessage(String taskName) {
        return new ImportTaskMessage(NotifyLevelEnum.SUCCESS.getValue(), ManagerEventTypeEnum.IMPORT_TASK_EVENT.getValue(), taskName, null, ImportTaskStatusEnum.COMPLETED.getValue(), null);
    }

    public static ManagerMessage createFailedMessage(String taskName, String errMsg) {
        return new ImportTaskMessage(NotifyLevelEnum.ERROR.getValue(), ManagerEventTypeEnum.IMPORT_TASK_EVENT.getValue(), taskName, null, ImportTaskStatusEnum.FAILED.getValue(), errMsg);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportTaskMessage)) {
            return false;
        }
        ImportTaskMessage other = (ImportTaskMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$progress = this.getProgress();
        Integer other$progress = other.getProgress();
        if (this$progress == null ? other$progress != null : !((Object)this$progress).equals(other$progress)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        return !(this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ImportTaskMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : ((Object)$progress).hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        return result;
    }

    public String getTaskName() {
        return this.taskName;
    }

    @Nullable
    public Integer getProgress() {
        return this.progress;
    }

    public String getStatus() {
        return this.status;
    }

    @Nullable
    public String getErrMsg() {
        return this.errMsg;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setProgress(@Nullable Integer progress) {
        this.progress = progress;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setErrMsg(@Nullable String errMsg) {
        this.errMsg = errMsg;
    }

    @Override
    public String toString() {
        return "ImportTaskMessage(taskName=" + this.getTaskName() + ", progress=" + this.getProgress() + ", status=" + this.getStatus() + ", errMsg=" + this.getErrMsg() + ")";
    }
}

