/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.job;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hertzbeat.common.entity.job.protocol.ConsulSdProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.DnsProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.DnsSdProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.EurekaSdProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.FtpProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.HttpProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.IcmpProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.ImapProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.IpmiProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.JdbcProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.JmxProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.KafkaProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.MemcachedProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.ModbusProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.MongodbProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.MqttProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.NacosSdProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.NebulaGraphProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.NginxProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.NgqlProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.NtpProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.PlcProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.Pop3Protocol;
import org.apache.hertzbeat.common.entity.job.protocol.PrometheusProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.PushProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.RedfishProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.RedisProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.RegistryProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.RocketmqProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.S7Protocol;
import org.apache.hertzbeat.common.entity.job.protocol.ScriptProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.SmtpProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.SnmpProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.SshProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.TelnetProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.UdpProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.WebsocketProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.ZookeeperSdProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics {
    private static final Logger log = LoggerFactory.getLogger(Metrics.class);
    private String name;
    private Map<String, String> i18n;
    private String protocol;
    private Byte priority;
    private long collectTime;
    private long interval;
    private boolean visible = true;
    private List<Field> fields;
    private List<String> aliasFields;
    private List<String> calculates;
    private List<String> filters;
    private List<String> units;
    private HttpProtocol http;
    private IcmpProtocol icmp;
    private TelnetProtocol telnet;
    private SmtpProtocol smtp;
    private NtpProtocol ntp;
    private WebsocketProtocol websocket;
    private MemcachedProtocol memcached;
    private NebulaGraphProtocol nebulaGraph;
    private UdpProtocol udp;
    private JdbcProtocol jdbc;
    private SshProtocol ssh;
    private RedisProtocol redis;
    private MongodbProtocol mongodb;
    private JmxProtocol jmx;
    private SnmpProtocol snmp;
    private FtpProtocol ftp;
    private RocketmqProtocol rocketmq;
    private PushProtocol push;
    private PrometheusProtocol prometheus;
    private DnsProtocol dns;
    private NginxProtocol nginx;
    private Pop3Protocol pop3;
    private RegistryProtocol registry;
    private RedfishProtocol redfish;
    private NgqlProtocol ngql;
    private ImapProtocol imap;
    private ScriptProtocol script;
    private MqttProtocol mqtt;
    private IpmiProtocol ipmi;
    private KafkaProtocol kclient;
    private HttpProtocol http_sd;
    private DnsSdProtocol dns_sd;
    private EurekaSdProtocol eureka_sd;
    private ConsulSdProtocol consul_sd;
    private NacosSdProtocol nacos_sd;
    private ZookeeperSdProtocol zookeeper_sd;
    private PlcProtocol plc;
    private ModbusProtocol modbus;
    private S7Protocol s7;
    @JsonIgnore
    private transient AtomicReference<CollectRep.MetricsData.Builder> subTaskDataRef;
    @JsonIgnore
    private transient AtomicInteger subTaskNum;
    @JsonIgnore
    private transient Integer subTaskId;

    public boolean isHasSubTask() {
        return this.subTaskNum != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean consumeSubTaskResponse(CollectRep.MetricsData metricsData) {
        AtomicInteger atomicInteger = this.subTaskNum;
        synchronized (atomicInteger) {
            int index = this.subTaskNum.decrementAndGet();
            if (this.subTaskDataRef.get() == null) {
                this.subTaskDataRef.set(CollectRep.MetricsData.newBuilder(metricsData));
            } else if (metricsData.getValuesCount() >= 1) {
                CollectRep.MetricsData.Builder dataBuilder = this.subTaskDataRef.get();
                for (CollectRep.ValueRow valueRow : metricsData.getValues()) {
                    if (valueRow.getColumnsCount() == dataBuilder.getFieldsCount()) {
                        dataBuilder.addValueRow(valueRow);
                        continue;
                    }
                    log.error("consume subTask data value not mapping filed");
                }
                this.subTaskDataRef.set(dataBuilder);
            }
            metricsData.close();
            return index == 0;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metrics metrics = (Metrics)o;
        return this.name.equals(metrics.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static MetricsBuilder builder() {
        return new MetricsBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getI18n() {
        return this.i18n;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Byte getPriority() {
        return this.priority;
    }

    public long getCollectTime() {
        return this.collectTime;
    }

    public long getInterval() {
        return this.interval;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<String> getAliasFields() {
        return this.aliasFields;
    }

    public List<String> getCalculates() {
        return this.calculates;
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public List<String> getUnits() {
        return this.units;
    }

    public HttpProtocol getHttp() {
        return this.http;
    }

    public IcmpProtocol getIcmp() {
        return this.icmp;
    }

    public TelnetProtocol getTelnet() {
        return this.telnet;
    }

    public SmtpProtocol getSmtp() {
        return this.smtp;
    }

    public NtpProtocol getNtp() {
        return this.ntp;
    }

    public WebsocketProtocol getWebsocket() {
        return this.websocket;
    }

    public MemcachedProtocol getMemcached() {
        return this.memcached;
    }

    public NebulaGraphProtocol getNebulaGraph() {
        return this.nebulaGraph;
    }

    public UdpProtocol getUdp() {
        return this.udp;
    }

    public JdbcProtocol getJdbc() {
        return this.jdbc;
    }

    public SshProtocol getSsh() {
        return this.ssh;
    }

    public RedisProtocol getRedis() {
        return this.redis;
    }

    public MongodbProtocol getMongodb() {
        return this.mongodb;
    }

    public JmxProtocol getJmx() {
        return this.jmx;
    }

    public SnmpProtocol getSnmp() {
        return this.snmp;
    }

    public FtpProtocol getFtp() {
        return this.ftp;
    }

    public RocketmqProtocol getRocketmq() {
        return this.rocketmq;
    }

    public PushProtocol getPush() {
        return this.push;
    }

    public PrometheusProtocol getPrometheus() {
        return this.prometheus;
    }

    public DnsProtocol getDns() {
        return this.dns;
    }

    public NginxProtocol getNginx() {
        return this.nginx;
    }

    public Pop3Protocol getPop3() {
        return this.pop3;
    }

    public RegistryProtocol getRegistry() {
        return this.registry;
    }

    public RedfishProtocol getRedfish() {
        return this.redfish;
    }

    public NgqlProtocol getNgql() {
        return this.ngql;
    }

    public ImapProtocol getImap() {
        return this.imap;
    }

    public ScriptProtocol getScript() {
        return this.script;
    }

    public MqttProtocol getMqtt() {
        return this.mqtt;
    }

    public IpmiProtocol getIpmi() {
        return this.ipmi;
    }

    public KafkaProtocol getKclient() {
        return this.kclient;
    }

    public HttpProtocol getHttp_sd() {
        return this.http_sd;
    }

    public DnsSdProtocol getDns_sd() {
        return this.dns_sd;
    }

    public EurekaSdProtocol getEureka_sd() {
        return this.eureka_sd;
    }

    public ConsulSdProtocol getConsul_sd() {
        return this.consul_sd;
    }

    public NacosSdProtocol getNacos_sd() {
        return this.nacos_sd;
    }

    public ZookeeperSdProtocol getZookeeper_sd() {
        return this.zookeeper_sd;
    }

    public PlcProtocol getPlc() {
        return this.plc;
    }

    public ModbusProtocol getModbus() {
        return this.modbus;
    }

    public S7Protocol getS7() {
        return this.s7;
    }

    public AtomicReference<CollectRep.MetricsData.Builder> getSubTaskDataRef() {
        return this.subTaskDataRef;
    }

    public AtomicInteger getSubTaskNum() {
        return this.subTaskNum;
    }

    public Integer getSubTaskId() {
        return this.subTaskId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setI18n(Map<String, String> i18n) {
        this.i18n = i18n;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setPriority(Byte priority) {
        this.priority = priority;
    }

    public void setCollectTime(long collectTime) {
        this.collectTime = collectTime;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public void setAliasFields(List<String> aliasFields) {
        this.aliasFields = aliasFields;
    }

    public void setCalculates(List<String> calculates) {
        this.calculates = calculates;
    }

    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    public void setUnits(List<String> units) {
        this.units = units;
    }

    public void setHttp(HttpProtocol http) {
        this.http = http;
    }

    public void setIcmp(IcmpProtocol icmp) {
        this.icmp = icmp;
    }

    public void setTelnet(TelnetProtocol telnet) {
        this.telnet = telnet;
    }

    public void setSmtp(SmtpProtocol smtp) {
        this.smtp = smtp;
    }

    public void setNtp(NtpProtocol ntp) {
        this.ntp = ntp;
    }

    public void setWebsocket(WebsocketProtocol websocket) {
        this.websocket = websocket;
    }

    public void setMemcached(MemcachedProtocol memcached) {
        this.memcached = memcached;
    }

    public void setNebulaGraph(NebulaGraphProtocol nebulaGraph) {
        this.nebulaGraph = nebulaGraph;
    }

    public void setUdp(UdpProtocol udp) {
        this.udp = udp;
    }

    public void setJdbc(JdbcProtocol jdbc) {
        this.jdbc = jdbc;
    }

    public void setSsh(SshProtocol ssh) {
        this.ssh = ssh;
    }

    public void setRedis(RedisProtocol redis) {
        this.redis = redis;
    }

    public void setMongodb(MongodbProtocol mongodb) {
        this.mongodb = mongodb;
    }

    public void setJmx(JmxProtocol jmx) {
        this.jmx = jmx;
    }

    public void setSnmp(SnmpProtocol snmp) {
        this.snmp = snmp;
    }

    public void setFtp(FtpProtocol ftp) {
        this.ftp = ftp;
    }

    public void setRocketmq(RocketmqProtocol rocketmq) {
        this.rocketmq = rocketmq;
    }

    public void setPush(PushProtocol push) {
        this.push = push;
    }

    public void setPrometheus(PrometheusProtocol prometheus) {
        this.prometheus = prometheus;
    }

    public void setDns(DnsProtocol dns) {
        this.dns = dns;
    }

    public void setNginx(NginxProtocol nginx) {
        this.nginx = nginx;
    }

    public void setPop3(Pop3Protocol pop3) {
        this.pop3 = pop3;
    }

    public void setRegistry(RegistryProtocol registry) {
        this.registry = registry;
    }

    public void setRedfish(RedfishProtocol redfish) {
        this.redfish = redfish;
    }

    public void setNgql(NgqlProtocol ngql) {
        this.ngql = ngql;
    }

    public void setImap(ImapProtocol imap) {
        this.imap = imap;
    }

    public void setScript(ScriptProtocol script) {
        this.script = script;
    }

    public void setMqtt(MqttProtocol mqtt) {
        this.mqtt = mqtt;
    }

    public void setIpmi(IpmiProtocol ipmi) {
        this.ipmi = ipmi;
    }

    public void setKclient(KafkaProtocol kclient) {
        this.kclient = kclient;
    }

    public void setHttp_sd(HttpProtocol http_sd) {
        this.http_sd = http_sd;
    }

    public void setDns_sd(DnsSdProtocol dns_sd) {
        this.dns_sd = dns_sd;
    }

    public void setEureka_sd(EurekaSdProtocol eureka_sd) {
        this.eureka_sd = eureka_sd;
    }

    public void setConsul_sd(ConsulSdProtocol consul_sd) {
        this.consul_sd = consul_sd;
    }

    public void setNacos_sd(NacosSdProtocol nacos_sd) {
        this.nacos_sd = nacos_sd;
    }

    public void setZookeeper_sd(ZookeeperSdProtocol zookeeper_sd) {
        this.zookeeper_sd = zookeeper_sd;
    }

    public void setPlc(PlcProtocol plc) {
        this.plc = plc;
    }

    public void setModbus(ModbusProtocol modbus) {
        this.modbus = modbus;
    }

    public void setS7(S7Protocol s7) {
        this.s7 = s7;
    }

    @JsonIgnore
    public void setSubTaskDataRef(AtomicReference<CollectRep.MetricsData.Builder> subTaskDataRef) {
        this.subTaskDataRef = subTaskDataRef;
    }

    @JsonIgnore
    public void setSubTaskNum(AtomicInteger subTaskNum) {
        this.subTaskNum = subTaskNum;
    }

    @JsonIgnore
    public void setSubTaskId(Integer subTaskId) {
        this.subTaskId = subTaskId;
    }

    public String toString() {
        return "Metrics(name=" + this.getName() + ", i18n=" + this.getI18n() + ", protocol=" + this.getProtocol() + ", priority=" + this.getPriority() + ", collectTime=" + this.getCollectTime() + ", interval=" + this.getInterval() + ", visible=" + this.isVisible() + ", fields=" + this.getFields() + ", aliasFields=" + this.getAliasFields() + ", calculates=" + this.getCalculates() + ", filters=" + this.getFilters() + ", units=" + this.getUnits() + ", http=" + this.getHttp() + ", icmp=" + this.getIcmp() + ", telnet=" + this.getTelnet() + ", smtp=" + this.getSmtp() + ", ntp=" + this.getNtp() + ", websocket=" + this.getWebsocket() + ", memcached=" + this.getMemcached() + ", nebulaGraph=" + this.getNebulaGraph() + ", udp=" + this.getUdp() + ", jdbc=" + this.getJdbc() + ", ssh=" + this.getSsh() + ", redis=" + this.getRedis() + ", mongodb=" + this.getMongodb() + ", jmx=" + this.getJmx() + ", snmp=" + this.getSnmp() + ", ftp=" + this.getFtp() + ", rocketmq=" + this.getRocketmq() + ", push=" + this.getPush() + ", prometheus=" + this.getPrometheus() + ", dns=" + this.getDns() + ", nginx=" + this.getNginx() + ", pop3=" + this.getPop3() + ", registry=" + this.getRegistry() + ", redfish=" + this.getRedfish() + ", ngql=" + this.getNgql() + ", imap=" + this.getImap() + ", script=" + this.getScript() + ", mqtt=" + this.getMqtt() + ", ipmi=" + this.getIpmi() + ", kclient=" + this.getKclient() + ", http_sd=" + this.getHttp_sd() + ", dns_sd=" + this.getDns_sd() + ", eureka_sd=" + this.getEureka_sd() + ", consul_sd=" + this.getConsul_sd() + ", nacos_sd=" + this.getNacos_sd() + ", zookeeper_sd=" + this.getZookeeper_sd() + ", plc=" + this.getPlc() + ", modbus=" + this.getModbus() + ", s7=" + this.getS7() + ", subTaskDataRef=" + this.getSubTaskDataRef() + ", subTaskNum=" + this.getSubTaskNum() + ", subTaskId=" + this.getSubTaskId() + ")";
    }

    public Metrics(String name, Map<String, String> i18n, String protocol, Byte priority, long collectTime, long interval, boolean visible, List<Field> fields, List<String> aliasFields, List<String> calculates, List<String> filters, List<String> units, HttpProtocol http, IcmpProtocol icmp, TelnetProtocol telnet, SmtpProtocol smtp, NtpProtocol ntp, WebsocketProtocol websocket, MemcachedProtocol memcached, NebulaGraphProtocol nebulaGraph, UdpProtocol udp, JdbcProtocol jdbc, SshProtocol ssh, RedisProtocol redis, MongodbProtocol mongodb, JmxProtocol jmx, SnmpProtocol snmp, FtpProtocol ftp, RocketmqProtocol rocketmq, PushProtocol push, PrometheusProtocol prometheus, DnsProtocol dns, NginxProtocol nginx, Pop3Protocol pop3, RegistryProtocol registry, RedfishProtocol redfish, NgqlProtocol ngql, ImapProtocol imap, ScriptProtocol script, MqttProtocol mqtt, IpmiProtocol ipmi, KafkaProtocol kclient, HttpProtocol http_sd, DnsSdProtocol dns_sd, EurekaSdProtocol eureka_sd, ConsulSdProtocol consul_sd, NacosSdProtocol nacos_sd, ZookeeperSdProtocol zookeeper_sd, PlcProtocol plc, ModbusProtocol modbus, S7Protocol s7, AtomicReference<CollectRep.MetricsData.Builder> subTaskDataRef, AtomicInteger subTaskNum, Integer subTaskId) {
        this.name = name;
        this.i18n = i18n;
        this.protocol = protocol;
        this.priority = priority;
        this.collectTime = collectTime;
        this.interval = interval;
        this.visible = visible;
        this.fields = fields;
        this.aliasFields = aliasFields;
        this.calculates = calculates;
        this.filters = filters;
        this.units = units;
        this.http = http;
        this.icmp = icmp;
        this.telnet = telnet;
        this.smtp = smtp;
        this.ntp = ntp;
        this.websocket = websocket;
        this.memcached = memcached;
        this.nebulaGraph = nebulaGraph;
        this.udp = udp;
        this.jdbc = jdbc;
        this.ssh = ssh;
        this.redis = redis;
        this.mongodb = mongodb;
        this.jmx = jmx;
        this.snmp = snmp;
        this.ftp = ftp;
        this.rocketmq = rocketmq;
        this.push = push;
        this.prometheus = prometheus;
        this.dns = dns;
        this.nginx = nginx;
        this.pop3 = pop3;
        this.registry = registry;
        this.redfish = redfish;
        this.ngql = ngql;
        this.imap = imap;
        this.script = script;
        this.mqtt = mqtt;
        this.ipmi = ipmi;
        this.kclient = kclient;
        this.http_sd = http_sd;
        this.dns_sd = dns_sd;
        this.eureka_sd = eureka_sd;
        this.consul_sd = consul_sd;
        this.nacos_sd = nacos_sd;
        this.zookeeper_sd = zookeeper_sd;
        this.plc = plc;
        this.modbus = modbus;
        this.s7 = s7;
        this.subTaskDataRef = subTaskDataRef;
        this.subTaskNum = subTaskNum;
        this.subTaskId = subTaskId;
    }

    public Metrics() {
    }

    public static class MetricsBuilder {
        private String name;
        private Map<String, String> i18n;
        private String protocol;
        private Byte priority;
        private long collectTime;
        private long interval;
        private boolean visible;
        private List<Field> fields;
        private List<String> aliasFields;
        private List<String> calculates;
        private List<String> filters;
        private List<String> units;
        private HttpProtocol http;
        private IcmpProtocol icmp;
        private TelnetProtocol telnet;
        private SmtpProtocol smtp;
        private NtpProtocol ntp;
        private WebsocketProtocol websocket;
        private MemcachedProtocol memcached;
        private NebulaGraphProtocol nebulaGraph;
        private UdpProtocol udp;
        private JdbcProtocol jdbc;
        private SshProtocol ssh;
        private RedisProtocol redis;
        private MongodbProtocol mongodb;
        private JmxProtocol jmx;
        private SnmpProtocol snmp;
        private FtpProtocol ftp;
        private RocketmqProtocol rocketmq;
        private PushProtocol push;
        private PrometheusProtocol prometheus;
        private DnsProtocol dns;
        private NginxProtocol nginx;
        private Pop3Protocol pop3;
        private RegistryProtocol registry;
        private RedfishProtocol redfish;
        private NgqlProtocol ngql;
        private ImapProtocol imap;
        private ScriptProtocol script;
        private MqttProtocol mqtt;
        private IpmiProtocol ipmi;
        private KafkaProtocol kclient;
        private HttpProtocol http_sd;
        private DnsSdProtocol dns_sd;
        private EurekaSdProtocol eureka_sd;
        private ConsulSdProtocol consul_sd;
        private NacosSdProtocol nacos_sd;
        private ZookeeperSdProtocol zookeeper_sd;
        private PlcProtocol plc;
        private ModbusProtocol modbus;
        private S7Protocol s7;
        private AtomicReference<CollectRep.MetricsData.Builder> subTaskDataRef;
        private AtomicInteger subTaskNum;
        private Integer subTaskId;

        MetricsBuilder() {
        }

        public MetricsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MetricsBuilder i18n(Map<String, String> i18n) {
            this.i18n = i18n;
            return this;
        }

        public MetricsBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public MetricsBuilder priority(Byte priority) {
            this.priority = priority;
            return this;
        }

        public MetricsBuilder collectTime(long collectTime) {
            this.collectTime = collectTime;
            return this;
        }

        public MetricsBuilder interval(long interval) {
            this.interval = interval;
            return this;
        }

        public MetricsBuilder visible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public MetricsBuilder fields(List<Field> fields) {
            this.fields = fields;
            return this;
        }

        public MetricsBuilder aliasFields(List<String> aliasFields) {
            this.aliasFields = aliasFields;
            return this;
        }

        public MetricsBuilder calculates(List<String> calculates) {
            this.calculates = calculates;
            return this;
        }

        public MetricsBuilder filters(List<String> filters) {
            this.filters = filters;
            return this;
        }

        public MetricsBuilder units(List<String> units) {
            this.units = units;
            return this;
        }

        public MetricsBuilder http(HttpProtocol http) {
            this.http = http;
            return this;
        }

        public MetricsBuilder icmp(IcmpProtocol icmp) {
            this.icmp = icmp;
            return this;
        }

        public MetricsBuilder telnet(TelnetProtocol telnet) {
            this.telnet = telnet;
            return this;
        }

        public MetricsBuilder smtp(SmtpProtocol smtp) {
            this.smtp = smtp;
            return this;
        }

        public MetricsBuilder ntp(NtpProtocol ntp) {
            this.ntp = ntp;
            return this;
        }

        public MetricsBuilder websocket(WebsocketProtocol websocket) {
            this.websocket = websocket;
            return this;
        }

        public MetricsBuilder memcached(MemcachedProtocol memcached) {
            this.memcached = memcached;
            return this;
        }

        public MetricsBuilder nebulaGraph(NebulaGraphProtocol nebulaGraph) {
            this.nebulaGraph = nebulaGraph;
            return this;
        }

        public MetricsBuilder udp(UdpProtocol udp) {
            this.udp = udp;
            return this;
        }

        public MetricsBuilder jdbc(JdbcProtocol jdbc) {
            this.jdbc = jdbc;
            return this;
        }

        public MetricsBuilder ssh(SshProtocol ssh) {
            this.ssh = ssh;
            return this;
        }

        public MetricsBuilder redis(RedisProtocol redis) {
            this.redis = redis;
            return this;
        }

        public MetricsBuilder mongodb(MongodbProtocol mongodb) {
            this.mongodb = mongodb;
            return this;
        }

        public MetricsBuilder jmx(JmxProtocol jmx) {
            this.jmx = jmx;
            return this;
        }

        public MetricsBuilder snmp(SnmpProtocol snmp) {
            this.snmp = snmp;
            return this;
        }

        public MetricsBuilder ftp(FtpProtocol ftp) {
            this.ftp = ftp;
            return this;
        }

        public MetricsBuilder rocketmq(RocketmqProtocol rocketmq) {
            this.rocketmq = rocketmq;
            return this;
        }

        public MetricsBuilder push(PushProtocol push) {
            this.push = push;
            return this;
        }

        public MetricsBuilder prometheus(PrometheusProtocol prometheus) {
            this.prometheus = prometheus;
            return this;
        }

        public MetricsBuilder dns(DnsProtocol dns) {
            this.dns = dns;
            return this;
        }

        public MetricsBuilder nginx(NginxProtocol nginx) {
            this.nginx = nginx;
            return this;
        }

        public MetricsBuilder pop3(Pop3Protocol pop3) {
            this.pop3 = pop3;
            return this;
        }

        public MetricsBuilder registry(RegistryProtocol registry) {
            this.registry = registry;
            return this;
        }

        public MetricsBuilder redfish(RedfishProtocol redfish) {
            this.redfish = redfish;
            return this;
        }

        public MetricsBuilder ngql(NgqlProtocol ngql) {
            this.ngql = ngql;
            return this;
        }

        public MetricsBuilder imap(ImapProtocol imap) {
            this.imap = imap;
            return this;
        }

        public MetricsBuilder script(ScriptProtocol script) {
            this.script = script;
            return this;
        }

        public MetricsBuilder mqtt(MqttProtocol mqtt) {
            this.mqtt = mqtt;
            return this;
        }

        public MetricsBuilder ipmi(IpmiProtocol ipmi) {
            this.ipmi = ipmi;
            return this;
        }

        public MetricsBuilder kclient(KafkaProtocol kclient) {
            this.kclient = kclient;
            return this;
        }

        public MetricsBuilder http_sd(HttpProtocol http_sd) {
            this.http_sd = http_sd;
            return this;
        }

        public MetricsBuilder dns_sd(DnsSdProtocol dns_sd) {
            this.dns_sd = dns_sd;
            return this;
        }

        public MetricsBuilder eureka_sd(EurekaSdProtocol eureka_sd) {
            this.eureka_sd = eureka_sd;
            return this;
        }

        public MetricsBuilder consul_sd(ConsulSdProtocol consul_sd) {
            this.consul_sd = consul_sd;
            return this;
        }

        public MetricsBuilder nacos_sd(NacosSdProtocol nacos_sd) {
            this.nacos_sd = nacos_sd;
            return this;
        }

        public MetricsBuilder zookeeper_sd(ZookeeperSdProtocol zookeeper_sd) {
            this.zookeeper_sd = zookeeper_sd;
            return this;
        }

        public MetricsBuilder plc(PlcProtocol plc) {
            this.plc = plc;
            return this;
        }

        public MetricsBuilder modbus(ModbusProtocol modbus) {
            this.modbus = modbus;
            return this;
        }

        public MetricsBuilder s7(S7Protocol s7) {
            this.s7 = s7;
            return this;
        }

        @JsonIgnore
        public MetricsBuilder subTaskDataRef(AtomicReference<CollectRep.MetricsData.Builder> subTaskDataRef) {
            this.subTaskDataRef = subTaskDataRef;
            return this;
        }

        @JsonIgnore
        public MetricsBuilder subTaskNum(AtomicInteger subTaskNum) {
            this.subTaskNum = subTaskNum;
            return this;
        }

        @JsonIgnore
        public MetricsBuilder subTaskId(Integer subTaskId) {
            this.subTaskId = subTaskId;
            return this;
        }

        public Metrics build() {
            return new Metrics(this.name, this.i18n, this.protocol, this.priority, this.collectTime, this.interval, this.visible, this.fields, this.aliasFields, this.calculates, this.filters, this.units, this.http, this.icmp, this.telnet, this.smtp, this.ntp, this.websocket, this.memcached, this.nebulaGraph, this.udp, this.jdbc, this.ssh, this.redis, this.mongodb, this.jmx, this.snmp, this.ftp, this.rocketmq, this.push, this.prometheus, this.dns, this.nginx, this.pop3, this.registry, this.redfish, this.ngql, this.imap, this.script, this.mqtt, this.ipmi, this.kclient, this.http_sd, this.dns_sd, this.eureka_sd, this.consul_sd, this.nacos_sd, this.zookeeper_sd, this.plc, this.modbus, this.s7, this.subTaskDataRef, this.subTaskNum, this.subTaskId);
        }

        public String toString() {
            return "Metrics.MetricsBuilder(name=" + this.name + ", i18n=" + this.i18n + ", protocol=" + this.protocol + ", priority=" + this.priority + ", collectTime=" + this.collectTime + ", interval=" + this.interval + ", visible=" + this.visible + ", fields=" + this.fields + ", aliasFields=" + this.aliasFields + ", calculates=" + this.calculates + ", filters=" + this.filters + ", units=" + this.units + ", http=" + this.http + ", icmp=" + this.icmp + ", telnet=" + this.telnet + ", smtp=" + this.smtp + ", ntp=" + this.ntp + ", websocket=" + this.websocket + ", memcached=" + this.memcached + ", nebulaGraph=" + this.nebulaGraph + ", udp=" + this.udp + ", jdbc=" + this.jdbc + ", ssh=" + this.ssh + ", redis=" + this.redis + ", mongodb=" + this.mongodb + ", jmx=" + this.jmx + ", snmp=" + this.snmp + ", ftp=" + this.ftp + ", rocketmq=" + this.rocketmq + ", push=" + this.push + ", prometheus=" + this.prometheus + ", dns=" + this.dns + ", nginx=" + this.nginx + ", pop3=" + this.pop3 + ", registry=" + this.registry + ", redfish=" + this.redfish + ", ngql=" + this.ngql + ", imap=" + this.imap + ", script=" + this.script + ", mqtt=" + this.mqtt + ", ipmi=" + this.ipmi + ", kclient=" + this.kclient + ", http_sd=" + this.http_sd + ", dns_sd=" + this.dns_sd + ", eureka_sd=" + this.eureka_sd + ", consul_sd=" + this.consul_sd + ", nacos_sd=" + this.nacos_sd + ", zookeeper_sd=" + this.zookeeper_sd + ", plc=" + this.plc + ", modbus=" + this.modbus + ", s7=" + this.s7 + ", subTaskDataRef=" + this.subTaskDataRef + ", subTaskNum=" + this.subTaskNum + ", subTaskId=" + this.subTaskId + ")";
        }
    }

    public static class Field {
        private String field;
        private Map<String, String> i18n;
        private byte type = 1;
        private boolean label = false;
        private String unit;

        public static FieldBuilder builder() {
            return new FieldBuilder();
        }

        public String getField() {
            return this.field;
        }

        public Map<String, String> getI18n() {
            return this.i18n;
        }

        public byte getType() {
            return this.type;
        }

        public boolean isLabel() {
            return this.label;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setI18n(Map<String, String> i18n) {
            this.i18n = i18n;
        }

        public void setType(byte type) {
            this.type = type;
        }

        public void setLabel(boolean label) {
            this.label = label;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getType() != other.getType()) {
                return false;
            }
            if (this.isLabel() != other.isLabel()) {
                return false;
            }
            String this$field = this.getField();
            String other$field = other.getField();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            Map<String, String> this$i18n = this.getI18n();
            Map<String, String> other$i18n = other.getI18n();
            if (this$i18n == null ? other$i18n != null : !((Object)this$i18n).equals(other$i18n)) {
                return false;
            }
            String this$unit = this.getUnit();
            String other$unit = other.getUnit();
            return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Field;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getType();
            result = result * 59 + (this.isLabel() ? 79 : 97);
            String $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            Map<String, String> $i18n = this.getI18n();
            result = result * 59 + ($i18n == null ? 43 : ((Object)$i18n).hashCode());
            String $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            return result;
        }

        public String toString() {
            return "Metrics.Field(field=" + this.getField() + ", i18n=" + this.getI18n() + ", type=" + this.getType() + ", label=" + this.isLabel() + ", unit=" + this.getUnit() + ")";
        }

        public Field(String field, Map<String, String> i18n, byte type, boolean label, String unit) {
            this.field = field;
            this.i18n = i18n;
            this.type = type;
            this.label = label;
            this.unit = unit;
        }

        public Field() {
        }

        public static class FieldBuilder {
            private String field;
            private Map<String, String> i18n;
            private byte type;
            private boolean label;
            private String unit;

            FieldBuilder() {
            }

            public FieldBuilder field(String field) {
                this.field = field;
                return this;
            }

            public FieldBuilder i18n(Map<String, String> i18n) {
                this.i18n = i18n;
                return this;
            }

            public FieldBuilder type(byte type) {
                this.type = type;
                return this;
            }

            public FieldBuilder label(boolean label) {
                this.label = label;
                return this;
            }

            public FieldBuilder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public Field build() {
                return new Field(this.field, this.i18n, this.type, this.label, this.unit);
            }

            public String toString() {
                return "Metrics.Field.FieldBuilder(field=" + this.field + ", i18n=" + this.i18n + ", type=" + this.type + ", label=" + this.label + ", unit=" + this.unit + ")";
            }
        }
    }
}

