/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util.export;

import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.util.ReflectionUtils;

public final class ExcelExportUtils {
    private ExcelExportUtils() {
    }

    public static CellStyle setCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        return cellStyle;
    }

    public static <T extends Class<?>> Sheet setSheet(String sheetName, Workbook workbook, T clazz) {
        Sheet sheet = workbook.createSheet(sheetName);
        sheet.setDefaultColumnWidth(20);
        sheet.setColumnWidth(9, 10240);
        sheet.setColumnWidth(10, 10240);
        CellStyle headerCellStyle = workbook.createCellStyle();
        Font headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerCellStyle.setFont(headerFont);
        headerCellStyle.setAlignment(HorizontalAlignment.CENTER);
        ArrayList headers = new ArrayList();
        ReflectionUtils.doWithFields(clazz, field -> {
            field.setAccessible(true);
            headers.add(field.getName());
        });
        Row headerRow = sheet.createRow(0);
        String[] headerArray = headers.toArray(new String[0]);
        for (int i = 0; i < headerArray.length; ++i) {
            Cell cell = headerRow.createCell(i);
            cell.setCellValue(headerArray[i]);
            cell.setCellStyle(headerCellStyle);
        }
        return sheet;
    }
}

