/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.angus.mail.util.ASCIIUtility;

public class LineOutputStream
extends FilterOutputStream
implements jakarta.mail.util.LineOutputStream {
    private boolean allowutf8;
    private static byte[] newline = new byte[2];

    public LineOutputStream(OutputStream out) {
        this(out, false);
    }

    public LineOutputStream(OutputStream out, boolean allowutf8) {
        super(out);
        this.allowutf8 = allowutf8;
    }

    @Override
    public void writeln(String s) throws IOException {
        byte[] bytes = this.allowutf8 ? s.getBytes(StandardCharsets.UTF_8) : ASCIIUtility.getBytes(s);
        this.out.write(bytes);
        this.out.write(newline);
    }

    @Override
    public void writeln() throws IOException {
        this.out.write(newline);
    }

    static {
        LineOutputStream.newline[0] = 13;
        LineOutputStream.newline[1] = 10;
    }
}

