/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.query.timegenerator.node;

import java.io.IOException;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.Node;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.NodeType;

public class OrNode
implements Node {
    private Node leftChild;
    private Node rightChild;
    private boolean hasCachedLeftTime;
    private long cachedLeftTime;
    private boolean hasCachedRightTime;
    private long cachedRightTime;
    private boolean ascending = true;

    public OrNode(Node leftChild, Node rightChild) {
        this.leftChild = leftChild;
        this.rightChild = rightChild;
        this.hasCachedLeftTime = false;
        this.hasCachedRightTime = false;
    }

    public OrNode(Node leftChild, Node rightChild, boolean ascending) {
        this.leftChild = leftChild;
        this.rightChild = rightChild;
        this.hasCachedLeftTime = false;
        this.hasCachedRightTime = false;
        this.ascending = ascending;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.hasCachedLeftTime || this.hasCachedRightTime) {
            return true;
        }
        return this.leftChild.hasNext() || this.rightChild.hasNext();
    }

    private boolean hasLeftValue() throws IOException {
        return this.hasCachedLeftTime || this.leftChild.hasNext();
    }

    private long getLeftValue() throws IOException {
        if (this.hasCachedLeftTime) {
            this.hasCachedLeftTime = false;
            return this.cachedLeftTime;
        }
        return this.leftChild.next();
    }

    private boolean hasRightValue() throws IOException {
        return this.hasCachedRightTime || this.rightChild.hasNext();
    }

    private long getRightValue() throws IOException {
        if (this.hasCachedRightTime) {
            this.hasCachedRightTime = false;
            return this.cachedRightTime;
        }
        return this.rightChild.next();
    }

    @Override
    public long next() throws IOException {
        if (this.hasLeftValue() && !this.hasRightValue()) {
            return this.getLeftValue();
        }
        if (!this.hasLeftValue() && this.hasRightValue()) {
            return this.getRightValue();
        }
        if (this.hasLeftValue() && this.hasRightValue()) {
            long leftValue = this.getLeftValue();
            long rightValue = this.getRightValue();
            if (this.ascending) {
                return this.popAndFillNextCache(leftValue < rightValue, leftValue > rightValue, leftValue, rightValue);
            }
            return this.popAndFillNextCache(leftValue > rightValue, leftValue < rightValue, leftValue, rightValue);
        }
        throw new IOException("no more data");
    }

    private long popAndFillNextCache(boolean popLeft, boolean popRight, long left, long right) {
        if (popLeft) {
            this.hasCachedRightTime = true;
            this.cachedRightTime = right;
            return left;
        }
        if (popRight) {
            this.hasCachedLeftTime = true;
            this.cachedLeftTime = left;
            return right;
        }
        return left;
    }

    @Override
    public NodeType getType() {
        return NodeType.OR;
    }
}

