/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.util;

import cn.afterturn.easypoi.excel.annotation.Excel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PoiValidationUtil {
    private static final Validator VALIDATOR;

    public static String validation(Object obj, Class[] verfiyGroup) {
        Set set = null;
        set = verfiyGroup != null ? VALIDATOR.validate(obj, verfiyGroup) : VALIDATOR.validate(obj, new Class[0]);
        if (set != null && set.size() > 0) {
            return PoiValidationUtil.getValidateErrMsg(set);
        }
        return null;
    }

    private static String getValidateErrMsg(Set<ConstraintViolation<Object>> set) {
        StringBuilder builder = new StringBuilder();
        for (ConstraintViolation<Object> constraintViolation : set) {
            Class<?> cls = constraintViolation.getRootBean().getClass();
            String fieldName = constraintViolation.getPropertyPath().toString();
            ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(cls.getDeclaredFields()));
            Class<?> superClass = cls.getSuperclass();
            if (superClass != null) {
                fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
            }
            String name = null;
            for (Field field : fields) {
                if (!field.getName().equals(fieldName) || !field.isAnnotationPresent(Excel.class)) continue;
                name = field.getAnnotation(Excel.class).name();
                break;
            }
            if (name == null) {
                name = fieldName;
            }
            builder.append(name).append(constraintViolation.getMessage()).append(",");
        }
        return builder.substring(0, builder.length() - 1);
    }

    static {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        VALIDATOR = factory.getValidator();
    }
}

