/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.influxdb.InfluxDBMapperException;
import org.influxdb.annotation.Column;
import org.influxdb.annotation.Exclude;
import org.influxdb.annotation.Measurement;
import org.influxdb.dto.QueryResult;
import org.influxdb.impl.TypeMapper;

public class InfluxDBResultMapper {
    private static final ConcurrentMap<String, ClassInfo> CLASS_INFO_CACHE = new ConcurrentHashMap<String, ClassInfo>();
    private static final int FRACTION_MIN_WIDTH = 0;
    private static final int FRACTION_MAX_WIDTH = 9;
    private static final boolean ADD_DECIMAL_POINT = true;
    private static final DateTimeFormatter RFC3339_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendZoneOrOffsetId().toFormatter();

    public <T> List<T> toPOJO(QueryResult queryResult, Class<T> clazz) throws InfluxDBMapperException {
        return this.toPOJO(queryResult, clazz, TimeUnit.MILLISECONDS);
    }

    public <T> List<T> toPOJO(QueryResult queryResult, Class<T> clazz, TimeUnit precision) throws InfluxDBMapperException {
        this.throwExceptionIfMissingAnnotation(clazz);
        String measurementName = this.getMeasurementName(clazz);
        return this.toPOJO(queryResult, clazz, measurementName, precision);
    }

    public <T> List<T> toPOJO(QueryResult queryResult, Class<T> clazz, String measurementName) throws InfluxDBMapperException {
        return this.toPOJO(queryResult, clazz, measurementName, TimeUnit.MILLISECONDS);
    }

    public <T> List<T> toPOJO(QueryResult queryResult, Class<T> clazz, String measurementName, TimeUnit precision) throws InfluxDBMapperException {
        Objects.requireNonNull(measurementName, "measurementName");
        Objects.requireNonNull(queryResult, "queryResult");
        Objects.requireNonNull(clazz, "clazz");
        this.throwExceptionIfResultWithError(queryResult);
        this.cacheMeasurementClass(clazz);
        LinkedList result = new LinkedList();
        queryResult.getResults().stream().filter(internalResult -> Objects.nonNull(internalResult) && Objects.nonNull(internalResult.getSeries())).forEach(internalResult -> internalResult.getSeries().stream().filter(series -> series.getName().equals(measurementName)).forEachOrdered(series -> this.parseSeriesAs((QueryResult.Series)series, clazz, result, precision)));
        return result;
    }

    void throwExceptionIfMissingAnnotation(Class<?> clazz) {
        if (!clazz.isAnnotationPresent(Measurement.class)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not annotated with @" + Measurement.class.getSimpleName());
        }
    }

    void throwExceptionIfResultWithError(QueryResult queryResult) {
        if (queryResult.getError() != null) {
            throw new InfluxDBMapperException("InfluxDB returned an error: " + queryResult.getError());
        }
        queryResult.getResults().forEach(seriesResult -> {
            if (seriesResult.getError() != null) {
                throw new InfluxDBMapperException("InfluxDB returned an error with Series: " + seriesResult.getError());
            }
        });
    }

    void cacheMeasurementClass(Class<?> ... classVarAgrs) {
        for (Class<?> clazz : classVarAgrs) {
            if (CLASS_INFO_CACHE.containsKey(clazz.getName())) continue;
            ConcurrentHashMap<String, Field> fieldMap = new ConcurrentHashMap<String, Field>();
            ConcurrentHashMap<Field, TypeMapper> typeMappers = new ConcurrentHashMap<Field, TypeMapper>();
            Measurement measurement = clazz.getAnnotation(Measurement.class);
            boolean allFields = measurement != null && measurement.allFields();
            Class<?> c = clazz;
            TypeMapper typeMapper = TypeMapper.empty();
            while (c != null) {
                for (Field field : c.getDeclaredFields()) {
                    Column colAnnotation = field.getAnnotation(Column.class);
                    if (colAnnotation == null && (!allFields || field.isAnnotationPresent(Exclude.class) || Modifier.isStatic(field.getModifiers()))) continue;
                    fieldMap.put(InfluxDBResultMapper.getFieldName(field, colAnnotation), field);
                    typeMappers.put(field, typeMapper);
                }
                Class<?> superclass = c.getSuperclass();
                Type genericSuperclass = c.getGenericSuperclass();
                typeMapper = genericSuperclass instanceof ParameterizedType ? TypeMapper.of((ParameterizedType)genericSuperclass, superclass) : TypeMapper.empty();
                c = superclass;
            }
            ClassInfo classInfo = new ClassInfo();
            classInfo.fieldMap = fieldMap;
            classInfo.typeMappers = typeMappers;
            CLASS_INFO_CACHE.putIfAbsent(clazz.getName(), classInfo);
        }
    }

    private static String getFieldName(Field field, Column colAnnotation) {
        if (colAnnotation != null && !colAnnotation.name().isEmpty()) {
            return colAnnotation.name();
        }
        return field.getName();
    }

    String getMeasurementName(Class<?> clazz) {
        return clazz.getAnnotation(Measurement.class).name();
    }

    String getDatabaseName(Class<?> clazz) {
        return clazz.getAnnotation(Measurement.class).database();
    }

    String getRetentionPolicy(Class<?> clazz) {
        return clazz.getAnnotation(Measurement.class).retentionPolicy();
    }

    <T> List<T> parseSeriesAs(QueryResult.Series series, Class<T> clazz, List<T> result) {
        return this.parseSeriesAs(series, clazz, result, TimeUnit.MILLISECONDS);
    }

    <T> List<T> parseSeriesAs(QueryResult.Series series, Class<T> clazz, List<T> result, TimeUnit precision) {
        int columnSize = series.getColumns().size();
        ClassInfo classInfo = (ClassInfo)CLASS_INFO_CACHE.get(clazz.getName());
        try {
            T object = null;
            for (List<Object> row : series.getValues()) {
                for (int i = 0; i < columnSize; ++i) {
                    Field correspondingField = (Field)classInfo.fieldMap.get(series.getColumns().get(i));
                    if (correspondingField == null) continue;
                    if (object == null) {
                        object = clazz.newInstance();
                    }
                    InfluxDBResultMapper.setFieldValue(object, correspondingField, row.get(i), precision, (TypeMapper)classInfo.typeMappers.get(correspondingField));
                }
                if (series.getTags() != null && !series.getTags().isEmpty()) {
                    for (Map.Entry<String, String> entry : series.getTags().entrySet()) {
                        Field correspondingField = (Field)classInfo.fieldMap.get(entry.getKey());
                        if (correspondingField == null) continue;
                        InfluxDBResultMapper.setFieldValue(object, correspondingField, entry.getValue(), precision, (TypeMapper)classInfo.typeMappers.get(correspondingField));
                    }
                }
                if (object == null) continue;
                result.add(object);
                object = null;
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InfluxDBMapperException(e);
        }
        return result;
    }

    private static <T> void setFieldValue(T object, Field field, Object value, TimeUnit precision, TypeMapper typeMapper) throws IllegalArgumentException, IllegalAccessException {
        if (value == null) {
            return;
        }
        Type fieldType = typeMapper.resolve(field.getGenericType());
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        field.set(object, InfluxDBResultMapper.adaptValue((Class)fieldType, value, precision, field.getName(), object.getClass().getName()));
    }

    private static Object adaptValue(Class<?> fieldType, Object value, TimeUnit precision, String fieldName, String className) {
        try {
            if (String.class.isAssignableFrom(fieldType)) {
                return String.valueOf(value);
            }
            if (Instant.class.isAssignableFrom(fieldType)) {
                if (value instanceof String) {
                    return Instant.from(RFC3339_FORMATTER.parse(String.valueOf(value)));
                }
                if (value instanceof Long) {
                    return Instant.ofEpochMilli(InfluxDBResultMapper.toMillis((Long)value, precision));
                }
                if (value instanceof Double) {
                    return Instant.ofEpochMilli(InfluxDBResultMapper.toMillis(((Double)value).longValue(), precision));
                }
                if (value instanceof Integer) {
                    return Instant.ofEpochMilli(InfluxDBResultMapper.toMillis(((Integer)value).longValue(), precision));
                }
                throw new InfluxDBMapperException("Unsupported type " + fieldType + " for field " + fieldName);
            }
            if (Double.class.isAssignableFrom(fieldType) || Double.TYPE.isAssignableFrom(fieldType)) {
                return value;
            }
            if (Long.class.isAssignableFrom(fieldType) || Long.TYPE.isAssignableFrom(fieldType)) {
                return ((Double)value).longValue();
            }
            if (Integer.class.isAssignableFrom(fieldType) || Integer.TYPE.isAssignableFrom(fieldType)) {
                return ((Double)value).intValue();
            }
            if (Boolean.class.isAssignableFrom(fieldType) || Boolean.TYPE.isAssignableFrom(fieldType)) {
                return Boolean.valueOf(String.valueOf(value));
            }
            if (Enum.class.isAssignableFrom(fieldType)) {
                return Enum.valueOf(fieldType, String.valueOf(value));
            }
        }
        catch (ClassCastException e) {
            String msg = "Class '%s' field '%s' was defined with a different field type and caused a ClassCastException. The correct type is '%s' (current field value: '%s').";
            throw new InfluxDBMapperException(String.format(msg, className, fieldName, value.getClass().getName(), value));
        }
        throw new InfluxDBMapperException(String.format("Class '%s' field '%s' is from an unsupported type '%s'.", className, fieldName, fieldType));
    }

    private static long toMillis(long value, TimeUnit precision) {
        return TimeUnit.MILLISECONDS.convert(value, precision);
    }

    private static class ClassInfo {
        ConcurrentMap<String, Field> fieldMap;
        ConcurrentMap<Field, TypeMapper> typeMappers;

        private ClassInfo() {
        }
    }
}

