/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.rpc.interceptors;

import io.greptime.rpc.Context;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

public class ContextToHeadersInterceptor
implements ClientInterceptor {
    private static final ThreadLocal<Context> CURRENT_CTX = new ThreadLocal();

    public static void setCurrentCtx(Context ctx) {
        CURRENT_CTX.set(ctx);
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOpts, Channel next) {
        return new HeaderAttachingClientCall(next.newCall(method, callOpts));
    }

    private static final class HeaderAttachingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        HeaderAttachingClientCall(ClientCall<ReqT, RespT> delegate) {
            super(delegate);
        }

        public void start(ClientCall.Listener<RespT> respListener, Metadata headers) {
            Context ctx = (Context)CURRENT_CTX.get();
            if (ctx != null) {
                ctx.entrySet().forEach(e -> headers.put(Metadata.Key.of((String)((String)e.getKey()), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)String.valueOf(e.getValue())));
            }
            CURRENT_CTX.remove();
            super.start(respListener, headers);
        }
    }
}

