/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.Timer;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SniCompletionEvent;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.Supplier;
import reactor.netty.Metrics;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.AbstractChannelMetricsHandler;
import reactor.netty.channel.ConnectObservations;
import reactor.netty.channel.MicrometerChannelMetricsRecorder;
import reactor.netty.observability.ReactorNettyHandlerContext;
import reactor.util.annotation.Nullable;
import reactor.util.context.ContextView;

public final class MicrometerChannelMetricsHandler
extends AbstractChannelMetricsHandler {
    final MicrometerChannelMetricsRecorder recorder;

    MicrometerChannelMetricsHandler(MicrometerChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress, boolean onServer) {
        super(remoteAddress, onServer);
        this.recorder = recorder;
    }

    @Override
    public ChannelHandler connectMetricsHandler() {
        return new ConnectMetricsHandler(this.recorder, this.proxyAddress);
    }

    @Override
    public ChannelHandler tlsMetricsHandler() {
        return new TlsMetricsHandler(this.recorder, this.onServer, this.remoteAddress, this.proxyAddress);
    }

    @Override
    public MicrometerChannelMetricsRecorder recorder() {
        return this.recorder;
    }

    static final class TlsMetricsHandler
    extends Observation.Context
    implements ReactorNettyHandlerContext,
    ChannelInboundHandler,
    Supplier<Observation.Context> {
        static final String CONTEXTUAL_NAME = "tls handshake";
        static final String TYPE_CLIENT = "client";
        static final String TYPE_SERVER = "server";
        final String proxyAddress;
        final MicrometerChannelMetricsRecorder recorder;
        final SocketAddress remoteAddress;
        final String type;
        boolean listenerAdded;
        Observation observation;
        String netPeerName;
        String netPeerPort;
        String status = "UNKNOWN";
        ContextView parentContextView;

        TlsMetricsHandler(MicrometerChannelMetricsRecorder recorder, boolean onServer, @Nullable SocketAddress remoteAddress, @Nullable SocketAddress proxyAddress) {
            this.proxyAddress = Metrics.formatSocketAddress(proxyAddress);
            this.recorder = recorder;
            this.remoteAddress = remoteAddress;
            this.type = onServer ? TYPE_SERVER : TYPE_CLIENT;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            this.addListener(ctx);
            ctx.fireChannelActive();
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            ctx.fireChannelInactive();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            ctx.fireChannelRead(msg);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            ctx.fireChannelReadComplete();
        }

        public void channelRegistered(ChannelHandlerContext ctx) {
            ctx.fireChannelRegistered();
        }

        public void channelUnregistered(ChannelHandlerContext ctx) {
            ctx.fireChannelUnregistered();
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
            ctx.fireChannelWritabilityChanged();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.fireExceptionCaught(cause);
        }

        @Override
        public Observation.Context get() {
            return this;
        }

        public String getContextualName() {
            return CONTEXTUAL_NAME;
        }

        public KeyValues getHighCardinalityKeyValues() {
            return KeyValues.of((String[])new String[]{ConnectObservations.ConnectTimeHighCardinalityTags.NET_PEER_NAME.asString(), this.netPeerName, ConnectObservations.ConnectTimeHighCardinalityTags.NET_PEER_PORT.asString(), this.netPeerPort, ConnectObservations.ConnectTimeHighCardinalityTags.REACTOR_NETTY_PROTOCOL.asString(), this.recorder.protocol(), ConnectObservations.ConnectTimeHighCardinalityTags.REACTOR_NETTY_STATUS.asString(), this.status, ConnectObservations.ConnectTimeHighCardinalityTags.REACTOR_NETTY_TYPE.asString(), this.type});
        }

        public KeyValues getLowCardinalityKeyValues() {
            if (this.recorder.onServer) {
                return KeyValues.of((String[])new String[]{ConnectObservations.ConnectTimeLowCardinalityTags.REMOTE_ADDRESS.asString(), this.netPeerName + ':' + this.netPeerPort, ConnectObservations.ConnectTimeLowCardinalityTags.STATUS.asString(), this.status});
            }
            return KeyValues.of((String[])new String[]{ConnectObservations.ConnectTimeLowCardinalityTags.REMOTE_ADDRESS.asString(), this.netPeerName + ':' + this.netPeerPort, ConnectObservations.ConnectTimeLowCardinalityTags.PROXY_ADDRESS.asString(), this.proxyAddress == null ? "na" : this.proxyAddress, ConnectObservations.ConnectTimeLowCardinalityTags.STATUS.asString(), this.status});
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt instanceof SniCompletionEvent) {
                this.addListener(ctx);
            }
            ctx.fireUserEventTriggered(evt);
        }

        @Override
        public Timer getTimer() {
            return this.recorder.getTlsHandshakeTimer(this.getName(), this.netPeerName + ':' + this.netPeerPort, this.proxyAddress == null ? "na" : this.proxyAddress, this.status);
        }

        private void addListener(ChannelHandlerContext ctx) {
            SslHandler sslHandler;
            if (!this.listenerAdded && (sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class)) != null) {
                SocketAddress rAddr;
                this.listenerAdded = true;
                SocketAddress socketAddress = rAddr = this.remoteAddress != null ? this.remoteAddress : ctx.channel().remoteAddress();
                if (rAddr instanceof InetSocketAddress) {
                    InetSocketAddress address = (InetSocketAddress)rAddr;
                    this.netPeerName = address.getHostString();
                    this.netPeerPort = address.getPort() + "";
                } else {
                    this.netPeerName = rAddr.toString();
                    this.netPeerPort = "";
                }
                this.observation = Observation.createNotStarted((String)(this.recorder.name() + ".tls.handshake.time"), (Supplier)this, (ObservationRegistry)Metrics.OBSERVATION_REGISTRY);
                this.parentContextView = Metrics.updateChannelContext(ctx.channel(), this.observation);
                this.observation.start();
                sslHandler.handshakeFuture().addListener(f -> {
                    ctx.pipeline().remove((ChannelHandler)this);
                    this.status = f.isSuccess() ? "SUCCESS" : "ERROR";
                    this.observation.stop();
                    ReactorNetty.setChannelContext(ctx.channel(), this.parentContextView);
                    this.parentContextView = null;
                });
            }
        }
    }

    static final class ConnectMetricsHandler
    extends Observation.Context
    implements ReactorNettyHandlerContext,
    ChannelOutboundHandler,
    Supplier<Observation.Context> {
        static final String CONTEXTUAL_NAME = "connect";
        static final String TYPE = "client";
        final String proxyAddress;
        final MicrometerChannelMetricsRecorder recorder;
        String netPeerName;
        String netPeerPort;
        String status = "UNKNOWN";
        ContextView parentContextView;

        ConnectMetricsHandler(MicrometerChannelMetricsRecorder recorder, @Nullable SocketAddress proxyAddress) {
            this.proxyAddress = Metrics.formatSocketAddress(proxyAddress);
            this.recorder = recorder;
        }

        @Override
        public Observation.Context get() {
            return this;
        }

        @Override
        public Timer getTimer() {
            return this.recorder.getConnectTimer(this.getName(), this.netPeerName + ":" + this.netPeerPort, this.proxyAddress == null ? "na" : this.proxyAddress, this.status);
        }

        public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
            ctx.bind(localAddress, promise);
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
            ctx.close(promise);
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            if (remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)remoteAddress;
                this.netPeerName = address.getHostString();
                this.netPeerPort = address.getPort() + "";
            } else {
                this.netPeerName = remoteAddress.toString();
                this.netPeerPort = "";
            }
            Observation observation = Observation.createNotStarted((String)(this.recorder.name() + ".connect.time"), (Supplier)this, (ObservationRegistry)Metrics.OBSERVATION_REGISTRY);
            this.parentContextView = Metrics.updateChannelContext(ctx.channel(), observation);
            observation.start();
            ctx.connect(remoteAddress, localAddress, promise).addListener(future -> {
                ctx.pipeline().remove((ChannelHandler)this);
                this.status = future.isSuccess() ? "SUCCESS" : "ERROR";
                observation.stop();
                ReactorNetty.setChannelContext(ctx.channel(), this.parentContextView);
                this.parentContextView = null;
            });
        }

        public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
            ctx.deregister(promise);
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
            ctx.disconnect(promise);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.fireExceptionCaught(cause);
        }

        public void flush(ChannelHandlerContext ctx) {
            ctx.flush();
        }

        public String getContextualName() {
            return CONTEXTUAL_NAME;
        }

        public KeyValues getHighCardinalityKeyValues() {
            return KeyValues.of((String[])new String[]{ConnectObservations.ConnectTimeHighCardinalityTags.NET_PEER_NAME.asString(), this.netPeerName, ConnectObservations.ConnectTimeHighCardinalityTags.NET_PEER_PORT.asString(), this.netPeerPort, ConnectObservations.ConnectTimeHighCardinalityTags.REACTOR_NETTY_PROTOCOL.asString(), this.recorder.protocol(), ConnectObservations.ConnectTimeHighCardinalityTags.REACTOR_NETTY_STATUS.asString(), this.status, ConnectObservations.ConnectTimeHighCardinalityTags.REACTOR_NETTY_TYPE.asString(), TYPE});
        }

        public KeyValues getLowCardinalityKeyValues() {
            return KeyValues.of((String[])new String[]{ConnectObservations.ConnectTimeLowCardinalityTags.REMOTE_ADDRESS.asString(), this.netPeerName + ":" + this.netPeerPort, ConnectObservations.ConnectTimeLowCardinalityTags.PROXY_ADDRESS.asString(), this.proxyAddress == null ? "na" : this.proxyAddress, ConnectObservations.ConnectTimeLowCardinalityTags.STATUS.asString(), this.status});
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
        }

        public void read(ChannelHandlerContext ctx) {
            ctx.read();
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            ctx.write(msg, promise);
        }
    }
}

