/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.springframework.data.domain.Persistable;
import org.springframework.data.util.ProxyUtils;
import org.springframework.lang.Nullable;

@MappedSuperclass
public abstract class AbstractPersistable<PK extends Serializable>
implements Persistable<PK> {
    @Id
    @GeneratedValue
    @Nullable
    private PK id;

    @Nullable
    public PK getId() {
        return this.id;
    }

    protected void setId(@Nullable PK id) {
        this.id = id;
    }

    @Transient
    public boolean isNew() {
        return this.getId() == null;
    }

    public String toString() {
        return String.format("Entity of type %s with id: %s", this.getClass().getName(), this.getId());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!this.getClass().equals(ProxyUtils.getUserClass((Object)obj))) {
            return false;
        }
        AbstractPersistable that = (AbstractPersistable)obj;
        return this.getId() == null ? false : this.getId().equals(that.getId());
    }

    public int hashCode() {
        int hashCode = 17;
        return hashCode += this.getId() == null ? 0 : this.getId().hashCode() * 31;
    }
}

