/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.metamodel.Metamodel;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.repository.query.DefaultJpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaMetamodelEntityInformation;
import org.springframework.data.jpa.repository.support.JpaPersistableEntityInformation;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.util.Assert;

public abstract class JpaEntityInformationSupport<T, ID>
extends AbstractEntityInformation<T, ID>
implements JpaEntityInformation<T, ID> {
    private JpaEntityMetadata<T> metadata;

    public JpaEntityInformationSupport(Class<T> domainClass) {
        super(domainClass);
        this.metadata = new DefaultJpaEntityMetadata<T>(domainClass);
    }

    public static <T> JpaEntityInformation<T, ?> getEntityInformation(Class<T> domainClass, EntityManager em) {
        Assert.notNull(domainClass, (String)"Domain class must not be null");
        Assert.notNull((Object)em, (String)"EntityManager must not be null");
        Metamodel metamodel = em.getMetamodel();
        PersistenceUnitUtil persistenceUnitUtil = em.getEntityManagerFactory().getPersistenceUnitUtil();
        if (Persistable.class.isAssignableFrom(domainClass)) {
            return new JpaPersistableEntityInformation(domainClass, metamodel, persistenceUnitUtil);
        }
        return new JpaMetamodelEntityInformation(domainClass, metamodel, persistenceUnitUtil);
    }

    @Override
    public String getEntityName() {
        return this.metadata.getEntityName();
    }
}

