/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TimeoutCommand;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TimeoutPoller
implements Runnable {
    private List<TimeoutCommand<TDSCommand>> timeoutCommands = new ArrayList<TimeoutCommand<TDSCommand>>();
    static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.TimeoutPoller");
    private static volatile TimeoutPoller timeoutPoller = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static TimeoutPoller getTimeoutPoller() {
        if (timeoutPoller != null) return timeoutPoller;
        Class<TimeoutPoller> clazz = TimeoutPoller.class;
        synchronized (TimeoutPoller.class) {
            if (timeoutPoller != null) return timeoutPoller;
            timeoutPoller = new TimeoutPoller();
            Thread pollerThread = new Thread((Runnable)timeoutPoller, "mssql-jdbc-TimeoutPoller");
            pollerThread.setDaemon(true);
            pollerThread.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return timeoutPoller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTimeoutCommand(TimeoutCommand<TDSCommand> timeoutCommand) {
        List<TimeoutCommand<TDSCommand>> list = this.timeoutCommands;
        synchronized (list) {
            this.timeoutCommands.add(timeoutCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(TimeoutCommand<TDSCommand> timeoutCommand) {
        List<TimeoutCommand<TDSCommand>> list = this.timeoutCommands;
        synchronized (list) {
            this.timeoutCommands.remove(timeoutCommand);
        }
    }

    private TimeoutPoller() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                List<TimeoutCommand<TDSCommand>> list = this.timeoutCommands;
                synchronized (list) {
                    Iterator<TimeoutCommand<TDSCommand>> timeoutCommandIterator = this.timeoutCommands.iterator();
                    while (timeoutCommandIterator.hasNext()) {
                        TimeoutCommand<TDSCommand> timeoutCommand = timeoutCommandIterator.next();
                        try {
                            if (!timeoutCommand.canTimeout()) continue;
                            try {
                                timeoutCommand.interrupt();
                            }
                            finally {
                                timeoutCommandIterator.remove();
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "Could not timeout command", e);
                        }
                    }
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing timeout commands", e);
            return;
        }
    }
}

