/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.context.IContext;
import org.thymeleaf.util.Validate;

public abstract class AbstractContext
implements IContext {
    private final Map<String, Object> variables;
    private Locale locale;

    protected AbstractContext() {
        this(null, null);
    }

    protected AbstractContext(Locale locale) {
        this(locale, null);
    }

    protected AbstractContext(Locale locale, Map<String, Object> variables) {
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.variables = variables == null ? new LinkedHashMap<String, Object>(10) : new LinkedHashMap<String, Object>(variables);
    }

    @Override
    public final Locale getLocale() {
        return this.locale;
    }

    @Override
    public final boolean containsVariable(String name) {
        return this.variables.containsKey(name);
    }

    @Override
    public final Set<String> getVariableNames() {
        return this.variables.keySet();
    }

    @Override
    public final Object getVariable(String name) {
        return this.variables.get(name);
    }

    public void setLocale(Locale locale) {
        Validate.notNull(locale, "Locale cannot be null");
        this.locale = locale;
    }

    public void setVariable(String name, Object value) {
        this.variables.put(name, value);
    }

    public void setVariables(Map<String, Object> variables) {
        if (variables == null) {
            return;
        }
        this.variables.putAll(variables);
    }

    public void removeVariable(String name) {
        this.variables.remove(name);
    }

    public void clearVariables() {
        this.variables.clear();
    }
}

