/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.IdentifierSequences;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.expression.ExpressionObjects;
import org.thymeleaf.expression.IExpressionObjects;
import org.thymeleaf.linkbuilder.ILinkBuilder;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.Validate;

public abstract class AbstractEngineContext
implements IEngineContext {
    private final IEngineConfiguration configuration;
    private final Map<String, Object> templateResolutionAttributes;
    private final Locale locale;
    private IExpressionObjects expressionObjects = null;
    private IdentifierSequences identifierSequences = null;

    protected AbstractEngineContext(IEngineConfiguration configuration, Map<String, Object> templateResolutionAttributes, Locale locale) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(locale, "Locale cannot be null");
        this.configuration = configuration;
        this.locale = locale;
        this.templateResolutionAttributes = templateResolutionAttributes;
        this.identifierSequences = null;
    }

    @Override
    public final IEngineConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public final Map<String, Object> getTemplateResolutionAttributes() {
        return this.templateResolutionAttributes;
    }

    @Override
    public final Locale getLocale() {
        return this.locale;
    }

    @Override
    public final IExpressionObjects getExpressionObjects() {
        if (this.expressionObjects == null) {
            this.expressionObjects = new ExpressionObjects(this, this.configuration.getExpressionObjectFactory());
        }
        return this.expressionObjects;
    }

    @Override
    public final TemplateMode getTemplateMode() {
        return this.getTemplateData().getTemplateMode();
    }

    @Override
    public final IModelFactory getModelFactory() {
        return this.configuration.getModelFactory(this.getTemplateMode());
    }

    @Override
    public final String getMessage(Class<?> origin, String key, Object[] messageParameters, boolean useAbsentMessageRepresentation) {
        Validate.notNull(key, "Message key cannot be null");
        Set<IMessageResolver> messageResolvers = this.configuration.getMessageResolvers();
        for (IMessageResolver messageResolver : messageResolvers) {
            String resolvedMessage = messageResolver.resolveMessage(this, origin, key, messageParameters);
            if (resolvedMessage == null) continue;
            return resolvedMessage;
        }
        if (useAbsentMessageRepresentation) {
            for (IMessageResolver messageResolver : messageResolvers) {
                String absentMessageRepresentation = messageResolver.createAbsentMessageRepresentation(this, origin, key, messageParameters);
                if (absentMessageRepresentation == null) continue;
                return absentMessageRepresentation;
            }
        }
        return null;
    }

    @Override
    public final String buildLink(String base, Map<String, Object> parameters) {
        Set<ILinkBuilder> linkBuilders = this.configuration.getLinkBuilders();
        for (ILinkBuilder linkBuilder : linkBuilders) {
            String link = linkBuilder.buildLink(this, base, parameters);
            if (link == null) continue;
            return link;
        }
        throw new TemplateProcessingException("No configured link builder instance was able to build link with base \"" + base + "\" and parameters " + parameters);
    }

    @Override
    public final IdentifierSequences getIdentifierSequences() {
        if (this.identifierSequences == null) {
            this.identifierSequences = new IdentifierSequences();
        }
        return this.identifierSequences;
    }
}

