/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.Validate;

public final class IdentifierSequences {
    private final Map<String, Integer> idCounts = new HashMap<String, Integer>(1, 1.0f);

    public Integer getAndIncrementIDSeq(String id) {
        Validate.notNull(id, "ID cannot be null");
        Integer count = this.idCounts.get(id);
        if (count == null) {
            count = 1;
        }
        this.idCounts.put(id, count + 1);
        return count;
    }

    public Integer getNextIDSeq(String id) {
        Validate.notNull(id, "ID cannot be null");
        Integer count = this.idCounts.get(id);
        if (count == null) {
            count = 1;
        }
        return count;
    }

    public Integer getPreviousIDSeq(String id) {
        Validate.notNull(id, "ID cannot be null");
        Integer count = this.idCounts.get(id);
        if (count == null) {
            throw new TemplateProcessingException("Cannot obtain previous ID count for ID \"" + id + "\"");
        }
        return count - 1;
    }
}

