/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeNames;
import org.thymeleaf.engine.HTMLAttributeDefinition;
import org.thymeleaf.engine.HTMLAttributeName;
import org.thymeleaf.engine.TextAttributeDefinition;
import org.thymeleaf.engine.TextAttributeName;
import org.thymeleaf.engine.XMLAttributeDefinition;
import org.thymeleaf.engine.XMLAttributeName;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.processor.element.IElementProcessor;
import org.thymeleaf.processor.element.MatchingAttributeName;
import org.thymeleaf.processor.element.MatchingElementName;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.TextUtils;

public final class AttributeDefinitions {
    public static final Set<String> ALL_STANDARD_HTML_ATTRIBUTE_NAMES;
    private static final Set<String> ALL_STANDARD_BOOLEAN_HTML_ATTRIBUTE_NAMES;
    private final AttributeDefinitionRepository htmlAttributeRepository;
    private final AttributeDefinitionRepository xmlAttributeRepository;
    private final AttributeDefinitionRepository textAttributeRepository;
    private final AttributeDefinitionRepository javascriptAttributeRepository;
    private final AttributeDefinitionRepository cssAttributeRepository;

    public AttributeDefinitions(Map<TemplateMode, Set<IElementProcessor>> elementProcessorsByTemplateMode) {
        ArrayList<HTMLAttributeDefinition> standardHTMLAttributeDefinitions = new ArrayList<HTMLAttributeDefinition>(ALL_STANDARD_HTML_ATTRIBUTE_NAMES.size() + 1);
        for (String string : ALL_STANDARD_HTML_ATTRIBUTE_NAMES) {
            standardHTMLAttributeDefinitions.add(AttributeDefinitions.buildHTMLAttributeDefinition(AttributeNames.forHTMLName(string), elementProcessorsByTemplateMode.get((Object)TemplateMode.HTML)));
        }
        this.htmlAttributeRepository = new AttributeDefinitionRepository(TemplateMode.HTML, elementProcessorsByTemplateMode);
        this.xmlAttributeRepository = new AttributeDefinitionRepository(TemplateMode.XML, elementProcessorsByTemplateMode);
        this.textAttributeRepository = new AttributeDefinitionRepository(TemplateMode.TEXT, elementProcessorsByTemplateMode);
        this.javascriptAttributeRepository = new AttributeDefinitionRepository(TemplateMode.JAVASCRIPT, elementProcessorsByTemplateMode);
        this.cssAttributeRepository = new AttributeDefinitionRepository(TemplateMode.CSS, elementProcessorsByTemplateMode);
        for (AttributeDefinition attributeDefinition : standardHTMLAttributeDefinitions) {
            this.htmlAttributeRepository.storeStandardAttribute(attributeDefinition);
        }
    }

    private static HTMLAttributeDefinition buildHTMLAttributeDefinition(HTMLAttributeName name, Set<IElementProcessor> elementProcessors) {
        LinkedHashSet<IElementProcessor> associatedProcessors = new LinkedHashSet<IElementProcessor>(2);
        if (elementProcessors != null) {
            for (IElementProcessor processor : elementProcessors) {
                TemplateMode templateMode = processor.getTemplateMode();
                if (templateMode != TemplateMode.HTML) continue;
                MatchingElementName matchingElementName = processor.getMatchingElementName();
                MatchingAttributeName matchingAttributeName = processor.getMatchingAttributeName();
                if (matchingElementName != null && matchingElementName.getTemplateMode() != TemplateMode.HTML || matchingAttributeName != null && matchingAttributeName.getTemplateMode() != TemplateMode.HTML) {
                    throw new ConfigurationException("HTML processors must return HTML element names and HTML attribute names (processor: " + processor.getClass().getName() + ")");
                }
                if (matchingAttributeName == null || matchingAttributeName.isMatchingAllAttributes() || !matchingAttributeName.matches(name)) continue;
                associatedProcessors.add(processor);
            }
        }
        boolean booleanAttribute = false;
        for (String completeAttributeName : name.getCompleteAttributeNames()) {
            if (!ALL_STANDARD_BOOLEAN_HTML_ATTRIBUTE_NAMES.contains(completeAttributeName)) continue;
            booleanAttribute = true;
        }
        return new HTMLAttributeDefinition(name, booleanAttribute, associatedProcessors);
    }

    private static XMLAttributeDefinition buildXMLAttributeDefinition(XMLAttributeName name, Set<IElementProcessor> elementProcessors) {
        LinkedHashSet<IElementProcessor> associatedProcessors = new LinkedHashSet<IElementProcessor>(2);
        if (elementProcessors != null) {
            for (IElementProcessor processor : elementProcessors) {
                TemplateMode templateMode = processor.getTemplateMode();
                if (templateMode != TemplateMode.XML) continue;
                MatchingElementName matchingElementName = processor.getMatchingElementName();
                MatchingAttributeName matchingAttributeName = processor.getMatchingAttributeName();
                if (matchingElementName != null && matchingElementName.getTemplateMode() != TemplateMode.XML || matchingAttributeName != null && matchingAttributeName.getTemplateMode() != TemplateMode.XML) {
                    throw new ConfigurationException("XML processors must return XML element names and XML attribute names (processor: " + processor.getClass().getName() + ")");
                }
                if (matchingAttributeName == null || matchingAttributeName.isMatchingAllAttributes() || !matchingAttributeName.matches(name)) continue;
                associatedProcessors.add(processor);
            }
        }
        return new XMLAttributeDefinition(name, associatedProcessors);
    }

    private static TextAttributeDefinition buildTextAttributeDefinition(TemplateMode templateMode, TextAttributeName name, Set<IElementProcessor> elementProcessors) {
        LinkedHashSet<IElementProcessor> associatedProcessors = new LinkedHashSet<IElementProcessor>(2);
        if (elementProcessors != null) {
            for (IElementProcessor processor : elementProcessors) {
                if (processor.getTemplateMode() != templateMode) continue;
                MatchingElementName matchingElementName = processor.getMatchingElementName();
                MatchingAttributeName matchingAttributeName = processor.getMatchingAttributeName();
                if (matchingElementName != null && matchingElementName.getTemplateMode() != templateMode || matchingAttributeName != null && matchingAttributeName.getTemplateMode() != templateMode) {
                    throw new ConfigurationException((Object)((Object)templateMode) + " processors must return " + (Object)((Object)templateMode) + "element names and " + (Object)((Object)templateMode) + " attribute names (processor: " + processor.getClass().getName() + ")");
                }
                if (matchingAttributeName == null || matchingAttributeName.isMatchingAllAttributes() || !matchingAttributeName.matches(name)) continue;
                associatedProcessors.add(processor);
            }
        }
        return new TextAttributeDefinition(name, associatedProcessors);
    }

    public AttributeDefinition forName(TemplateMode templateMode, String attributeName) {
        if (templateMode == null) {
            throw new IllegalArgumentException("Template Mode cannot be null");
        }
        switch (templateMode) {
            case HTML: {
                return this.forHTMLName(attributeName);
            }
            case XML: {
                return this.forXMLName(attributeName);
            }
            case TEXT: {
                return this.forTextName(attributeName);
            }
            case JAVASCRIPT: {
                return this.forJavaScriptName(attributeName);
            }
            case CSS: {
                return this.forCSSName(attributeName);
            }
            case RAW: {
                throw new IllegalArgumentException("Attribute Definitions cannot be obtained for " + (Object)((Object)templateMode) + " template mode ");
            }
        }
        throw new IllegalArgumentException("Unknown template mode " + (Object)((Object)templateMode));
    }

    public AttributeDefinition forName(TemplateMode templateMode, String prefix, String attributeName) {
        if (templateMode == null) {
            throw new IllegalArgumentException("Template Mode cannot be null");
        }
        switch (templateMode) {
            case HTML: {
                return this.forHTMLName(prefix, attributeName);
            }
            case XML: {
                return this.forXMLName(prefix, attributeName);
            }
            case TEXT: {
                return this.forTextName(prefix, attributeName);
            }
            case JAVASCRIPT: {
                return this.forJavaScriptName(prefix, attributeName);
            }
            case CSS: {
                return this.forCSSName(prefix, attributeName);
            }
            case RAW: {
                throw new IllegalArgumentException("Attribute Definitions cannot be obtained for " + (Object)((Object)templateMode) + " template mode ");
            }
        }
        throw new IllegalArgumentException("Unknown template mode " + (Object)((Object)templateMode));
    }

    public AttributeDefinition forName(TemplateMode templateMode, char[] attributeName, int attributeNameOffset, int attributeNameLen) {
        if (templateMode == null) {
            throw new IllegalArgumentException("Template Mode cannot be null");
        }
        switch (templateMode) {
            case HTML: {
                return this.forHTMLName(attributeName, attributeNameOffset, attributeNameLen);
            }
            case XML: {
                return this.forXMLName(attributeName, attributeNameOffset, attributeNameLen);
            }
            case TEXT: {
                return this.forTextName(attributeName, attributeNameOffset, attributeNameLen);
            }
            case JAVASCRIPT: {
                return this.forJavaScriptName(attributeName, attributeNameOffset, attributeNameLen);
            }
            case CSS: {
                return this.forCSSName(attributeName, attributeNameOffset, attributeNameLen);
            }
            case RAW: {
                throw new IllegalArgumentException("Attribute Definitions cannot be obtained for " + (Object)((Object)templateMode) + " template mode ");
            }
        }
        throw new IllegalArgumentException("Unknown template mode " + (Object)((Object)templateMode));
    }

    public HTMLAttributeDefinition forHTMLName(String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (HTMLAttributeDefinition)this.htmlAttributeRepository.getAttribute(attributeName);
    }

    public HTMLAttributeDefinition forHTMLName(String prefix, String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (HTMLAttributeDefinition)this.htmlAttributeRepository.getAttribute(prefix, attributeName);
    }

    public HTMLAttributeDefinition forHTMLName(char[] attributeName, int attributeNameOffset, int attributeNameLen) {
        if (attributeName == null || attributeNameLen == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (attributeNameOffset < 0 || attributeNameLen < 0) {
            throw new IllegalArgumentException("Both name offset and length must be equal to or greater than zero");
        }
        return (HTMLAttributeDefinition)this.htmlAttributeRepository.getAttribute(attributeName, attributeNameOffset, attributeNameLen);
    }

    public XMLAttributeDefinition forXMLName(String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (XMLAttributeDefinition)this.xmlAttributeRepository.getAttribute(attributeName);
    }

    public XMLAttributeDefinition forXMLName(String prefix, String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (XMLAttributeDefinition)this.xmlAttributeRepository.getAttribute(prefix, attributeName);
    }

    public XMLAttributeDefinition forXMLName(char[] attributeName, int attributeNameOffset, int attributeNameLen) {
        if (attributeName == null || attributeNameLen == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (attributeNameOffset < 0 || attributeNameLen < 0) {
            throw new IllegalArgumentException("Both name offset and length must be equal to or greater than zero");
        }
        return (XMLAttributeDefinition)this.xmlAttributeRepository.getAttribute(attributeName, attributeNameOffset, attributeNameLen);
    }

    public TextAttributeDefinition forTextName(String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (TextAttributeDefinition)this.textAttributeRepository.getAttribute(attributeName);
    }

    public TextAttributeDefinition forTextName(String prefix, String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (TextAttributeDefinition)this.textAttributeRepository.getAttribute(prefix, attributeName);
    }

    public TextAttributeDefinition forTextName(char[] attributeName, int attributeNameOffset, int attributeNameLen) {
        if (attributeName == null || attributeNameLen == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (attributeNameOffset < 0 || attributeNameLen < 0) {
            throw new IllegalArgumentException("Both name offset and length must be equal to or greater than zero");
        }
        return (TextAttributeDefinition)this.textAttributeRepository.getAttribute(attributeName, attributeNameOffset, attributeNameLen);
    }

    public TextAttributeDefinition forJavaScriptName(String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (TextAttributeDefinition)this.javascriptAttributeRepository.getAttribute(attributeName);
    }

    public TextAttributeDefinition forJavaScriptName(String prefix, String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (TextAttributeDefinition)this.javascriptAttributeRepository.getAttribute(prefix, attributeName);
    }

    public TextAttributeDefinition forJavaScriptName(char[] attributeName, int attributeNameOffset, int attributeNameLen) {
        if (attributeName == null || attributeNameLen == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (attributeNameOffset < 0 || attributeNameLen < 0) {
            throw new IllegalArgumentException("Both name offset and length must be equal to or greater than zero");
        }
        return (TextAttributeDefinition)this.javascriptAttributeRepository.getAttribute(attributeName, attributeNameOffset, attributeNameLen);
    }

    public TextAttributeDefinition forCSSName(String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (TextAttributeDefinition)this.cssAttributeRepository.getAttribute(attributeName);
    }

    public TextAttributeDefinition forCSSName(String prefix, String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (TextAttributeDefinition)this.cssAttributeRepository.getAttribute(prefix, attributeName);
    }

    public TextAttributeDefinition forCSSName(char[] attributeName, int attributeNameOffset, int attributeNameLen) {
        if (attributeName == null || attributeNameLen == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (attributeNameOffset < 0 || attributeNameLen < 0) {
            throw new IllegalArgumentException("Both name offset and length must be equal to or greater than zero");
        }
        return (TextAttributeDefinition)this.cssAttributeRepository.getAttribute(attributeName, attributeNameOffset, attributeNameLen);
    }

    static {
        ArrayList<String> htmlAttributeNameListAux = new ArrayList<String>(Arrays.asList("abbr", "accept", "accept-charset", "accesskey", "action", "align", "alt", "archive", "async", "autocomplete", "autofocus", "autoplay", "axis", "border", "cellpadding", "cellspacing", "challenge", "char", "charoff", "charset", "checked", "cite", "class", "classid", "codebase", "codetype", "cols", "colspan", "command", "content", "contenteditable", "contextmenu", "controls", "coords", "data", "datetime", "declare", "default", "defer", "dir", "disabled", "draggable", "dropzone", "enctype", "for", "form", "formaction", "formenctype", "formmethod", "formnovalidate", "formtarget", "frame", "headers", "height", "hidden", "high", "href", "hreflang", "http-equiv", "icon", "id", "ismap", "keytype", "kind", "label", "lang", "list", "longdesc", "loop", "low", "max", "maxlength", "media", "method", "min", "multiple", "muted", "name", "nohref", "novalidate", "nowrap", "onabort", "onafterprint", "onbeforeprint", "onbeforeunload", "onblur", "oncanplay", "oncanplaythrough", "onchange", "onclick", "oncontextmenu", "oncuechange", "ondblclick", "ondrag", "ondragend", "ondragenter", "ondragleave", "ondragover", "ondragstart", "ondrop", "ondurationchange", "onemptied", "onended", "onerror", "onfocus", "onformchange", "onforminput", "onhaschange", "oninput", "oninvalid", "onkeydown", "onkeypress", "onkeyup", "onload", "onloadeddata", "onloadedmetadata", "onloadstart", "onmessage", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onmousewheel", "onoffline", "ononline", "onpagehide", "onpageshow", "onpause", "onplay", "onplaying", "onpopstate", "onprogress", "onratechange", "onredo", "onreset", "onresize", "onscroll", "onseeked", "onseeking", "onselect", "onstalled", "onstorage", "onsubmit", "onsuspend", "ontimeupdate", "onundo", "onunload", "onvolumechange", "onwaiting", "open", "optimum", "pattern", "placeholder", "poster", "preload", "profile", "pubdate", "radiogroup", "readonly", "rel", "required", "rev", "reversed", "rows", "rowspan", "rules", "scheme", "scope", "scoped", "seamless", "selected", "shape", "size", "span", "spellcheck", "src", "srclang", "standby", "style", "summary", "tabindex", "title", "translate", "type", "usemap", "valign", "value", "valuetype", "width", "xml:lang", "xml:space", "xmlns"));
        Collections.sort(htmlAttributeNameListAux);
        ALL_STANDARD_HTML_ATTRIBUTE_NAMES = Collections.unmodifiableSet(new LinkedHashSet<String>(htmlAttributeNameListAux));
        HashSet<String> htmlBooleanAttributeNameSetAux = new HashSet<String>(Arrays.asList("async", "autofocus", "autoplay", "checked", "controls", "declare", "default", "defer", "disabled", "formnovalidate", "hidden", "ismap", "loop", "multiple", "novalidate", "nowrap", "open", "pubdate", "readonly", "required", "reversed", "selected", "scoped", "seamless"));
        ALL_STANDARD_BOOLEAN_HTML_ATTRIBUTE_NAMES = Collections.unmodifiableSet(new LinkedHashSet<String>(htmlBooleanAttributeNameSetAux));
    }

    static final class AttributeDefinitionRepository {
        private final TemplateMode templateMode;
        private final Map<TemplateMode, Set<IElementProcessor>> elementProcessorsByTemplateMode;
        private final List<String> standardRepositoryNames;
        private final List<AttributeDefinition> standardRepository;
        private final List<String> repositoryNames;
        private final List<AttributeDefinition> repository;
        private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
        private final Lock readLock = this.lock.readLock();
        private final Lock writeLock = this.lock.writeLock();

        AttributeDefinitionRepository(TemplateMode templateMode, Map<TemplateMode, Set<IElementProcessor>> elementProcessorsByTemplateMode) {
            this.templateMode = templateMode;
            this.elementProcessorsByTemplateMode = elementProcessorsByTemplateMode;
            this.standardRepositoryNames = templateMode == TemplateMode.HTML ? new ArrayList(150) : null;
            this.standardRepository = templateMode == TemplateMode.HTML ? new ArrayList(150) : null;
            this.repositoryNames = new ArrayList<String>(500);
            this.repository = new ArrayList<AttributeDefinition>(500);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AttributeDefinition getAttribute(char[] text, int offset, int len) {
            int index;
            if (this.standardRepository != null && (index = AttributeDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.standardRepositoryNames, text, offset, len)) >= 0) {
                return this.standardRepository.get(index);
            }
            this.readLock.lock();
            try {
                index = AttributeDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, text, offset, len);
                if (index >= 0) {
                    AttributeDefinition attributeDefinition = this.repository.get(index);
                    return attributeDefinition;
                }
            }
            finally {
                this.readLock.unlock();
            }
            this.writeLock.lock();
            try {
                AttributeDefinition attributeDefinition = this.storeAttribute(text, offset, len);
                return attributeDefinition;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AttributeDefinition getAttribute(String completeAttributeName) {
            int index;
            if (this.standardRepository != null && (index = AttributeDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.standardRepositoryNames, completeAttributeName)) >= 0) {
                return this.standardRepository.get(index);
            }
            this.readLock.lock();
            try {
                index = AttributeDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeAttributeName);
                if (index >= 0) {
                    AttributeDefinition attributeDefinition = this.repository.get(index);
                    return attributeDefinition;
                }
            }
            finally {
                this.readLock.unlock();
            }
            this.writeLock.lock();
            try {
                AttributeDefinition attributeDefinition = this.storeAttribute(completeAttributeName);
                return attributeDefinition;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AttributeDefinition getAttribute(String prefix, String attributeName) {
            int index;
            if (this.standardRepository != null && (index = AttributeDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.standardRepositoryNames, prefix, attributeName)) >= 0) {
                return this.standardRepository.get(index);
            }
            this.readLock.lock();
            try {
                index = AttributeDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, prefix, attributeName);
                if (index >= 0) {
                    AttributeDefinition attributeDefinition = this.repository.get(index);
                    return attributeDefinition;
                }
            }
            finally {
                this.readLock.unlock();
            }
            this.writeLock.lock();
            try {
                AttributeDefinition attributeDefinition = this.storeAttribute(prefix, attributeName);
                return attributeDefinition;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        private AttributeDefinition storeAttribute(char[] text, int offset, int len) {
            String[] completeAttributeNames;
            int index = AttributeDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, text, offset, len);
            if (index >= 0) {
                return this.repository.get(index);
            }
            Set<IElementProcessor> elementProcessors = this.elementProcessorsByTemplateMode.get((Object)this.templateMode);
            AttributeDefinition attributeDefinition = this.templateMode == TemplateMode.HTML ? AttributeDefinitions.buildHTMLAttributeDefinition(AttributeNames.forHTMLName(text, offset, len), elementProcessors) : (this.templateMode == TemplateMode.XML ? AttributeDefinitions.buildXMLAttributeDefinition(AttributeNames.forXMLName(text, offset, len), elementProcessors) : AttributeDefinitions.buildTextAttributeDefinition(this.templateMode, AttributeNames.forTextName(text, offset, len), elementProcessors));
            for (String completeAttributeName : completeAttributeNames = attributeDefinition.attributeName.completeAttributeNames) {
                index = AttributeDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeAttributeName);
                this.repositoryNames.add((index + 1) * -1, completeAttributeName);
                this.repository.add((index + 1) * -1, attributeDefinition);
            }
            return attributeDefinition;
        }

        private AttributeDefinition storeAttribute(String attributeName) {
            String[] completeAttributeNames;
            int index = AttributeDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, attributeName);
            if (index >= 0) {
                return this.repository.get(index);
            }
            Set<IElementProcessor> elementProcessors = this.elementProcessorsByTemplateMode.get((Object)this.templateMode);
            AttributeDefinition attributeDefinition = this.templateMode == TemplateMode.HTML ? AttributeDefinitions.buildHTMLAttributeDefinition(AttributeNames.forHTMLName(attributeName), elementProcessors) : (this.templateMode == TemplateMode.XML ? AttributeDefinitions.buildXMLAttributeDefinition(AttributeNames.forXMLName(attributeName), elementProcessors) : AttributeDefinitions.buildTextAttributeDefinition(this.templateMode, AttributeNames.forTextName(attributeName), elementProcessors));
            for (String completeAttributeName : completeAttributeNames = attributeDefinition.attributeName.completeAttributeNames) {
                index = AttributeDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeAttributeName);
                this.repositoryNames.add((index + 1) * -1, completeAttributeName);
                this.repository.add((index + 1) * -1, attributeDefinition);
            }
            return attributeDefinition;
        }

        private AttributeDefinition storeAttribute(String prefix, String attributeName) {
            String[] completeAttributeNames;
            int index = AttributeDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, prefix, attributeName);
            if (index >= 0) {
                return this.repository.get(index);
            }
            Set<IElementProcessor> elementProcessors = this.elementProcessorsByTemplateMode.get((Object)this.templateMode);
            AttributeDefinition attributeDefinition = this.templateMode == TemplateMode.HTML ? AttributeDefinitions.buildHTMLAttributeDefinition(AttributeNames.forHTMLName(prefix, attributeName), elementProcessors) : (this.templateMode == TemplateMode.XML ? AttributeDefinitions.buildXMLAttributeDefinition(AttributeNames.forXMLName(prefix, attributeName), elementProcessors) : AttributeDefinitions.buildTextAttributeDefinition(this.templateMode, AttributeNames.forTextName(prefix, attributeName), elementProcessors));
            for (String completeAttributeName : completeAttributeNames = attributeDefinition.attributeName.completeAttributeNames) {
                index = AttributeDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeAttributeName);
                this.repositoryNames.add((index + 1) * -1, completeAttributeName);
                this.repository.add((index + 1) * -1, attributeDefinition);
            }
            return attributeDefinition;
        }

        private AttributeDefinition storeStandardAttribute(AttributeDefinition attributeDefinition) {
            String[] completeAttributeNames;
            for (String completeAttributeName : completeAttributeNames = attributeDefinition.attributeName.completeAttributeNames) {
                int index = AttributeDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.standardRepositoryNames, completeAttributeName);
                this.standardRepositoryNames.add((index + 1) * -1, completeAttributeName);
                this.standardRepository.add((index + 1) * -1, attributeDefinition);
                index = AttributeDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeAttributeName);
                this.repositoryNames.add((index + 1) * -1, completeAttributeName);
                this.repository.add((index + 1) * -1, attributeDefinition);
            }
            return attributeDefinition;
        }

        private static int binarySearch(boolean caseSensitive, List<String> values, char[] text, int offset, int len) {
            int low = 0;
            int high = values.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                String midVal = values.get(mid);
                int cmp = TextUtils.compareTo(caseSensitive, (CharSequence)midVal, 0, midVal.length(), text, offset, len);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        private static int binarySearch(boolean caseSensitive, List<String> values, String text) {
            int low = 0;
            int high = values.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                String midVal = values.get(mid);
                int cmp = TextUtils.compareTo(caseSensitive, (CharSequence)midVal, text);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        private static int binarySearch(boolean caseSensitive, List<String> values, String prefix, String attributeName) {
            if (prefix == null || prefix.trim().length() == 0) {
                return AttributeDefinitionRepository.binarySearch(caseSensitive, values, attributeName);
            }
            int prefixLen = prefix.length();
            int attributeNameLen = attributeName.length();
            int low = 0;
            int high = values.size() - 1;
            while (low <= high) {
                int cmp;
                int mid = low + high >>> 1;
                String midVal = values.get(mid);
                int midValLen = midVal.length();
                if (TextUtils.startsWith(caseSensitive, (CharSequence)midVal, prefix)) {
                    if (midValLen <= prefixLen) {
                        low = mid + 1;
                        continue;
                    }
                    cmp = midVal.charAt(prefixLen) - 58;
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    cmp = TextUtils.compareTo(caseSensitive, (CharSequence)midVal, prefixLen + 1, midValLen - (prefixLen + 1), attributeName, 0, attributeNameLen);
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    return mid;
                }
                cmp = TextUtils.compareTo(caseSensitive, (CharSequence)midVal, prefix);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                throw new IllegalStateException("Bad comparison of midVal \"" + midVal + "\" and prefix \"" + prefix + "\"");
            }
            return -(low + 1);
        }
    }
}

