/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.processinginstruction;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IProcessingInstruction;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.processinginstruction.IProcessingInstructionProcessor;
import org.thymeleaf.processor.processinginstruction.IProcessingInstructionStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractProcessingInstructionProcessor
extends AbstractProcessor
implements IProcessingInstructionProcessor {
    public AbstractProcessingInstructionProcessor(TemplateMode templateMode, int precedence) {
        super(templateMode, precedence);
    }

    @Override
    public final void process(ITemplateContext context, IProcessingInstruction processingInstruction, IProcessingInstructionStructureHandler structureHandler) {
        try {
            this.doProcess(context, processingInstruction, structureHandler);
        }
        catch (TemplateProcessingException e) {
            if (processingInstruction.hasLocation()) {
                if (!e.hasTemplateName()) {
                    e.setTemplateName(processingInstruction.getTemplateName());
                }
                if (!e.hasLineAndCol()) {
                    e.setLineAndCol(processingInstruction.getLine(), processingInstruction.getCol());
                }
            }
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", processingInstruction.getTemplateName(), processingInstruction.getLine(), processingInstruction.getCol(), e);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, IProcessingInstruction var2, IProcessingInstructionStructureHandler var3);
}

