/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.realtime.redis.client.impl;

import io.lettuce.core.RedisFuture;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.codec.RedisCodec;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.warehouse.store.realtime.redis.RedisProperties;
import org.apache.hertzbeat.warehouse.store.realtime.redis.client.RedisClientOperation;

public class RedisClusterClientImpl
implements RedisClientOperation<String, CollectRep.MetricsData> {
    private RedisClusterClient redisClusterClient;
    private StatefulRedisClusterConnection<String, CollectRep.MetricsData> connection;

    @Override
    public RedisClientOperation<String, CollectRep.MetricsData> connect(RedisProperties redisProperties, RedisCodec<String, CollectRep.MetricsData> redisCodec) {
        String[] clusterAddress = redisProperties.address().split(",");
        HashSet<RedisURI> clusterUri = new HashSet<RedisURI>();
        for (String address : clusterAddress) {
            String[] split = address.split(":");
            RedisURI.Builder uriBuilder = RedisURI.builder().withHost(split[0]).withPort(Integer.parseInt(split[1])).withTimeout(Duration.of(10L, ChronoUnit.SECONDS));
            if (StringUtils.isNotBlank((CharSequence)redisProperties.password())) {
                uriBuilder.withPassword(redisProperties.password().toCharArray());
            }
            clusterUri.add(uriBuilder.build());
        }
        this.redisClusterClient = RedisClusterClient.create(clusterUri);
        this.connection = this.redisClusterClient.connect(redisCodec);
        return this;
    }

    @Override
    public CollectRep.MetricsData hget(String key, String field) {
        return (CollectRep.MetricsData)this.connection.sync().hget((Object)key, (Object)field);
    }

    @Override
    public Map<String, CollectRep.MetricsData> hgetAll(String key) {
        return this.connection.sync().hgetall((Object)key);
    }

    @Override
    public void hset(String key, String field, CollectRep.MetricsData value, Consumer<RedisFuture<Boolean>> redisFutureConsumer) {
        RedisFuture redisFuture = this.connection.async().hset((Object)key, (Object)field, (Object)value);
        if (Objects.nonNull(redisFutureConsumer)) {
            redisFutureConsumer.accept((RedisFuture<Boolean>)redisFuture);
        }
    }

    @Override
    public void close() throws Exception {
        if (Objects.nonNull(this.connection)) {
            this.connection.close();
        }
        if (Objects.nonNull(this.redisClusterClient)) {
            this.redisClusterClient.close();
        }
    }
}

