/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.signal;

import com.codahale.metrics.MetricRegistry;
import io.greptime.common.SPI;
import io.greptime.common.signal.FileOutputHelper;
import io.greptime.common.signal.FileSignalHelper;
import io.greptime.common.signal.SignalHandler;
import io.greptime.common.util.Files;
import io.greptime.common.util.MetricReporter;
import io.greptime.common.util.MetricsUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SPI(priority=97)
public class MetricsSignalHandler
implements SignalHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsSignalHandler.class);
    private static final String BASE_NAME = "greptimedb_client_metrics.log";

    public void handle(String signalName) {
        if (FileSignalHelper.ignoreFileOutputSignal()) {
            return;
        }
        try {
            File file = FileOutputHelper.getOutputFile((String)BASE_NAME);
            LOG.info("Printing GreptimeDB clients metrics triggered by signal: {} to file: {}.", (Object)signalName, (Object)file.getAbsoluteFile());
            try (PrintStream out = new PrintStream(new FileOutputStream(file, true));){
                MetricReporter reporter = MetricReporter.forRegistry((MetricRegistry)MetricsUtil.metricRegistry()).outputTo(out).prefixedWith("-- GreptimeDB").build();
                reporter.report();
                out.flush();
            }
            Files.fsync((File)file);
        }
        catch (IOException e) {
            LOG.error("Fail to print GreptimeDB client metrics.", (Throwable)e);
        }
    }
}

