/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.schemahistory;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationPattern;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.CommandResultFactory;
import org.flywaydb.core.api.output.RepairResult;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.extensibility.AppliedMigration;
import org.flywaydb.core.extensibility.MigrationType;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.ExecutionTemplateFactory;
import org.flywaydb.core.internal.jdbc.JdbcNullTypes;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.schemahistory.BaseAppliedMigration;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;
import org.flywaydb.core.internal.util.Pair;

class JdbcTableSchemaHistory
extends SchemaHistory {
    private static final Log LOG = LogFactory.getLog(JdbcTableSchemaHistory.class);
    private final SqlScriptExecutorFactory sqlScriptExecutorFactory;
    private final SqlScriptFactory sqlScriptFactory;
    private final Database database;
    private final Connection<?> connection;
    private final JdbcTemplate jdbcTemplate;
    private final LinkedList<AppliedMigration> cache = new LinkedList();
    private final Configuration configuration;

    JdbcTableSchemaHistory(SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, Database database, Table table, Configuration configuration) {
        this.sqlScriptExecutorFactory = sqlScriptExecutorFactory;
        this.sqlScriptFactory = sqlScriptFactory;
        this.table = table;
        this.database = database;
        this.connection = database.getMainConnection();
        this.jdbcTemplate = this.connection.getJdbcTemplate();
        this.configuration = configuration;
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public boolean exists() {
        this.connection.restoreOriginalState();
        return this.table.exists();
    }

    @Override
    public void create(final boolean baseline) {
        this.connection.lock(this.table, new Callable<Object>(){

            @Override
            public Object call() {
                int retries = 0;
                while (!JdbcTableSchemaHistory.this.exists()) {
                    if (retries == 0) {
                        LOG.info("Creating Schema History table " + JdbcTableSchemaHistory.this.table + (baseline ? " with baseline" : "") + " ...");
                    }
                    try {
                        ExecutionTemplateFactory.createExecutionTemplate(JdbcTableSchemaHistory.this.connection.getJdbcConnection(), JdbcTableSchemaHistory.this.database).execute(new Callable<Object>(){

                            @Override
                            public Object call() {
                                JdbcTableSchemaHistory.this.sqlScriptExecutorFactory.createSqlScriptExecutor(JdbcTableSchemaHistory.this.connection.getJdbcConnection(), false, false, true).execute(JdbcTableSchemaHistory.this.database.getCreateScript(JdbcTableSchemaHistory.this.sqlScriptFactory, JdbcTableSchemaHistory.this.table, baseline), JdbcTableSchemaHistory.this.database.getConfiguration());
                                LOG.debug("Created Schema History table " + JdbcTableSchemaHistory.this.table + (baseline ? " with baseline" : ""));
                                return null;
                            }
                        });
                    }
                    catch (FlywayException e) {
                        if (++retries >= 10) {
                            throw e;
                        }
                        try {
                            LOG.debug("Schema History table creation failed. Retrying in 1 sec ...");
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                return null;
            }
        });
    }

    @Override
    public <T> T lock(Callable<T> callable) {
        this.connection.restoreOriginalState();
        return this.connection.lock(this.table, callable);
    }

    @Override
    protected void doAddAppliedMigration(int installedRank, MigrationVersion version, String description, MigrationType type, String script, Integer checksum, int executionTime, boolean success) {
        boolean tableIsLocked = false;
        this.connection.restoreOriginalState();
        if (!this.database.supportsDdlTransactions()) {
            this.table.lock();
            tableIsLocked = true;
        }
        try {
            String versionStr;
            String string = versionStr = version == null ? null : version.toString();
            if (!this.database.supportsEmptyMigrationDescription() && "".equals(description)) {
                description = "<< no description >>";
            }
            Object versionObj = versionStr == null ? JdbcNullTypes.StringNull : versionStr;
            Object checksumObj = checksum == null ? JdbcNullTypes.IntegerNull : checksum;
            this.jdbcTemplate.update(this.database.getInsertStatement(this.table), installedRank, versionObj, description, type.name(), script, checksumObj, this.database.getInstalledBy(), executionTime, success);
            LOG.debug("Schema History table " + this.table + " successfully updated to reflect changes");
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to insert row for version '" + version + "' in Schema History table " + this.table, e);
        }
        finally {
            if (tableIsLocked) {
                this.table.unlock();
            }
        }
    }

    @Override
    public List<AppliedMigration> allAppliedMigrations() {
        if (!this.exists()) {
            LOG.info(String.format("Schema history table %s does not exist yet", this.table.toString()));
            return new ArrayList<AppliedMigration>();
        }
        this.refreshCache();
        return this.cache;
    }

    private void refreshCache() {
        int maxCachedInstalledRank = this.cache.isEmpty() ? -1 : this.cache.getLast().getInstalledRank();
        String query = this.database.getSelectStatement(this.table);
        try {
            this.cache.addAll(this.jdbcTemplate.query(query, rs -> {
                HashMap<String, Integer> columnOrdinalMap = this.constructColumnOrdinalMap(rs);
                Integer checksum = null;
                try {
                    checksum = rs.getInt(columnOrdinalMap.get("checksum"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (rs.wasNull()) {
                    checksum = null;
                }
                int installedRank = rs.getInt(columnOrdinalMap.get("installed_rank"));
                MigrationVersion version = rs.getString(columnOrdinalMap.get("version")) != null ? MigrationVersion.fromVersion(rs.getString(columnOrdinalMap.get("version"))) : null;
                String description = rs.getString(columnOrdinalMap.get("description"));
                String type = rs.getString(columnOrdinalMap.get("type"));
                String script = rs.getString(columnOrdinalMap.get("script"));
                String installedBy = rs.getString(columnOrdinalMap.get("installed_by"));
                int executionTime = rs.getInt(columnOrdinalMap.get("execution_time"));
                boolean success = rs.getBoolean(columnOrdinalMap.get("success"));
                Timestamp installedOn = rs.getTimestamp(columnOrdinalMap.get("installed_on"));
                if (installedOn == null) {
                    installedOn = Timestamp.valueOf(rs.getString(columnOrdinalMap.get("installed_on")));
                }
                return this.configuration.getPluginRegister().getPlugins(AppliedMigration.class).stream().filter(am -> am.handlesType(type)).findFirst().orElse(new BaseAppliedMigration()).create(installedRank, version, description, type, script, checksum, installedOn, installedBy, executionTime, success);
            }, maxCachedInstalledRank));
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error while retrieving the list of applied migrations from Schema History table " + this.table, e);
        }
    }

    private HashMap<String, Integer> constructColumnOrdinalMap(ResultSet rs) throws SQLException {
        HashMap<String, Integer> columnOrdinalMap = new HashMap<String, Integer>();
        ResultSetMetaData metadata = rs.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String columnNameLower = metadata.getColumnName(i).toLowerCase();
            columnOrdinalMap.put(columnNameLower, i);
        }
        return columnOrdinalMap;
    }

    @Override
    public boolean removeFailedMigrations(RepairResult repairResult, MigrationPattern[] migrationPatternFilter) {
        if (!this.exists()) {
            LOG.info("Repair of failed migration in Schema History table " + this.table + " not necessary as table doesn't exist.");
            return false;
        }
        List<AppliedMigration> appliedMigrations = this.filterMigrations(this.allAppliedMigrations(), migrationPatternFilter);
        boolean failed = appliedMigrations.stream().anyMatch(am -> !am.isSuccess());
        if (!failed) {
            LOG.info("Repair of failed migration in Schema History table " + this.table + " not necessary. No failed migration detected.");
            return false;
        }
        try {
            appliedMigrations.stream().filter(am -> !am.isSuccess()).forEach(am -> repairResult.migrationsRemoved.add(CommandResultFactory.createRepairOutput(am)));
            for (AppliedMigration appliedMigration : appliedMigrations) {
                Pair<String, Object> deleteStatement = appliedMigration.getVersion() != null ? this.database.getDeleteStatement(this.table, true, appliedMigration.getVersion().getVersion()) : this.database.getDeleteStatement(this.table, false, appliedMigration.getDescription());
                if (deleteStatement == null) continue;
                this.jdbcTemplate.execute(deleteStatement.getLeft(), deleteStatement.getRight());
            }
            this.clearCache();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to repair Schema History table " + this.table, e);
        }
        return true;
    }

    private List<AppliedMigration> filterMigrations(List<AppliedMigration> appliedMigrations, MigrationPattern[] migrationPatternFilter) {
        if (migrationPatternFilter == null) {
            return appliedMigrations;
        }
        HashSet<AppliedMigration> filteredList = new HashSet<AppliedMigration>();
        for (AppliedMigration appliedMigration : appliedMigrations) {
            for (MigrationPattern migrationPattern : migrationPatternFilter) {
                if (!migrationPattern.matches(appliedMigration.getVersion(), appliedMigration.getDescription())) continue;
                filteredList.add(appliedMigration);
            }
        }
        return new ArrayList<AppliedMigration>(filteredList);
    }

    @Override
    public void update(AppliedMigration appliedMigration, ResolvedMigration resolvedMigration) {
        this.connection.restoreOriginalState();
        this.clearCache();
        MigrationVersion version = appliedMigration.getVersion();
        String description = resolvedMigration.getDescription();
        Integer checksum = resolvedMigration.getChecksum();
        MigrationType type = appliedMigration.getType().isSynthetic() ? appliedMigration.getType() : resolvedMigration.getType();
        LOG.info("Repairing Schema History table for version " + version + " (Description: " + description + ", Type: " + type + ", Checksum: " + checksum + ")  ...");
        if (!this.database.supportsEmptyMigrationDescription() && "".equals(description)) {
            description = "<< no description >>";
        }
        Object checksumObj = checksum == null ? JdbcNullTypes.IntegerNull : checksum;
        try {
            this.jdbcTemplate.update(this.database.getUpdateStatement(this.table), description, type.name(), checksumObj, appliedMigration.getInstalledRank());
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to repair Schema History table " + this.table + " for version " + version, e);
        }
    }

    @Override
    public void delete(AppliedMigration appliedMigration) {
        String versionStr;
        this.connection.restoreOriginalState();
        this.clearCache();
        MigrationVersion version = appliedMigration.getVersion();
        String string = versionStr = version == null ? null : version.toString();
        if (version == null) {
            LOG.info("Repairing Schema History table for description \"" + appliedMigration.getDescription() + "\" (Marking as DELETED)  ...");
        } else {
            LOG.info("Repairing Schema History table for version \"" + version + "\" (Marking as DELETED)  ...");
        }
        Object versionObj = versionStr == null ? JdbcNullTypes.StringNull : versionStr;
        Object checksumObj = appliedMigration.getChecksum() == null ? JdbcNullTypes.IntegerNull : appliedMigration.getChecksum();
        try {
            this.jdbcTemplate.update(this.database.getInsertStatement(this.table), this.calculateInstalledRank(appliedMigration.getType()), versionObj, appliedMigration.getDescription(), "DELETE", appliedMigration.getScript(), checksumObj, this.database.getInstalledBy(), 0, appliedMigration.isSuccess());
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to repair Schema History table " + this.table + " for version " + version, e);
        }
    }
}

