/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.ai;

import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.apache.hertzbeat.common.constants.AiConstants;
import org.apache.hertzbeat.common.constants.AiTypeEnum;
import org.apache.hertzbeat.manager.config.AiProperties;
import org.apache.hertzbeat.manager.pojo.dto.AiMessage;
import org.apache.hertzbeat.manager.pojo.dto.AliAiRequestParamDTO;
import org.apache.hertzbeat.manager.pojo.dto.AliAiResponse;
import org.apache.hertzbeat.manager.service.ai.AiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

@Service(value="AlibabaAiServiceImpl")
@ConditionalOnProperty(prefix="ai", name={"type"}, havingValue="alibabaAi")
public class AlibabaAiServiceImpl
implements AiService {
    private static final Logger log = LoggerFactory.getLogger(AlibabaAiServiceImpl.class);
    @Autowired
    private AiProperties aiProperties;
    private WebClient webClient;

    @PostConstruct
    private void init() {
        this.webClient = WebClient.builder().baseUrl("https://dashscope.aliyuncs.com/api/v1/services/aigc/text-generation/generation").defaultHeader("Content-Type", new String[]{"application/json"}).defaultHeader("Authorization", new String[]{"Bearer " + this.aiProperties.getApiKey()}).defaultHeader("Accept", new String[]{"text/event-stream"}).exchangeStrategies(ExchangeStrategies.builder().codecs(item -> item.defaultCodecs().maxInMemorySize(0x1000000)).build()).build();
    }

    @Override
    public AiTypeEnum getType() {
        return AiTypeEnum.alibabaAi;
    }

    @Override
    public Flux<ServerSentEvent<String>> requestAi(String text) {
        this.checkParam(text, this.aiProperties.getModel(), this.aiProperties.getApiKey());
        AliAiRequestParamDTO aliAiRequestParamDTO = AliAiRequestParamDTO.builder().model(this.aiProperties.getModel()).input(AliAiRequestParamDTO.Input.builder().messages(List.of(new AiMessage("user", text))).build()).parameters(AliAiRequestParamDTO.Parameters.builder().maxTokens(AiConstants.AliAiConstants.MAX_TOKENS).temperature(0.7f).enableSearch(true).resultFormat("message").incrementalOutput(true).build()).build();
        return this.webClient.post().body(BodyInserters.fromValue((Object)aliAiRequestParamDTO)).retrieve().bodyToFlux(AliAiResponse.class).map(aliAiResponse -> {
            if (Objects.nonNull(aliAiResponse)) {
                List<AliAiResponse.Choice> choices = aliAiResponse.getOutput().getChoices();
                if (CollectionUtils.isEmpty(choices)) {
                    return ServerSentEvent.builder().build();
                }
                String content = choices.get(0).getMessage().getContent();
                return ServerSentEvent.builder().data((Object)content).build();
            }
            return ServerSentEvent.builder().build();
        }).doOnError(error -> log.info("AlibabaAiServiceImpl.requestAi exception:{}", (Object)error.getMessage()));
    }

    private void checkParam(String param, String apiKey, String model) {
        Assert.notNull((Object)param, (String)"text is null");
        Assert.notNull((Object)model, (String)"model is null");
        Assert.notNull((Object)apiKey, (String)"ai.api-key is null");
    }
}

