/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.tool;

import java.util.function.Function;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.util.Assert;

public interface ToolExecutionEligibilityChecker
extends Function<ChatResponse, Boolean> {
    default public boolean isToolExecutionRequired(ChatOptions promptOptions, ChatResponse chatResponse) {
        Assert.notNull((Object)promptOptions, (String)"promptOptions cannot be null");
        Assert.notNull((Object)chatResponse, (String)"chatResponse cannot be null");
        return this.isInternalToolExecutionEnabled(promptOptions) && this.isToolCallResponse(chatResponse);
    }

    default public boolean isToolCallResponse(ChatResponse chatResponse) {
        Assert.notNull((Object)chatResponse, (String)"chatResponse cannot be null");
        return (Boolean)this.apply(chatResponse);
    }

    default public boolean isInternalToolExecutionEnabled(ChatOptions chatOptions) {
        ToolCallingChatOptions toolCallingChatOptions;
        Assert.notNull((Object)chatOptions, (String)"chatOptions cannot be null");
        boolean internalToolExecutionEnabled = chatOptions instanceof ToolCallingChatOptions && (toolCallingChatOptions = (ToolCallingChatOptions)chatOptions).getInternalToolExecutionEnabled() != null ? Boolean.TRUE.equals(toolCallingChatOptions.getInternalToolExecutionEnabled()) : true;
        return internalToolExecutionEnabled;
    }
}

