/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.alert.dao.NoticeReceiverDao;
import org.apache.hertzbeat.alert.dao.NoticeRuleDao;
import org.apache.hertzbeat.alert.dao.NoticeTemplateDao;
import org.apache.hertzbeat.alert.notice.AlertNoticeDispatch;
import org.apache.hertzbeat.alert.service.NoticeConfigService;
import org.apache.hertzbeat.common.cache.CacheFactory;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.NoticeReceiver;
import org.apache.hertzbeat.common.entity.alerter.NoticeRule;
import org.apache.hertzbeat.common.entity.alerter.NoticeTemplate;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Order(value=-2147483648)
@Transactional(rollbackFor={Exception.class})
public class NoticeConfigServiceImpl
implements NoticeConfigService,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(NoticeConfigServiceImpl.class);
    private static final Map<Byte, NoticeTemplate> PRESET_TEMPLATE = new HashMap<Byte, NoticeTemplate>(16);
    @Autowired
    private NoticeReceiverDao noticeReceiverDao;
    @Autowired
    private NoticeRuleDao noticeRuleDao;
    @Autowired
    private NoticeTemplateDao noticeTemplateDao;
    @Autowired
    @Lazy
    private AlertNoticeDispatch dispatcherAlarm;

    @Override
    public Page<NoticeReceiver> getNoticeReceivers(String name, int pageIndex, int pageSize) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Predicate predicate = criteriaBuilder.conjunction();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                Predicate predicateName = criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("name")), "%" + name.toLowerCase() + "%");
                predicate = criteriaBuilder.and(new Predicate[]{predicateName});
            }
            return predicate;
        };
        return this.noticeReceiverDao.findAll(specification, (Pageable)PageRequest.of((int)pageIndex, (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"})));
    }

    @Override
    public List<NoticeReceiver> getAllNoticeReceivers() {
        return this.noticeReceiverDao.findAll();
    }

    @Override
    public Page<NoticeTemplate> getNoticeTemplates(String name, boolean preset, int pageIndex, int pageSize) {
        if (preset) {
            LinkedList<NoticeTemplate> defaultTemplates = new LinkedList<NoticeTemplate>(PRESET_TEMPLATE.values());
            List filteredDefaultTemplates = defaultTemplates.stream().filter(template -> StringUtils.isBlank((CharSequence)name) || template.getName().toLowerCase().contains(name.toLowerCase())).collect(Collectors.toList());
            int totalItems = filteredDefaultTemplates.size();
            int fromIndex = Math.min(pageIndex * pageSize, totalItems);
            int toIndex = Math.min(fromIndex + pageSize, totalItems);
            if (fromIndex >= totalItems) {
                return new PageImpl(Collections.emptyList(), (Pageable)PageRequest.of((int)pageIndex, (int)pageSize), (long)totalItems);
            }
            List paginatedTemplates = filteredDefaultTemplates.subList(fromIndex, toIndex);
            return new PageImpl(paginatedTemplates, (Pageable)PageRequest.of((int)pageIndex, (int)pageSize), (long)totalItems);
        }
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Predicate predicate = criteriaBuilder.conjunction();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                Predicate predicateName = criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("name")), "%" + name.toLowerCase() + "%");
                predicate = criteriaBuilder.and(new Predicate[]{predicateName});
            }
            return predicate;
        };
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        return this.noticeTemplateDao.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public List<NoticeTemplate> getAllNoticeTemplates() {
        LinkedList<NoticeTemplate> defaultTemplates = new LinkedList<NoticeTemplate>(PRESET_TEMPLATE.values());
        defaultTemplates.addAll(this.noticeTemplateDao.findAll());
        return defaultTemplates;
    }

    @Override
    public Page<NoticeRule> getNoticeRules(String name, int pageIndex, int pageSize) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Predicate predicate = criteriaBuilder.conjunction();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                Predicate predicateName = criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("name")), "%" + name.toLowerCase() + "%");
                predicate = criteriaBuilder.and(new Predicate[]{predicateName});
            }
            return predicate;
        };
        return this.noticeRuleDao.findAll(specification, (Pageable)PageRequest.of((int)pageIndex, (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"})));
    }

    @Override
    public void addReceiver(NoticeReceiver noticeReceiver) {
        this.noticeReceiverDao.save(noticeReceiver);
    }

    @Override
    public void editReceiver(NoticeReceiver noticeReceiver) {
        this.noticeReceiverDao.save(noticeReceiver);
    }

    @Override
    public void deleteReceiver(Long receiverId) {
        this.noticeReceiverDao.deleteById(receiverId);
    }

    @Override
    public void addNoticeRule(NoticeRule noticeRule) {
        this.noticeRuleDao.save(noticeRule);
        this.clearNoticeRulesCache();
    }

    @Override
    public void editNoticeRule(NoticeRule noticeRule) {
        this.noticeRuleDao.save(noticeRule);
        this.clearNoticeRulesCache();
    }

    @Override
    public void deleteNoticeRule(Long ruleId) {
        this.noticeRuleDao.deleteById(ruleId);
        this.clearNoticeRulesCache();
    }

    @Override
    public List<NoticeRule> getReceiverFilterRule(GroupAlert alert) {
        List<NoticeRule> rules = CacheFactory.getNoticeCache();
        if (rules == null) {
            rules = this.noticeRuleDao.findNoticeRulesByEnableTrue();
            CacheFactory.setNoticeCache(rules);
        }
        return rules.stream().filter(rule -> {
            boolean dayMatch;
            boolean labelMatch;
            if (!(rule.isFilterAll() || rule.getLabels() == null || rule.getLabels().isEmpty() || (labelMatch = rule.getLabels().entrySet().stream().allMatch(labelItem -> {
                if (!alert.getCommonLabels().containsKey(labelItem.getKey())) {
                    return false;
                }
                String alertLabelValue = (String)alert.getCommonLabels().get(labelItem.getKey());
                return Objects.equals(labelItem.getValue(), alertLabelValue);
            })))) {
                return false;
            }
            LocalDateTime nowDate = LocalDateTime.now();
            int currentDayOfWeek = nowDate.toLocalDate().getDayOfWeek().getValue();
            if (rule.getDays() != null && !rule.getDays().isEmpty() && !(dayMatch = rule.getDays().stream().anyMatch(item -> item == currentDayOfWeek))) {
                return false;
            }
            LocalTime nowTime = nowDate.toLocalTime();
            boolean startMatch = rule.getPeriodStart() == null || nowTime.isAfter(rule.getPeriodStart().toLocalTime()) || rule.getPeriodEnd() != null && rule.getPeriodStart().isAfter(rule.getPeriodEnd()) && nowTime.isBefore(rule.getPeriodStart().toLocalTime());
            boolean endMatch = rule.getPeriodEnd() == null || nowTime.isBefore(rule.getPeriodEnd().toLocalTime());
            return startMatch && endMatch;
        }).collect(Collectors.toList());
    }

    @Override
    public NoticeTemplate getOneTemplateById(Long id) {
        return this.noticeTemplateDao.findById(id).orElse(null);
    }

    @Override
    public NoticeReceiver getReceiverById(Long receiverId) {
        return this.noticeReceiverDao.findById(receiverId).orElse(null);
    }

    @Override
    public NoticeRule getNoticeRulesById(Long ruleId) {
        return this.noticeRuleDao.findById(ruleId).orElse(null);
    }

    @Override
    public void addNoticeTemplate(NoticeTemplate noticeTemplate) {
        this.noticeTemplateDao.save(noticeTemplate);
        this.clearNoticeRulesCache();
    }

    @Override
    public void editNoticeTemplate(NoticeTemplate noticeTemplate) {
        this.noticeTemplateDao.save(noticeTemplate);
        this.clearNoticeRulesCache();
    }

    @Override
    public void deleteNoticeTemplate(Long templateId) {
        this.noticeTemplateDao.deleteById(templateId);
        this.clearNoticeRulesCache();
    }

    @Override
    public Optional<NoticeTemplate> getNoticeTemplatesById(Long templateId) {
        return this.noticeTemplateDao.findById(templateId);
    }

    @Override
    public NoticeTemplate getDefaultNoticeTemplateByType(Byte type) {
        if (type == null) {
            return null;
        }
        return PRESET_TEMPLATE.get(type);
    }

    @Override
    public boolean sendTestMsg(NoticeReceiver noticeReceiver) {
        HashMap<String, String> labels = new HashMap<String, String>(8);
        labels.put("instance", "1000000");
        labels.put("alertname", "CPU Usage Alert");
        labels.put("instancehost", "127.0.0.1");
        HashMap<String, String> annotations = new HashMap<String, String>(8);
        annotations.put("suggest", "Please check the CPU usage of the server");
        SingleAlert singleAlert1 = SingleAlert.builder().labels(labels).content("test send msg! \\n This is the test data. It is proved that it can be received successfully").startAt(Long.valueOf(System.currentTimeMillis())).activeAt(Long.valueOf(System.currentTimeMillis())).endAt(Long.valueOf(System.currentTimeMillis())).triggerTimes(Integer.valueOf(2)).annotations(annotations).status("firing").build();
        SingleAlert singleAlert2 = SingleAlert.builder().labels(labels).content("test send msg! \\n This is the test data. It is proved that it can be received successfully").startAt(Long.valueOf(System.currentTimeMillis())).activeAt(Long.valueOf(System.currentTimeMillis())).endAt(Long.valueOf(System.currentTimeMillis())).triggerTimes(Integer.valueOf(4)).annotations(annotations).status("firing").build();
        GroupAlert groupAlert = GroupAlert.builder().commonLabels(Map.of("alertname", "CPU Usage Alert")).commonAnnotations(annotations).alerts(List.of(singleAlert1, singleAlert2)).status("firing").build();
        return this.dispatcherAlarm.sendNoticeMsg(noticeReceiver, null, groupAlert);
    }

    private void clearNoticeRulesCache() {
        CacheFactory.clearNoticeCache();
    }

    public void run(String ... args) throws Exception {
        try {
            Resource[] resources;
            log.info("load default notice template in internal jar");
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            for (Resource resource : resources = resolver.getResources("classpath:templates/*.*")) {
                if (resource.getFilename() == null || !resource.getFilename().endsWith("txt") && !resource.getFilename().endsWith("html")) {
                    log.warn("Ignore the template file {}.", (Object)resource.getFilename());
                    continue;
                }
                try (InputStream inputStream = resource.getInputStream();){
                    byte[] bytes = new byte[inputStream.available()];
                    inputStream.read(bytes);
                    String content = new String(bytes, StandardCharsets.UTF_8);
                    NoticeTemplate template = new NoticeTemplate();
                    String name = resource.getFilename().replace(".txt", "").replace(".html", "");
                    String[] names = name.split("-");
                    if (names.length != 2) {
                        log.warn("Ignore the template file {}.", (Object)resource.getFilename());
                        continue;
                    }
                    byte type = Byte.parseByte(names[0]);
                    name = names[1];
                    template.setName(name);
                    template.setType(Byte.valueOf(type));
                    template.setPreset(true);
                    template.setContent(content);
                    template.setGmtUpdate(LocalDateTime.now());
                    PRESET_TEMPLATE.put(template.getType(), template);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    log.error("Ignore this template file: {}.", (Object)resource.getFilename());
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

