/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties;

import io.opentelemetry.api.internal.ConfigUtil;
import io.opentelemetry.instrumentation.resources.ResourceProviderPropertiesCustomizer;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.OtelResourceProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.OtelSpringProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.OtlpExporterProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.core.env.Environment;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SpringConfigProperties
implements ConfigProperties {
    private final Environment environment;
    private final ExpressionParser parser;
    private final OtlpExporterProperties otlpExporterProperties;
    private final OtelResourceProperties resourceProperties;
    private final ConfigProperties otelSdkProperties;
    private final ConfigProperties customizedListProperties;
    private final Map<String, List<String>> listPropertyValues;
    static final String DISABLED_KEY = "otel.java.disabled.resource.providers";
    static final String ENABLED_KEY = "otel.java.enabled.resource.providers";

    public SpringConfigProperties(Environment environment, ExpressionParser parser, OtlpExporterProperties otlpExporterProperties, OtelResourceProperties resourceProperties, OtelSpringProperties otelSpringProperties, ConfigProperties otelSdkProperties) {
        this.environment = environment;
        this.parser = parser;
        this.otlpExporterProperties = otlpExporterProperties;
        this.resourceProperties = resourceProperties;
        this.otelSdkProperties = otelSdkProperties;
        this.customizedListProperties = SpringConfigProperties.createCustomizedListProperties(otelSdkProperties, otelSpringProperties);
        this.listPropertyValues = SpringConfigProperties.createListPropertyValues(otelSpringProperties);
    }

    private static Map<String, List<String>> createListPropertyValues(OtelSpringProperties otelSpringProperties) {
        HashMap<String, List<String>> values = new HashMap<String, List<String>>();
        values.put(ENABLED_KEY, otelSpringProperties.getJavaEnabledResourceProviders());
        values.put(DISABLED_KEY, otelSpringProperties.getJavaDisabledResourceProviders());
        values.put("otel.experimental.metrics.view.config", otelSpringProperties.getExperimentalMetricsViewConfig());
        values.put("otel.experimental.resource.disabled.keys", otelSpringProperties.getExperimentalResourceDisabledKeys());
        values.put("otel.propagators", otelSpringProperties.getPropagators());
        values.put("otel.logs.exporter", otelSpringProperties.getLogsExporter());
        values.put("otel.metrics.exporter", otelSpringProperties.getMetricsExporter());
        values.put("otel.traces.exporter", otelSpringProperties.getTracesExporter());
        values.put("otel.instrumentation.http.client.capture-request-headers", otelSpringProperties.getHttpClientCaptureRequestHeaders());
        values.put("otel.instrumentation.http.client.capture-response-headers", otelSpringProperties.getHttpClientCaptureResponseHeaders());
        values.put("otel.instrumentation.http.server.capture-request-headers", otelSpringProperties.getHttpServerCaptureRequestHeaders());
        values.put("otel.instrumentation.http.server.capture-response-headers", otelSpringProperties.getHttpServerCaptureResponseHeaders());
        values.put("otel.instrumentation.http.known-methods", otelSpringProperties.getHttpKnownMethods());
        return values;
    }

    private static Map<String, String> createMapForListProperty(String key, List<String> springList, ConfigProperties configProperties) {
        if (!springList.isEmpty()) {
            return Collections.singletonMap(key, String.join((CharSequence)",", springList));
        }
        String otelList = configProperties.getString(key);
        if (otelList != null) {
            return Collections.singletonMap(key, otelList);
        }
        return Collections.emptyMap();
    }

    private static ConfigProperties createCustomizedListProperties(ConfigProperties configProperties, OtelSpringProperties otelSpringProperties) {
        HashMap<String, String> map = new HashMap<String, String>(SpringConfigProperties.createMapForListProperty(ENABLED_KEY, otelSpringProperties.getJavaEnabledResourceProviders(), configProperties));
        map.putAll(SpringConfigProperties.createMapForListProperty(DISABLED_KEY, otelSpringProperties.getJavaDisabledResourceProviders(), configProperties));
        return DefaultConfigProperties.createFromMap((Map)new ResourceProviderPropertiesCustomizer().customize((ConfigProperties)DefaultConfigProperties.createFromMap(map)));
    }

    public static ConfigProperties create(Environment env, OtlpExporterProperties otlpExporterProperties, OtelResourceProperties resourceProperties, OtelSpringProperties otelSpringProperties, ConfigProperties fallback) {
        return new SpringConfigProperties(env, (ExpressionParser)new SpelExpressionParser(), otlpExporterProperties, resourceProperties, otelSpringProperties, fallback);
    }

    @Nullable
    public String getString(String name) {
        String normalizedName = ConfigUtil.normalizeEnvironmentVariableKey((String)name);
        String value = (String)this.environment.getProperty(normalizedName, String.class);
        if (value == null && normalizedName.equals("otel.exporter.otlp.protocol")) {
            return "http/protobuf";
        }
        return SpringConfigProperties.or(value, this.otelSdkProperties.getString(name));
    }

    @Nullable
    public Boolean getBoolean(String name) {
        return SpringConfigProperties.or((Boolean)this.environment.getProperty(ConfigUtil.normalizeEnvironmentVariableKey((String)name), Boolean.class), this.otelSdkProperties.getBoolean(name));
    }

    @Nullable
    public Integer getInt(String name) {
        return SpringConfigProperties.or((Integer)this.environment.getProperty(ConfigUtil.normalizeEnvironmentVariableKey((String)name), Integer.class), this.otelSdkProperties.getInt(name));
    }

    @Nullable
    public Long getLong(String name) {
        return SpringConfigProperties.or((Long)this.environment.getProperty(ConfigUtil.normalizeEnvironmentVariableKey((String)name), Long.class), this.otelSdkProperties.getLong(name));
    }

    @Nullable
    public Double getDouble(String name) {
        return SpringConfigProperties.or((Double)this.environment.getProperty(ConfigUtil.normalizeEnvironmentVariableKey((String)name), Double.class), this.otelSdkProperties.getDouble(name));
    }

    public List<String> getList(String name) {
        String normalizedName = ConfigUtil.normalizeEnvironmentVariableKey((String)name);
        List<String> list = this.listPropertyValues.get(normalizedName);
        if (list != null) {
            List c = this.customizedListProperties.getList(name);
            if (!c.isEmpty()) {
                return c;
            }
            if (!list.isEmpty()) {
                return list;
            }
        }
        return SpringConfigProperties.or((List)this.environment.getProperty(normalizedName, List.class), this.otelSdkProperties.getList(name));
    }

    @Nullable
    public Duration getDuration(String name) {
        String value = this.getString(name);
        if (value == null) {
            return this.otelSdkProperties.getDuration(name);
        }
        return DefaultConfigProperties.createFromMap(Collections.singletonMap(name, value)).getDuration(name);
    }

    public Map<String, String> getMap(String name) {
        String normalizedName;
        Map otelSdkMap = this.otelSdkProperties.getMap(name);
        switch (normalizedName = ConfigUtil.normalizeEnvironmentVariableKey((String)name)) {
            case "otel.resource.attributes": {
                return SpringConfigProperties.mergeWithOtel(this.resourceProperties.getAttributes(), otelSdkMap);
            }
            case "otel.exporter.otlp.headers": {
                return SpringConfigProperties.mergeWithOtel(this.otlpExporterProperties.getHeaders(), otelSdkMap);
            }
            case "otel.exporter.otlp.logs.headers": {
                return SpringConfigProperties.mergeWithOtel(this.otlpExporterProperties.getLogs().getHeaders(), otelSdkMap);
            }
            case "otel.exporter.otlp.metrics.headers": {
                return SpringConfigProperties.mergeWithOtel(this.otlpExporterProperties.getMetrics().getHeaders(), otelSdkMap);
            }
            case "otel.exporter.otlp.traces.headers": {
                return SpringConfigProperties.mergeWithOtel(this.otlpExporterProperties.getTraces().getHeaders(), otelSdkMap);
            }
        }
        String value = this.environment.getProperty(normalizedName);
        if (value == null) {
            return otelSdkMap;
        }
        return (Map)this.parser.parseExpression(value).getValue();
    }

    private static Map<String, String> mergeWithOtel(Map<String, String> springMap, Map<String, String> otelSdkMap) {
        HashMap<String, String> merged = new HashMap<String, String>(otelSdkMap);
        merged.putAll(springMap);
        return merged;
    }

    @Nullable
    private static <T> T or(@Nullable T first, @Nullable T second) {
        return first != null ? first : second;
    }
}

