/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.AbstractRepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class DefaultRepositoryMetadata
extends AbstractRepositoryMetadata {
    private static final String MUST_BE_A_REPOSITORY = String.format("Given type must be assignable to %s", Repository.class);
    private final TypeInformation<?> idType;
    private final TypeInformation<?> domainType;

    public DefaultRepositoryMetadata(Class<?> repositoryInterface) {
        super(repositoryInterface);
        Assert.isTrue((boolean)Repository.class.isAssignableFrom(repositoryInterface), (String)MUST_BE_A_REPOSITORY);
        List<TypeInformation<?>> arguments = TypeInformation.of(repositoryInterface).getRequiredSuperTypeInformation(Repository.class).getTypeArguments();
        this.domainType = DefaultRepositoryMetadata.resolveTypeParameter(arguments, 0, () -> String.format("Could not resolve domain type of %s", repositoryInterface));
        this.idType = DefaultRepositoryMetadata.resolveTypeParameter(arguments, 1, () -> String.format("Could not resolve id type of %s", repositoryInterface));
    }

    @Override
    public TypeInformation<?> getIdTypeInformation() {
        return this.idType;
    }

    @Override
    public TypeInformation<?> getDomainTypeInformation() {
        return this.domainType;
    }

    private static TypeInformation<?> resolveTypeParameter(List<TypeInformation<?>> arguments, int index, Supplier<String> exceptionMessage) {
        if (arguments.size() <= index || arguments.get(index) == null) {
            throw new IllegalArgumentException(exceptionMessage.get());
        }
        return arguments.get(index);
    }

    @Override
    public Set<RepositoryFragment<?>> getFragments() {
        return Collections.emptySet();
    }
}

