/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.api.incubator.config.DeclarativeConfigException;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.sdk.autoconfigure.internal.ComponentLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class YamlDeclarativeConfigProperties
implements DeclarativeConfigProperties {
    private static final Set<Class<?>> SUPPORTED_SCALAR_TYPES = Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(String.class, Boolean.class, Long.class, Double.class)));
    private final Map<String, Object> simpleEntries;
    private final Map<String, List<YamlDeclarativeConfigProperties>> listEntries;
    private final Map<String, YamlDeclarativeConfigProperties> mapEntries;
    private final ComponentLoader componentLoader;

    private YamlDeclarativeConfigProperties(Map<String, Object> simpleEntries, Map<String, List<YamlDeclarativeConfigProperties>> listEntries, Map<String, YamlDeclarativeConfigProperties> mapEntries, ComponentLoader componentLoader) {
        this.simpleEntries = simpleEntries;
        this.listEntries = listEntries;
        this.mapEntries = mapEntries;
        this.componentLoader = componentLoader;
    }

    static YamlDeclarativeConfigProperties create(Map<String, Object> properties, ComponentLoader componentLoader) {
        LinkedHashMap<String, Object> simpleEntries = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, List<YamlDeclarativeConfigProperties>> listEntries = new LinkedHashMap<String, List<YamlDeclarativeConfigProperties>>();
        LinkedHashMap<String, YamlDeclarativeConfigProperties> mapEntries = new LinkedHashMap<String, YamlDeclarativeConfigProperties>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (YamlDeclarativeConfigProperties.isPrimitive(value) || value == null) {
                simpleEntries.put(key, value);
                continue;
            }
            if (YamlDeclarativeConfigProperties.isPrimitiveList(value)) {
                simpleEntries.put(key, value);
                continue;
            }
            if (YamlDeclarativeConfigProperties.isListOfMaps(value)) {
                List list = ((List)value).stream().map(map -> YamlDeclarativeConfigProperties.create(map, componentLoader)).collect(Collectors.toList());
                listEntries.put(key, list);
                continue;
            }
            if (YamlDeclarativeConfigProperties.isMap(value)) {
                YamlDeclarativeConfigProperties configProperties = YamlDeclarativeConfigProperties.create((Map)value, componentLoader);
                mapEntries.put(key, configProperties);
                continue;
            }
            throw new DeclarativeConfigException("Unable to initialize ExtendedConfigProperties. Key \"" + key + "\" has unrecognized object type " + value.getClass().getName());
        }
        return new YamlDeclarativeConfigProperties(simpleEntries, listEntries, mapEntries, componentLoader);
    }

    private static boolean isPrimitiveList(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            return list.stream().allMatch(YamlDeclarativeConfigProperties::isPrimitive);
        }
        return false;
    }

    private static boolean isPrimitive(Object object) {
        return object instanceof String || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Boolean;
    }

    private static boolean isListOfMaps(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            return list.stream().allMatch(entry -> entry instanceof Map && ((Map)entry).keySet().stream().allMatch(key -> key instanceof String));
        }
        return false;
    }

    private static boolean isMap(Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            return map.keySet().stream().allMatch(entry -> entry instanceof String);
        }
        return false;
    }

    @Nullable
    public String getString(String name) {
        return YamlDeclarativeConfigProperties.stringOrNull(this.simpleEntries.get(name));
    }

    @Nullable
    public Boolean getBoolean(String name) {
        return YamlDeclarativeConfigProperties.booleanOrNull(this.simpleEntries.get(name));
    }

    @Nullable
    public Integer getInt(String name) {
        Object value = this.simpleEntries.get(name);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        return null;
    }

    @Nullable
    public Long getLong(String name) {
        return YamlDeclarativeConfigProperties.longOrNull(this.simpleEntries.get(name));
    }

    @Nullable
    public Double getDouble(String name) {
        return YamlDeclarativeConfigProperties.doubleOrNull(this.simpleEntries.get(name));
    }

    @Nullable
    public <T> List<T> getScalarList(String name, Class<T> scalarType) {
        if (!SUPPORTED_SCALAR_TYPES.contains(scalarType)) {
            throw new DeclarativeConfigException("Unsupported scalar type " + scalarType.getName() + ". Supported types include " + SUPPORTED_SCALAR_TYPES.stream().map(Class::getName).collect(Collectors.joining(",", "[", "]")));
        }
        Object value = this.simpleEntries.get(name);
        if (value instanceof List) {
            return ((List)value).stream().map(entry -> {
                if (scalarType == String.class) {
                    return YamlDeclarativeConfigProperties.stringOrNull(entry);
                }
                if (scalarType == Boolean.class) {
                    return YamlDeclarativeConfigProperties.booleanOrNull(entry);
                }
                if (scalarType == Long.class) {
                    return YamlDeclarativeConfigProperties.longOrNull(entry);
                }
                if (scalarType == Double.class) {
                    return YamlDeclarativeConfigProperties.doubleOrNull(entry);
                }
                return null;
            }).filter(x$0 -> Objects.nonNull(x$0)).collect(Collectors.toList());
        }
        return null;
    }

    @Nullable
    private static String stringOrNull(@Nullable Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Nullable
    private static Boolean booleanOrNull(@Nullable Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return null;
    }

    @Nullable
    private static Long longOrNull(@Nullable Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return null;
    }

    @Nullable
    private static Double doubleOrNull(@Nullable Object value) {
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return null;
    }

    @Nullable
    public DeclarativeConfigProperties getStructured(String name) {
        return this.mapEntries.get(name);
    }

    @Nullable
    public List<DeclarativeConfigProperties> getStructuredList(String name) {
        List<YamlDeclarativeConfigProperties> value = this.listEntries.get(name);
        if (value != null) {
            return Collections.unmodifiableList(value);
        }
        return null;
    }

    public Set<String> getPropertyKeys() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        keys.addAll(this.simpleEntries.keySet());
        keys.addAll(this.listEntries.keySet());
        keys.addAll(this.mapEntries.keySet());
        return Collections.unmodifiableSet(keys);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "YamlDeclarativeConfigProperties{", "}");
        this.simpleEntries.forEach((key, value) -> joiner.add(key + "=" + value));
        this.listEntries.forEach((key, value) -> joiner.add(key + "=" + value));
        this.mapEntries.forEach((key, value) -> joiner.add(key + "=" + value));
        return joiner.toString();
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.simpleEntries);
        this.listEntries.forEach((key, value) -> result.put((String)key, value.stream().map(YamlDeclarativeConfigProperties::toMap).collect(Collectors.toList())));
        this.mapEntries.forEach((key, value) -> result.put((String)key, value.toMap()));
        return Collections.unmodifiableMap(result);
    }

    public ComponentLoader getComponentLoader() {
        return this.componentLoader;
    }
}

