/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.history;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;

public class AsOfSCNClause
extends AsOfClause {
    public AsOfSCNClause(Number systemChangeNumber) {
        super(systemChangeNumber);
    }

    public AsOfSCNClause(Long systemChangeNumber) {
        super(systemChangeNumber);
    }

    public AsOfSCNClause(long systemChangeNumber) {
        super((Long)systemChangeNumber);
    }

    public AsOfSCNClause(Expression expression) {
        super(expression);
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer) {
        printer.printString("AS OF SCN (");
        Object value = this.getValue();
        if (value instanceof Expression) {
            if (value instanceof ConstantExpression && ((ConstantExpression)value).getValue() instanceof String) {
                printer.printString((String)((ConstantExpression)value).getValue());
            } else {
                printer.printExpression((Expression)value);
            }
        } else {
            ConversionManager converter = ConversionManager.getDefaultManager();
            value = converter.convertObject(value, ClassConstants.LONG);
            printer.printPrimitive(value, true);
        }
        printer.printString(")");
    }

    @Override
    public boolean isAsOfSCNClause() {
        return true;
    }
}

