/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.aot.generate.ClassNameGenerator;
import org.springframework.aot.generate.DefaultGenerationContext;
import org.springframework.aot.generate.FileSystemGeneratedFiles;
import org.springframework.aot.generate.GeneratedFiles;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.context.aot.AbstractAotProcessor;
import org.springframework.context.aot.ApplicationContextAotGenerator;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.javapoet.ClassName;
import org.springframework.util.CollectionUtils;

public abstract class ContextAotProcessor
extends AbstractAotProcessor<ClassName> {
    private final Class<?> applicationClass;

    protected ContextAotProcessor(Class<?> applicationClass, AbstractAotProcessor.Settings settings) {
        super(settings);
        this.applicationClass = applicationClass;
    }

    protected Class<?> getApplicationClass() {
        return this.applicationClass;
    }

    @Override
    protected ClassName doProcess() {
        this.deleteExistingOutput();
        GenericApplicationContext applicationContext = this.prepareApplicationContext(this.getApplicationClass());
        return this.performAotProcessing(applicationContext);
    }

    protected abstract GenericApplicationContext prepareApplicationContext(Class<?> var1);

    protected ClassName performAotProcessing(GenericApplicationContext applicationContext) {
        FileSystemGeneratedFiles generatedFiles = this.createFileSystemGeneratedFiles();
        DefaultGenerationContext generationContext = new DefaultGenerationContext(this.createClassNameGenerator(), (GeneratedFiles)generatedFiles);
        ApplicationContextAotGenerator generator = new ApplicationContextAotGenerator();
        ClassName generatedInitializerClassName = generator.processAheadOfTime(applicationContext, (GenerationContext)generationContext);
        this.registerEntryPointHint(generationContext, generatedInitializerClassName);
        generationContext.writeGeneratedContent();
        this.writeHints(generationContext.getRuntimeHints());
        this.writeNativeImageProperties(this.getDefaultNativeImageArguments(this.getApplicationClass().getName()));
        return generatedInitializerClassName;
    }

    protected ClassNameGenerator createClassNameGenerator() {
        return new ClassNameGenerator(ClassName.get(this.getApplicationClass()));
    }

    protected List<String> getDefaultNativeImageArguments(String applicationClassName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-H:Class=" + applicationClassName);
        args.add("--report-unsupported-elements-at-runtime");
        args.add("--no-fallback");
        args.add("--install-exit-handlers");
        return args;
    }

    private void registerEntryPointHint(DefaultGenerationContext generationContext, ClassName generatedInitializerClassName) {
        TypeReference generatedType = TypeReference.of((String)generatedInitializerClassName.canonicalName());
        TypeReference applicationType = TypeReference.of(this.getApplicationClass());
        ReflectionHints reflection = generationContext.getRuntimeHints().reflection();
        reflection.registerType(applicationType, new MemberCategory[0]);
        reflection.registerType(generatedType, typeHint -> typeHint.onReachableType(applicationType).withConstructor(Collections.emptyList(), ExecutableMode.INVOKE));
    }

    private void writeNativeImageProperties(List<String> args) {
        if (CollectionUtils.isEmpty(args)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Args = ");
        sb.append(String.join((CharSequence)String.format(" \\%n", new Object[0]), args));
        Path file = this.getSettings().getResourceOutput().resolve("META-INF/native-image/" + this.getSettings().getGroupId() + "/" + this.getSettings().getArtifactId() + "/native-image.properties");
        try {
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.createFile(file, new FileAttribute[0]);
            }
            Files.writeString(file, (CharSequence)sb.toString(), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to write native-image.properties", ex);
        }
    }
}

